/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
var lon = 5;
var lat = 40;
var zoom = 5;
var map;

function init(url, title) {
    map = new OpenLayers.Map('so-cartography-map');

    var wms = new OpenLayers.Layer.WMS(
        "OpenLayers WMS",
        "http://labs.metacarta.com/wms/vmap0",
        {layers: 'basic'}
    );

    var kml = new OpenLayers.Layer.GML(title, url, {
            format: OpenLayers.Format.KML,
            formatOptions: {
                extractStyles: true,
                extractAttributes: true
            }
    });

//    var kml = new OpenLayers.Layer.Vector(title, {
//        projection: new OpenLayers.Projection("EPSG:4326"),
//        strategies: [new OpenLayers.Strategy.Fixed()],
//        protocol: new OpenLayers.Protocol.HTTP({
//            url: url,
//            format: new OpenLayers.Format.KML({
//                extractStyles: true,
//                extractAttributes: true
//            })
//        })
//    });


    map.addLayers([wms, kml]);

    select = new OpenLayers.Control.SelectFeature(kml);

    kml.events.on({
        "featureselected": onFeatureSelect,
        "featureunselected": onFeatureUnselect
    });

    map.addControl(select);
//    map.addControl( new OpenLayers.Control.LayerSwitcher() );

    select.activate();

    // Center on Chateauroux
    var center = new OpenLayers.LonLat(1.032715,46.637368);
    map.setCenter(center, 6);
//    map.zoomToMaxExtent();
}

function onPopupClose(event) {
    select.unselectAll();
}

function onFeatureSelect(event) {
    var feature = event.feature;
    // Since KML is user-generated, do naive protection against
    // Javascript.
    var content = "<strong>" + feature.attributes.name + "</strong>" + feature.attributes.description;
    if (content.search("<script") != -1) {
        content = "Content contained Javascript! Escaped content below.<br />" + content.replace(/</g, "&lt;");
    }
    popup = new OpenLayers.Popup.FramedCloud(
             "bubble",
             feature.geometry.getBounds().getCenterLonLat(),
             new OpenLayers.Size(100, 100),
             content,
             null,
             true,
             onPopupClose
    );
    feature.popup = popup;
    map.addPopup(popup);
}

function onFeatureUnselect(event) {
    var feature = event.feature;
    if(feature.popup) {
        map.removePopup(feature.popup);
        feature.popup.destroy();
        delete feature.popup;
    }
}