/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.CompanyImpl;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.services.WaoManager;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.BeanEditForm;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.services.BeanModelSource;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.slf4j.Logger;

@RequiresAuthentication(value={UserRole.ADMIN}, readOnlyAllowed=false)
@IncludeStylesheet(value={"context:css/administration.css"})
public class Administration {
    @Inject
    private Logger logger;
    @InjectComponent
    private Layout layout;
    @SessionState
    private WaoUser currentUser;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private TypeCoercer typeCoercer;
    @Property
    private String companyId;
    @Property
    private String userId;
    @Persist
    private List<Company> companies;
    @Inject
    private PropertyAccess propertyAccess;
    private GenericSelectModel<Company> companiesSelectModel;
    private Company company;
    private GenericSelectModel<WaoUser> usersSelectModel;
    @InjectComponent
    private BeanEditForm userForm;
    private boolean addNewCompanySelected;
    private boolean addNewUserSelected;
    private boolean deleteUserSelected;
    @Property
    private UploadedFile fishingZoneCsvFile;
    @Inject
    private Messages messages;
    @Inject
    private WaoManager manager;
    @Inject
    private BeanModelSource beanModelSource;
    @Persist
    private WaoUser user;
    @InjectComponent
    private Zone userFormZone;
    @Persist
    private BeanModel<WaoUser> userModel;
    @Property
    private boolean generatePassword;
    @Property
    private String password;
    @InjectComponent
    private Zone userRoleZone;
    @Persist
    @Property
    private UserRole userRole;
    @Persist
    @Property
    private boolean readOnly;
    @Property
    private UserRole role;
    @Property
    private int roleIndex;
    @Property
    private boolean refreshUserRoleZone;

    void setupRender() throws WaoException {
        this.companies = null;
        this.getCompanies();
        this.user = null;
        this.userModel = null;
    }

    void onActivate(EventContext ec) {
        if (ec.getCount() > 0) {
            this.companyId = (String)ec.get(String.class, 0);
            if (ec.getCount() > 1) {
                this.userId = (String)ec.get(String.class, 1);
            }
        }
    }

    Object[] onPassivate() {
        return new String[]{this.companyId, this.userId};
    }

    @Log
    void onSuccessFromImportFishingZones() {
        try {
            int result = this.serviceReferential.importFishingZoneCsv(this.fishingZoneCsvFile.getStream());
            this.layout.addInfo(result + " zones de p\u00eache import\u00e9es");
        }
        catch (WaoException eee) {
            String[] errors = this.manager.getErrorMessages(eee, this.messages, this.logger);
            this.layout.addError(errors);
        }
    }

    public List<Company> getCompanies() throws WaoException {
        if (this.companies == null) {
            this.companies = this.serviceUser.getCompanies(false);
        }
        return this.companies;
    }

    public GenericSelectModel<Company> getCompaniesSelectModel() throws WaoException {
        if (this.companiesSelectModel == null) {
            this.companiesSelectModel = new GenericSelectModel(this.getCompanies(), Company.class, "name", "id", this.propertyAccess);
        }
        return this.companiesSelectModel;
    }

    public Company getCompany() throws WaoException {
        if (this.company == null) {
            this.company = this.companyId != null ? (Company)this.getCompaniesSelectModel().findObject(this.companyId) : new CompanyImpl();
        }
        return this.company;
    }

    public boolean isUsersAvailable() throws WaoException {
        return !StringUtils.isEmpty((String)this.getCompany().getId()) && this.getCompany().getActive();
    }

    void onSelectedFromAddNewCompany() {
        this.addNewCompanySelected = true;
    }

    void onSuccessFromActionsForm() {
        if (this.addNewCompanySelected) {
            this.companyId = null;
        }
        this.userId = null;
        this.user = null;
    }

    void onSuccessFromCompany() throws WaoException {
        this.serviceUser.createUpdateCompany(this.company);
        this.companyId = this.company.getId();
    }

    @Log
    public GenericSelectModel<WaoUser> getUsersSelectModel() throws WaoException {
        if (this.usersSelectModel == null) {
            List users = this.serviceUser.getUsersByCompany(this.getCompany());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Nb users : " + users.size());
            }
            this.usersSelectModel = new GenericSelectModel(users, WaoUser.class, "fullName", "id", this.propertyAccess);
        }
        return this.usersSelectModel;
    }

    public WaoUser getUser() throws WaoException {
        if (this.user == null) {
            if (this.userId != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("User exist in selectModel : " + this.userId);
                }
                this.user = (WaoUser)this.getUsersSelectModel().findObject(this.userId);
            } else {
                this.user = this.serviceUser.getNewUser(this.getCompany());
                this.generatePassword = true;
            }
        }
        return this.user;
    }

    @Log
    void onSelectedFromAddNewUser() {
        this.addNewUserSelected = true;
    }

    @Log
    void onSelectedFromDeleteUser() {
        this.deleteUserSelected = true;
    }

    @Log
    void onSuccessFromUserActionsForm() throws WaoException {
        if (this.addNewUserSelected) {
            this.userId = null;
        } else if (this.deleteUserSelected && this.userId != null) {
            this.user = (WaoUser)this.getUsersSelectModel().findObject(this.userId);
            try {
                this.serviceUser.deleteUser(this.user);
                this.user = null;
                this.userId = null;
                this.layout.addInfo("Utilisateur supprim\u00e9 avec succ\u00e8s !");
            }
            catch (WaoBusinessException eee) {
                this.layout.addError(new String[]{eee.getMessage()});
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("'User id : " + this.userId);
        }
    }

    public BeanModel<WaoUser> getUserModel() {
        if (this.userModel == null) {
            this.userModel = this.beanModelSource.createEditModel(WaoUser.class, this.messages);
            this.userModel.add("userRole", null);
            this.userModel.include(new String[]{"firstName", "lastName", "login", "password", "phoneNumber", "userRole", "active"});
        }
        return this.userModel;
    }

    @Log
    void onSelectedFromUserForm() {
        this.refreshUserRoleZone = false;
    }

    @Log
    void onValidateFormFromUserForm() {
        this.userForm.clearErrors();
        if (this.user.getUserRoles().isEmpty()) {
            this.userForm.recordError("L'utilisateur doit au minimum avoir un r\u00f4le.");
        }
    }

    @Log
    Object onSuccessFromUserForm() throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("User : " + this.user);
        }
        if (!StringUtils.isEmpty((String)this.password)) {
            this.user.setPassword(this.password);
            this.user.setPasswordChanged(true);
        }
        try {
            this.serviceUser.createUpdateUser(this.user, this.generatePassword);
            this.userId = this.user.getId();
        }
        catch (WaoBusinessException eee) {
            if (eee.getType().equals((Object)WaoBusinessException.Type.SMTP_NOT_FOUND)) {
                this.layout.addInfo(eee.getMessage());
                this.userId = this.user.getId();
            }
            this.layout.addError(new String[]{eee.getMessage()});
        }
        return this;
    }

    @Log
    Object onFailureFromUserForm() {
        return this.userForm;
    }

    public String getRoleReadOnly() {
        String text = "";
        if (this.user.isReadOnly(this.role)) {
            text = "lecture seule";
        }
        return text;
    }

    @Log
    void onChangeFromUserRole(String value) {
        this.userRole = StringUtils.isNotEmpty((String)value) ? UserRole.valueOf((String)value) : null;
    }

    @Log
    void onChangeFromReadOnly(boolean value) {
        this.readOnly = value;
    }

    @Log
    Object onActionFromAddRole() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Add userRole : " + this.userRole + " (readOnly=" + this.readOnly + ")");
        }
        if (this.userRole != null) {
            this.user.addUserRole(this.userRole, this.readOnly);
        }
        this.userRole = null;
        this.readOnly = false;
        this.refreshUserRoleZone = true;
        return this.userRoleZone;
    }

    @Log
    Object onActionFromRemoveRole(int roleIndex) {
        UserRole roleToRemove = (UserRole)this.user.getUserRoles().get(roleIndex);
        this.user.removeUserRole(roleToRemove);
        this.refreshUserRoleZone = true;
        return this.userRoleZone;
    }
}

