/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.bean.ContactState;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.FishingZone;
import fr.ifremer.wao.entity.Profession;
import fr.ifremer.wao.entity.SampleRow;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class BusinessUtils {
    public static String getTooltipSampleRow(SampleRow row) {
        StringBuilder result = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/yyyy");
        Profession profession = row.getProfession();
        result.append("<strong>M\u00e9tier : </strong>").append(profession.getCodeDCF5());
        if (!StringUtils.isEmpty((String)profession.getMeshSize())) {
            result.append(' ').append(profession.getMeshSize());
        }
        if (!StringUtils.isEmpty((String)profession.getSize())) {
            result.append(' ').append(profession.getSize());
        }
        if (!StringUtils.isEmpty((String)profession.getOther())) {
            result.append(' ').append(profession.getOther());
        }
        result.append(" - ").append(profession.getLibelle());
        if (!StringUtils.isEmpty((String)profession.getSpecies())) {
            result.append("<br /><strong>Esp\u00e8ces cibles : </strong>").append(profession.getSpecies());
        }
        result.append("<br /><strong>Programme : </strong>").append(row.getProgramName()).append("<br /><strong>P\u00e9riode : </strong> du ").append(dateFormat.format(row.getPeriodBegin())).append(" au ").append(dateFormat.format(row.getPeriodEnd()));
        for (FishingZone zone : row.getFishingZone()) {
            result.append("<br /><strong>Zone de p\u00eache : </strong>").append(zone.getCode());
        }
        return result.toString();
    }

    public static String getTooltipBoat(Boat boat) {
        StringBuilder result = new StringBuilder("<strong>").append(boat.getImmatriculation()).append("</strong>").append("<br /><strong>Quartier : </strong>").append(boat.getDistrictCode()).append("<br /><strong>Longueur : </strong>").append(boat.getBoatLength()).append(" m").append("<br /><strong>Ann\u00e9e de construction : </strong>").append(boat.getBuildYear());
        return result.toString();
    }

    public static String getDataSamplingTitle(SamplingFilter filter) {
        StringBuilder result = new StringBuilder("Donn\u00e9es des mar\u00e9es");
        String separator = " : ";
        if (filter.getCompany() != null) {
            result.append(separator).append("\nSoci\u00e9t\u00e9 ").append(filter.getCompany().getName());
            separator = ", ";
        }
        if (StringUtils.isNotEmpty((String)filter.getProgramName())) {
            result.append(separator).append("\nProgramme ").append(filter.getProgramName());
            separator = ", ";
        }
        if (filter.getSampleRow() != null) {
            Profession profession = filter.getSampleRow().getProfession();
            result.append(separator).append("\nM\u00e9tier ").append(profession.getCode());
            if (StringUtils.isNotEmpty((String)profession.getLibelle())) {
                result.append(" - ").append(profession.getLibelle());
            }
            if (StringUtils.isNotEmpty((String)profession.getSpecies())) {
                result.append("\nEsp\u00e8ces (").append(profession.getSpecies()).append(")");
            }
            result.append("\nZones de p\u00eache (");
            for (FishingZone zone : filter.getSampleRow().getFishingZone()) {
                result.append(zone.getDistrictCode()).append(' ');
            }
            result.append(")");
            separator = ", ";
        } else {
            if (filter.getFacadeName() != null) {
                result.append(separator).append("\nFa\u00e7ade ").append(filter.getFacadeName());
                separator = ", ";
            }
            if (filter.getSectorName() != null) {
                result.append(separator).append("\nZone ").append(filter.getSectorName());
            }
        }
        return result.toString();
    }

    public static String getContactStyle(Contact contact, boolean admin) {
        String result = "";
        boolean accepted = BooleanUtils.isTrue((Boolean)contact.getValidationProgram()) || !admin && BooleanUtils.isTrue((Boolean)contact.getValidationCompany());
        ContactState state = contact.getContactState();
        result = BooleanUtils.isFalse((Boolean)contact.getValidationProgram()) || !admin && BooleanUtils.isFalse((Boolean)contact.getValidationCompany()) ? "refused" : (accepted && state.equals((Object)ContactState.BOARDING_DONE) ? "accepted" : (accepted && state.isUnfinishedState() ? "unfinished" : (state.isFinalState() ? "even" : "odd")));
        return result;
    }
}

