/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: WaoManager.java 462 2010-04-19 23:41:59Z tchemit $
 * $HeadURL: svn+ssh://fdesbois@labs.libre-entreprise.org/svnroot/suiviobsmer/tags/wao-1.2.1/wao-ui/src/main/java/fr/ifremer/wao/ui/services/WaoManager.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoContext;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.WaoProperty;
import fr.ifremer.wao.service.ServiceUser;
import java.util.Date;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.nuiton.util.ApplicationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * WaoManager
 *
 * Created: 24 nov. 2009
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
public class WaoManager implements Runnable, RegistryShutdownListener {

    private static final Logger log =
            LoggerFactory.getLogger(WaoManager.class);

    private WaoContext context;

    private ServiceUser serviceUser;

    /**
     * Constructor of WaoManager. It needs the WaoContext to start and stop.
     *
     * @param context used to manage application lifecycle
     */
    public WaoManager(WaoContext context) {
        this.context = context;
    }

    /**
     * ServiceUser is needed to start the application.
     *
     * @param serviceUser
     * @see fr.ifremer.wao.WaoContext#start(fr.ifremer.wao.service.ServiceUser) 
     */
    void setServiceUser(ServiceUser serviceUser) {
        this.serviceUser = serviceUser;
    }

    /**
     * Called to start the application.
     */
    @Override
    public void run() {
        context.start(serviceUser);
    }

    /**
     * Called to stop the application
     */
    @Override
    public void registryDidShutdown() {
        context.stop();
    }

    /**
     * Context to inject in new service instances.
     *
     * @return the WaoContext of the application
     */
    WaoContext getContext() {
        return context;
    }

    public boolean isActivityCalendarImportRun() {
        return context.isActivityCalendarImportRun();
    }

    public String getProperty(WaoProperty property) {
        return context.getProperty(property);
    }

    public ApplicationConfig getConfiguration() {
        return context.getConfiguration();
    }

    public Date getCurrentDate() {
        return context.getCurrentDate();
    }

    public boolean isDevEnvironment() {
        return log.isDebugEnabled();
    }

    public String[] getErrorMessages(WaoException eee, Messages messages,
            Logger logger) {

        String[] results = null;
        String cause = null;
        // Only show cause on dev environment
        if (eee.getCause() != null && isDevEnvironment()) {
            cause = eee.getCause().getClass().getSimpleName() +
                        " : " + eee.getCause().getMessage();
            results = new String[2];
            results[1] = cause;
        } else {
            results = new String[1];
        }


        if (logger.isDebugEnabled()) {
            logger.debug("ERROR from business : " + eee.getMessage() +
                    " _ args = " + eee.getArgs());
            if (cause != null) {
                logger.debug("ERROR caused by : " + cause);
            }
        }

        if (eee.getArgs() != null) {
            results[0] = messages.format(eee.getMessage(), eee.getArgs());
        } else {
            results[0] = messages.get(eee.getMessage());
        }
        return results;
    }

    public String getErrorMessage(WaoBusinessException eee, Messages messages,
            Logger logger) {
        if (logger.isDebugEnabled()) {
            logger.debug("ERROR from business : " + eee.getMessage());
        }
        return eee.getMessage();
    }

    

}
