/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.BoatFilter;
import fr.ifremer.wao.bean.ContactFilter;
import fr.ifremer.wao.bean.ContactFilterImpl;
import fr.ifremer.wao.bean.ContactState;
import fr.ifremer.wao.bean.ImportResults;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.service.ServiceContact;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.base.AbstractFilteredPage;
import fr.ifremer.wao.ui.base.GenericSelectModel;
import fr.ifremer.wao.ui.base.WaoPage;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.BusinessUtils;
import fr.ifremer.wao.ui.data.ContactDataSource;
import fr.ifremer.wao.ui.pages.Contacts;
import fr.ifremer.wao.ui.services.ContactModelFactory;
import fr.ifremer.wao.ui.services.WaoManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.BeanModelSource;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.nuiton.util.DateUtils;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/contacts.css"})
public class Contacts
extends AbstractFilteredPage
implements WaoPage {
    @Inject
    private Logger log;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private WaoUser user;
    @Inject
    private ServiceContact serviceContact;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceBoat serviceBoat;
    @Persist
    private ContactFilter contactFilter;
    @InjectComponent
    private Zone filtersZone;
    @InjectComponent
    private Zone importExportZone;
    private boolean reset;
    @Property
    private ContactState stateFilter;
    @Property
    private UploadedFile contactsCsvFile;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private BeanModelSource beanModelSource;
    @Inject
    private ComponentResources resources;
    @Inject
    private ContactModelFactory contactModelFactory;
    @Persist
    private ContactDataSource contacts;
    @Property
    private Contact contact;
    private BeanModel<Contact> contactModel;
    @Inject
    private PropertyAccess propertyAccess;
    private GenericSelectModel<WaoUser> userSelectModel;
    @Property
    @Persist(value="flash")
    private String contactUserId;
    private boolean even = true;
    private boolean edited;
    private boolean deleted;
    @Persist
    @Property
    private Contact contactEdited;
    @Persist
    private String oldComment;
    @Persist(value="flash")
    private String contactSelectedId;
    @InjectComponent
    private Form contactsForm;
    @InjectComponent
    private Zone gridZone;
    @InjectComponent
    private Field beginDate;
    @InjectComponent
    private Field endDate;
    @InjectComponent
    private Field nbObservants;
    @InjectComponent
    private Field comment;
    @InjectComponent
    private Field inputDate;
    @Inject
    private WaoManager manager;

    public boolean canDisplay() {
        return true;
    }

    @Log
    void setupRender() throws WaoException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("RESET DATA");
        }
        this.initSelectFilters(true, true, false);
        this.contacts = null;
        this.getContacts();
        this.contactsForm.clearErrors();
    }

    public ContactFilter getContactFilter() throws WaoException {
        if (this.contactFilter == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Init contactFilter");
            }
            this.contactFilter = new ContactFilterImpl();
            Date fromDate = DateUtils.createDateAfterToday((int)0, (int)-3, (int)0);
            this.contactFilter.setFromDate(fromDate);
        }
        return this.contactFilter;
    }

    public boolean isFiltersVisible() {
        boolean companyFiltered = this.contactFilter.getCompany() != null && this.user.isAdmin();
        return (this.contactFilter.isFiltered() || companyFiltered) && StringUtils.isEmpty((String)this.contactFilter.getBoatName());
    }

    protected BoatFilter getFilter() throws WaoException {
        return this.getContactFilter();
    }

    protected boolean isAvailableDataForFiltersOnly() {
        return true;
    }

    Object onActionFromShowFilters() {
        return this.filtersZone.getBody();
    }

    Object onActionFromShowImportExport() {
        return this.importExportZone.getBody();
    }

    void onSelectedFromReset() {
        this.reset = true;
    }

    @Log
    Object onSuccessFromFiltersForm() throws WaoException {
        if (this.isEdited()) {
            return this.filtersZone.getBody();
        }
        if (this.reset) {
            this.contactFilter = null;
        }
        return this;
    }

    public boolean canImportExport() {
        return (this.user.isAdmin() || this.user.getUserRole().equals((Object)UserRole.COORDINATOR)) && !this.user.getReadOnly();
    }

    @Log
    void onSuccessFromImportContacts() throws WaoException {
        if (this.canImportExport()) {
            try {
                ImportResults result = this.serviceContact.importContactCsv(this.user, this.contactsCsvFile.getStream());
                this.contacts = null;
                this.layout.addInfo(result.getNbRowsImported() + " contacts " + "import\u00e9s,  " + result.getNbRowsRefused() + " refus\u00e9s.");
                for (String error : result.getErrors()) {
                    this.layout.addInfo(error);
                }
            }
            catch (WaoBusinessException eee) {
                this.layout.addError(new String[]{eee.getMessage()});
            }
        }
    }

    StreamResponse onActionFromExportShowContacts() {
        if (this.canImportExport()) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        return null;
    }

    public ContactDataSource getContacts() throws WaoException {
        if (this.contacts == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Create DataSource");
            }
            this.contacts = new ContactDataSource(this.getContactFilter(), this.serviceContact);
        }
        return this.contacts;
    }

    public BeanModel<Contact> getContactModel() {
        if (this.contactModel == null) {
            this.contactModel = this.user.isAdmin() ? this.contactModelFactory.buildAdminContactModel(this.beanModelSource, this.resources) : this.contactModelFactory.buildContactModel(this.beanModelSource, this.resources);
        }
        return this.contactModel;
    }

    public GenericSelectModel<WaoUser> getUserSelectModel() {
        if (this.userSelectModel == null) {
            List users = this.serviceUser.getUsersByCompany(this.user.getCompany());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Nb users : " + users.size());
            }
            this.userSelectModel = new GenericSelectModel(users, WaoUser.class, "fullName", "id", this.propertyAccess);
        }
        return this.userSelectModel;
    }

    public String getCommentDisplayed() {
        if (this.contact.getComment() != null && this.contact.getComment().length() > 20) {
            return this.contact.getComment().substring(0, 20) + "...";
        }
        return this.contact.getComment();
    }

    public String getCommentTooltip() {
        return this.contact.getComment().replaceAll("\n", "<br />").replaceAll("\r", "");
    }

    public String getSampleRowDescription() {
        return BusinessUtils.getTooltipSampleRow((SampleRow)this.contact.getSampleRow());
    }

    public String getBoatDescription() {
        return BusinessUtils.getTooltipBoat((Boat)this.contact.getBoat());
    }

    public String getTooltipExportFrom() throws WaoException {
        if (this.getContactFilter().getFromDate() != null) {
            return "depuis le " + this.getDateFormat().format(this.getContactFilter().getFromDate());
        }
        return "";
    }

    public String getGridClass() {
        return this.user.isAdmin() ? "admin" : "user";
    }

    public String getRowClass() {
        String result = BusinessUtils.getContactStyle((Contact)this.contact, (boolean)this.user.isAdmin());
        if (this.contact.getTopiaId().equals(this.contactSelectedId)) {
            result = "selected";
        }
        return result;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public boolean isEditionMode() {
        return this.contactEdited != null && this.contact.equals(this.contactEdited);
    }

    public boolean isEmpty(Boolean validation) {
        return validation == null;
    }

    public boolean hasActions() {
        return !this.user.isAdmin() && this.contact.getValidationCompany() == null && !this.user.getReadOnly();
    }

    public boolean hasValidationActions() {
        return (this.user.isAdmin() || this.user.getUserRole().equals((Object)UserRole.COORDINATOR)) && !this.user.getReadOnly();
    }

    public boolean canValidate() {
        if (this.isEditionMode()) {
            return false;
        }
        switch (2.$SwitchMap$fr$ifremer$wao$bean$UserRole[this.user.getUserRole().ordinal()]) {
            case 1: {
                return this.contact.getValidationProgram() == null && BooleanUtils.isTrue((Boolean)this.contact.getValidationCompany());
            }
            case 2: {
                ContactState state = this.contact.getContactState();
                boolean boardingDone = state.equals((Object)ContactState.BOARDING_DONE) && this.contact.getDataInputDate() != null;
                return this.contact.getValidationCompany() == null && (state.isUnfinishedState() || boardingDone);
            }
        }
        return false;
    }

    public boolean canUnvalidate() {
        switch (2.$SwitchMap$fr$ifremer$wao$bean$UserRole[this.user.getUserRole().ordinal()]) {
            case 1: {
                return this.contact.getValidationProgram() != null;
            }
            case 2: {
                return this.contact.getValidationCompany() != null && this.contact.getValidationProgram() == null;
            }
        }
        return false;
    }

    void onSelectedFromAcceptContact(String contactId) throws WaoException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Accept contact : " + contactId);
        }
        this.contactEdited = (Contact)this.getContacts().get((Object)contactId);
        if (this.user.isAdmin()) {
            this.contactEdited.setValidationProgram(Boolean.TRUE);
        } else {
            this.contactEdited.getSampleRow().addRealTideTime(this.contactEdited);
            this.contactEdited.setValidationCompany(Boolean.TRUE);
        }
    }

    void onSelectedFromRefuseContact(String contactId) throws WaoException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Refuse contact : " + contactId);
        }
        this.contactEdited = (Contact)this.getContacts().get((Object)contactId);
        if (this.user.isAdmin()) {
            this.contactEdited.getSampleRow().removeRealTideTime(this.contactEdited);
            this.contactEdited.setValidationProgram(Boolean.FALSE);
        } else {
            this.contactEdited.setValidationCompany(Boolean.FALSE);
        }
    }

    void onSelectedFromUnvalidateContact(String contactId) throws WaoException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unvalidate contact : " + contactId);
        }
        this.contactEdited = (Contact)this.getContacts().get((Object)contactId);
        if (this.user.isAdmin()) {
            if (BooleanUtils.isFalse((Boolean)this.contactEdited.getValidationProgram())) {
                this.contactEdited.getSampleRow().addRealTideTime(this.contactEdited);
            }
            this.contactEdited.setValidationProgram(null);
        } else {
            if (BooleanUtils.isTrue((Boolean)this.contactEdited.getValidationCompany())) {
                this.contactEdited.getSampleRow().removeRealTideTime(this.contactEdited);
            }
            this.contactEdited.setValidationCompany(null);
        }
    }

    void onSelectedFromEditContact(String contactId) throws WaoException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Edit contact : " + contactId);
        }
        this.contactEdited = (Contact)this.getContacts().get((Object)contactId);
        this.contactUserId = this.contactEdited.getObserver().getTopiaId();
        this.contactSelectedId = contactId;
        this.oldComment = this.contactEdited.getComment();
        this.edited = true;
    }

    void onSelectedFromDeleteContact(String contactId) throws WaoException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Delete contact : " + contactId);
        }
        this.contactEdited = (Contact)this.getContacts().get((Object)contactId);
        this.deleted = true;
    }

    void onSelectedFromSaveContact(String contactId) throws WaoException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Save contact : " + contactId);
        }
        WaoUser contactUser = (WaoUser)this.getUserSelectModel().findObject(this.contactUserId);
        this.contactEdited.setObserver(contactUser);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Comment : " + this.contactEdited.getComment());
        }
    }

    void onSelectedFromCancelEditContact() throws WaoException {
        this.contactEdited = null;
        this.edited = true;
    }

    @Log
    void onValidateFormFromContactsForm() {
        this.contactsForm.clearErrors();
        if (!this.edited && this.contactEdited != null) {
            ContactState contactState = this.contactEdited.getContactState();
            if (this.log.isInfoEnabled()) {
                this.log.info("For state : " + contactState);
            }
            Date begin = this.contactEdited.getTideBeginDate();
            Date end = this.contactEdited.getTideEndDate();
            Date input = this.contactEdited.getDataInputDate();
            SampleRow row = this.contactEdited.getSampleRow();
            if (begin != null && !row.isValid(begin)) {
                this.contactsForm.recordError(this.beginDate, "La date de d\u00e9but de la mar\u00e9e doit correspondre \u00e0 un mois valide (non vide) de la ligne " + row.getCode());
            }
            if (begin != null && end != null && end.before(begin)) {
                this.contactsForm.recordError(this.endDate, "La date de fin de la mar\u00e9e ne peut pas \u00eatre ant\u00e9rieure \u00e0 celle de d\u00e9but");
            }
            Date current = this.manager.getCurrentDate();
            if (end != null && end.after(current)) {
                this.contactsForm.recordError(this.endDate, "La date de fin de la mar\u00e9e ne peut pas \u00eatre post\u00e9rieure \u00e0 la date du jour");
            }
            if (end != null && input != null && end.after(input)) {
                this.contactsForm.recordError(this.inputDate, "La date de saisie des donn\u00e9es ne peut pas \u00eatre ant\u00e9rieure \u00e0 la date de fin de la mar\u00e9e");
            }
            if (input != null && input.after(current)) {
                this.contactsForm.recordError(this.inputDate, "La date de saisie des donn\u00e9es ne peut pas \u00eatre post\u00e9rieure \u00e0 la date du jour");
            }
            if (contactState.isUnfinishedState()) {
                String newComment = this.contactEdited.getComment();
                if (StringUtils.isNotEmpty((String)newComment) && !newComment.equals(this.oldComment)) {
                    this.contactEdited.setTideBeginDate(null);
                    this.contactEdited.setTideEndDate(null);
                    this.contactEdited.setNbObservants(0);
                    this.contactEdited.setMammalsCapture(false);
                    this.contactEdited.setMammalsObservation(false);
                    this.contactEdited.setDataInputDate(null);
                } else {
                    this.contactsForm.recordError(this.comment, "Vous devez ajouter un commentaire pour l'\u00e9tat '" + contactState + "'");
                }
            } else if (contactState.equals((Object)ContactState.BOARDING_DONE)) {
                if (begin == null) {
                    this.contactsForm.recordError(this.beginDate, "La date de d\u00e9but de mar\u00e9e est obligatoire pour l'\u00e9tat '" + contactState + "'");
                }
                if (end == null) {
                    this.contactsForm.recordError(this.endDate, "La date de fin de mar\u00e9e est obligatoire pour l'\u00e9tat '" + contactState + "'");
                }
                if (this.contactEdited.getNbObservants() == 0) {
                    this.contactsForm.recordError(this.nbObservants, "Il ne peut y avoir aucun observateur pour l'\u00e9tat '" + contactState + "'");
                }
            }
        }
    }

    @Log
    Object onSuccessFromContactsForm() {
        if (!this.edited) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Contact save : " + this.contactEdited);
                }
                this.serviceContact.saveContact(this.contactEdited, this.deleted);
                this.contactSelectedId = this.contactEdited.getTopiaId();
                this.oldComment = null;
                this.contactEdited = null;
            }
            catch (WaoException eee) {
                this.layout.addError(new String[]{eee.getMessage()});
            }
        }
        return this;
    }

    @Log
    Object onFailureFromContactsForm() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Contact can't be saved with errors");
        }
        this.edited = true;
        return this.contactsForm;
    }

    public void createNewContact(Boat boat, SampleRow sampleRow) throws WaoException {
        this.contact = this.serviceContact.getNewContact(this.user, sampleRow, boat);
        if (boat != null && boat.canCreateContact(this.user.getCompany())) {
            this.serviceContact.saveContact(this.contact, Boolean.FALSE.booleanValue());
            this.contactSelectedId = this.contact.getTopiaId();
        } else {
            this.layout.addError(new String[]{"Un contact en cours existe d\u00e9j\u00e0 pour ce navire"});
        }
    }

    static /* synthetic */ ServiceContact access$000(Contacts x0) {
        return x0.serviceContact;
    }
}

