/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.BoardingResult;
import fr.ifremer.wao.bean.BoatFilter;
import fr.ifremer.wao.bean.BoatFilterImpl;
import fr.ifremer.wao.bean.ContactAverageReactivity;
import fr.ifremer.wao.bean.ContactState;
import fr.ifremer.wao.bean.ContactStateStatistics;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceSynthesis;
import fr.ifremer.wao.ui.base.AbstractFilteredPage;
import fr.ifremer.wao.ui.base.WaoPage;
import fr.ifremer.wao.ui.data.BusinessUtils;
import fr.ifremer.wao.ui.data.ChartUtils;
import fr.ifremer.wao.ui.data.SynthesisId;
import fr.ifremer.wao.ui.pages.Synthesis;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.jfree.chart.JFreeChart;
import org.nuiton.util.DateUtils;
import org.nuiton.util.PeriodDates;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/synthesis.css"})
public class Synthesis
extends AbstractFilteredPage
implements WaoPage {
    @Inject
    private ServiceSynthesis serviceSynthesis;
    @Inject
    private Logger log;
    @SessionState
    @Property
    private WaoUser user;
    @Persist
    private SynthesisId activeSynthesis;
    @Inject
    private ComponentResources resources;
    @InjectComponent
    private Zone delegator;
    @Persist
    private BoatFilter dataSamplingFilter;
    @InjectComponent
    private Zone filtersZone;
    @Persist
    private ChartUtils.ChartType dataSamplingChartType;
    private boolean reset;
    private BoardingResult boardingResult;
    @Persist
    private Company companyForBoarding;
    @Property
    private String companyIdForBoarding;
    private Map<String, Double> nonComplianceBoarding;
    @Property
    private Map.Entry<String, Double> nonComplianceBoardingEntry;
    private Collection<ContactStateStatistics> contactStateStatistics;
    @Persist
    private PeriodDates periodForContactStates;
    @Property
    private ContactStateStatistics contactStateStats;
    @Property
    private ContactState contactState;
    private Collection<ContactAverageReactivity> allegroReactivity;
    @Persist
    private PeriodDates periodForAllegroReactivity;
    @Property
    private ContactAverageReactivity allegroReactivityEntry;

    public boolean isOnlyForAdmin() {
        return false;
    }

    public Block getActiveBlock() throws WaoException {
        if (this.activeSynthesis == null) {
            this.activeSynthesis = SynthesisId.GRAPH_SAMPLING;
        }
        switch (1.$SwitchMap$fr$ifremer$wao$ui$data$SynthesisId[this.activeSynthesis.ordinal()]) {
            case 1: {
                this.initSamplingBlock();
                break;
            }
            case 2: {
                this.initBoardingBlock();
            }
        }
        return this.resources.getBlock(this.activeSynthesis.getBlockId());
    }

    public String getActionSynthesisId() {
        return SynthesisId.class.getName();
    }

    public String getActionChartType() {
        return ChartUtils.ChartType.class.getName();
    }

    public NumberFormat getPercentFormat() {
        return NumberFormat.getPercentInstance();
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public NumberFormat getNumberFormat() {
        NumberFormat result = NumberFormat.getNumberInstance();
        result.setMaximumFractionDigits(1);
        return result;
    }

    @Log
    Object onAction(String actionType, String actionValue) {
        if (actionType.equals(SynthesisId.class.getName())) {
            this.activeSynthesis = SynthesisId.valueOf((String)actionValue);
            return this.delegator.getBody();
        }
        if (actionType.equals(ChartUtils.ChartType.class.getName())) {
            this.dataSamplingChartType = ChartUtils.ChartType.valueOf((String)actionValue);
        }
        return this;
    }

    private void initSamplingBlock() throws WaoException {
        this.initSelectFilters(true, false, true);
    }

    public BoatFilter getFilter() throws WaoException {
        if (this.dataSamplingFilter == null) {
            this.dataSamplingFilter = new BoatFilterImpl();
            if (!this.user.getAdmin()) {
                this.dataSamplingFilter.setCompany(this.user.getCompany());
            }
        }
        return this.dataSamplingFilter;
    }

    public PeriodDates getPeriod() throws WaoException {
        if (this.getFilter().getPeriod() == null) {
            PeriodDates period = PeriodDates.createMonthsPeriodFromToday((int)-12);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Period : " + period);
            }
            this.getFilter().setPeriod(period);
        }
        return this.getFilter().getPeriod();
    }

    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    public JFreeChart getDataSamplingChart() throws WaoException {
        if (this.log.isInfoEnabled()) {
            this.log.info("BUSINESS REQUEST [getDataSampling]");
        }
        List res = this.serviceSynthesis.getDataSampling((SamplingFilter)this.getFilter());
        HashMap data = new HashMap();
        data.put("Planifi\u00e9", res.get(0));
        data.put("R\u00e9alis\u00e9", res.get(1));
        String title = BusinessUtils.getDataSamplingTitle((SamplingFilter)this.getFilter());
        return ChartUtils.createCategoryChart((String)title, (String)"Nb mar\u00e9es", (String)"Mois", (ChartUtils.ChartType)this.getDataSamplingChartType(), data);
    }

    public ChartUtils.ChartType getDataSamplingChartType() {
        if (this.dataSamplingChartType == null) {
            this.dataSamplingChartType = ChartUtils.ChartType.BAR;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("ChartType : " + this.dataSamplingChartType);
        }
        return this.dataSamplingChartType;
    }

    void onSelectedFromReset() {
        this.reset = true;
    }

    Object onSuccessFromFiltersForm() {
        if (this.isEdited()) {
            return this.filtersZone.getBody();
        }
        if (this.reset) {
            this.dataSamplingFilter = null;
        }
        return this;
    }

    private void initBoardingBlock() throws WaoException {
        this.resetCompanySelect();
        if (this.companyForBoarding != null && this.user.getAdmin()) {
            this.companyIdForBoarding = this.companyForBoarding.getTopiaId();
            if (this.log.isDebugEnabled()) {
                this.log.debug("companyId init : " + this.companyIdForBoarding);
            }
        }
    }

    public JFreeChart getBoardingBoatsChart() throws WaoException {
        HashMap<String, Map> data = new HashMap<String, Map>();
        data.put("Navires", this.getBoardingResult().getData());
        String title = "Sollicitations des navires depuis le " + this.getDateFormat().format(this.getFromDate());
        if (this.companyForBoarding != null) {
            title = title + "\nSoci\u00e9t\u00e9 " + this.companyForBoarding.getName();
        }
        return ChartUtils.createCategoryChart((String)title, (String)"Nb navires", (String)"Nb embarquements", (ChartUtils.ChartType)ChartUtils.ChartType.BAR, data);
    }

    public BoardingResult getBoardingResult() throws WaoException {
        if (this.boardingResult == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getBoardingBoats]");
            }
            this.boardingResult = this.serviceSynthesis.getBoardingBoats(this.getCompanyForBoarding(), this.getFromDate());
        }
        return this.boardingResult;
    }

    public Company getCompanyForBoarding() {
        if (this.companyForBoarding == null && !this.user.getAdmin()) {
            this.companyForBoarding = this.user.getCompany();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("company : " + this.companyForBoarding);
        }
        return this.companyForBoarding;
    }

    public Date getFromDate() {
        return DateUtils.createDateAfterToday((int)0, (int)-12, (int)0);
    }

    @Log
    void onSuccessFromFilterCompanyForBoarding() throws WaoException {
        this.companyForBoarding = (Company)this.getCompanySelectModel().findObject(this.companyIdForBoarding);
    }

    public Map<String, Double> getNonComplianceBoarding() throws WaoException {
        if (this.nonComplianceBoarding == null) {
            Company company = !this.user.getAdmin() ? this.user.getCompany() : null;
            this.nonComplianceBoarding = this.serviceSynthesis.getNonComplianceBoardingIndicator(company);
        }
        return this.nonComplianceBoarding;
    }

    public Double getNonComplianceBoardingValue() throws WaoException {
        return (Double)this.getNonComplianceBoarding().get(this.user.getCompany().getName());
    }

    public ContactState[] getContactStates() {
        return ContactState.values();
    }

    public Collection<ContactStateStatistics> getContactStateStatistics() throws WaoException {
        if (this.contactStateStatistics == null) {
            Company company = !this.user.getAdmin() ? this.user.getCompany() : null;
            this.contactStateStatistics = this.serviceSynthesis.getContactStateStatistics(company, this.getPeriodForContactStates());
        }
        return this.contactStateStatistics;
    }

    public PeriodDates getPeriodForContactStates() {
        if (this.periodForContactStates == null) {
            this.periodForContactStates = PeriodDates.createMonthsPeriodFromToday((int)-12);
        }
        return this.periodForContactStates;
    }

    public int getNbContactStates() {
        return (Integer)this.contactStateStats.getData().get(this.contactState);
    }

    public double getPercentContactStates() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("nbContactStates : " + this.getNbContactStates());
            this.log.debug("total : " + this.contactStateStats.getTotal());
        }
        return (double)this.getNbContactStates() / (double)this.contactStateStats.getTotal();
    }

    public Collection<ContactAverageReactivity> getAllegroReactivity() throws WaoException {
        if (this.allegroReactivity == null) {
            Company company = !this.user.getAdmin() ? this.user.getCompany() : null;
            this.allegroReactivity = this.serviceSynthesis.getContactDataInputDateReactivity(company, this.getPeriodForAllegroReactivity());
        }
        return this.allegroReactivity;
    }

    public PeriodDates getPeriodForAllegroReactivity() {
        if (this.periodForAllegroReactivity == null) {
            this.periodForAllegroReactivity = PeriodDates.createMonthsPeriodFromToday((int)-3);
        }
        return this.periodForAllegroReactivity;
    }

    public Double getAllegroReactivityValue() throws WaoException {
        ContactAverageReactivity entry = (ContactAverageReactivity)CollectionUtils.get((Object)this.getAllegroReactivity(), (int)0);
        return entry.getResult();
    }

    public String getAllegroReactivityStyle() throws WaoException {
        double value;
        double d = value = this.user.getAdmin() ? this.allegroReactivityEntry.getResult() : this.getAllegroReactivityValue().doubleValue();
        if (value >= 15.0) {
            return " warn";
        }
        return "";
    }
}

