/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ContactFilter;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.service.ServiceContact;
import fr.ifremer.wao.ui.data.AbstractMappedGridDataSource;
import java.util.Map;
import org.apache.tapestry5.grid.SortConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactDataSource
extends AbstractMappedGridDataSource<String, Contact> {
    private static Logger log = LoggerFactory.getLogger(ContactDataSource.class);
    private ContactFilter filter;
    private ServiceContact serviceContact;

    public ContactDataSource(ContactFilter filter, ServiceContact service) {
        this.filter = filter;
        this.serviceContact = service;
    }

    public Class<?> getRowType() {
        return Contact.class;
    }

    protected Map<String, Contact> execute(int startIndex, int endIndex, SortConstraint orderBy) throws WaoException {
        if (log.isInfoEnabled()) {
            log.info("BUSINESS REQUEST [getContactsByFilter]");
        }
        this.filter.setStartIndex(Integer.valueOf(startIndex));
        this.filter.setEndIndex(Integer.valueOf(endIndex));
        return this.serviceContact.getContacts(this.filter);
    }

    protected int count() throws WaoException {
        if (log.isInfoEnabled()) {
            log.info("BUSINESS REQUEST [getNbContacts]");
        }
        return this.serviceContact.getNbContacts(this.filter);
    }
}

