/*
 * *##% 
 * Wao :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.base.WaoPage;
import fr.ifremer.wao.ui.components.Layout;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.BeanEditForm;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;

/**
 * UserProfile
 *
 * Created: 10 nov. 2009
 *
 * @author fdesbois
 * @version $Revision: 355 $
 *
 * Mise a jour: $Date: 2010-02-16 14:56:07 +0100 (mar., 16 févr. 2010) $
 * par : $Author: fdesbois $
 */
@IncludeStylesheet("context:css/userProfile.css")
public class UserProfile implements WaoPage {

    @Override
    public boolean isOnlyForAdmin() {
        return false;
    }

    @Inject
    private Logger log;

    @Inject
    private ServiceUser serviceUser;

    @InjectComponent
    private Layout layout;

    @SessionState
    private WaoUser user;
    
    private WaoUser userEditable;

    @InjectComponent
    private BeanEditForm userForm;

    @Property
    private String password;

    @Property
    private String password2;

    public WaoUser getUserEditable() {
        if (userEditable == null) {
            userEditable = user;
        }
        return userEditable;
    }

    void onSuccessFromUserForm() throws WaoException {

        if (password != null && !password.equals(password2)) {
            userForm.recordError("Les deux password ne sont pas identiques, vérifiez la saisie !");
        } else {
            try {
                if (!StringUtils.isEmpty(password)) {
                    userEditable.setPassword(password);
                    userEditable.setPasswordChanged(true);
                }
                serviceUser.createUpdateUser(userEditable, false);
                layout.getFeedBack().addInfo("Modifications enregistrées avec succès !");
            } catch (WaoBusinessException eee) {
                userForm.recordError(eee.getMessage());
//                if (log.isErrorEnabled()) {
//                    log.error("Error during user save", eee);
//                }
            }
        }
    }


        
}
