/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.sampling;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.service.cruise.CruiseCacheAble;
import fr.ifremer.tutti.service.sampling.SamplingCodePrefix;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.mutable.MutableInt;

public class SamplingCodeCache
implements CruiseCacheAble {
    private final Map<Integer, MutableInt> highestSamplingCodeBySpecies = new TreeMap<Integer, MutableInt>();

    @Override
    public void addFishingOperation(FishingOperation fishingOperation, Collection<IndividualObservationBatch> individualObservations) {
        Objects.requireNonNull(fishingOperation);
        Objects.requireNonNull(individualObservations);
        this.addIndividualObservations(fishingOperation, individualObservations);
    }

    @Override
    public void removeFishingOperation(FishingOperation fishingOperation, Collection<IndividualObservationBatch> individualObservations) {
        Objects.requireNonNull(fishingOperation);
        Objects.requireNonNull(individualObservations);
        this.removeIndividualObservations(fishingOperation, individualObservations);
    }

    @Override
    public void addIndividualObservations(FishingOperation fishingOperation, Collection<IndividualObservationBatch> individualObservations) {
        Objects.requireNonNull(fishingOperation);
        Objects.requireNonNull(individualObservations);
        individualObservations.stream().filter(batch -> batch.getSamplingCode() != null).forEach(batch -> this.addSamplingCode(batch.getSpecies().getReferenceTaxonId(), batch.getSamplingCode()));
    }

    @Override
    public void removeIndividualObservations(FishingOperation fishingOperation, Collection<IndividualObservationBatch> individualObservations) {
        Objects.requireNonNull(fishingOperation);
        Objects.requireNonNull(individualObservations);
        individualObservations.stream().filter(batch -> batch.getSamplingCode() != null).forEach(batch -> this.removeSamplingCode(batch.getSpecies().getReferenceTaxonId(), batch.getSamplingCode()));
    }

    @Override
    public void close() throws IOException {
        this.highestSamplingCodeBySpecies.clear();
    }

    public int getNextSamplingCodeId(int speciesId) {
        MutableInt samplingCode = this.highestSamplingCodeBySpecies.get(speciesId);
        return (samplingCode == null ? 0 : samplingCode.intValue()) + 1;
    }

    public int addSamplingCode(int speciesId, String samplingCode) {
        int code = SamplingCodePrefix.extractSamplingCodeIdFromSamplingCode(samplingCode);
        return this.highestSamplingCodeBySpecies.compute(speciesId, (key, highestSamplingCode) -> {
            if (highestSamplingCode == null) {
                highestSamplingCode = new MutableInt(code);
            } else {
                int nexValue = Math.max(highestSamplingCode.intValue(), code);
                highestSamplingCode.setValue(nexValue);
            }
            return highestSamplingCode;
        }).intValue();
    }

    public void removeSamplingCode(int speciesId, String samplingCode) {
        int code = SamplingCodePrefix.extractSamplingCodeIdFromSamplingCode(samplingCode);
        MutableInt samplingCodeFound = this.highestSamplingCodeBySpecies.get(speciesId);
        if (samplingCodeFound != null && code == samplingCodeFound.intValue()) {
            samplingCodeFound.decrement();
        }
    }
}

