/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import com.google.common.collect.ImmutableList;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.CopyIndividualObservationMode;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersistenceHelper;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForIndividualObservation;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ValidateIndividualObservationAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ValidateIndividualObservationAction.class);
    private final GenericformatImportPersistenceHelper persitenceHelper;

    public ValidateIndividualObservationAction(GenericFormatContextSupport importContext, GenericformatImportPersistenceHelper persitenceHelper) {
        super(importContext);
        this.persitenceHelper = persitenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid() && this.importContext.getOperationFileResult().isValid();
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Validate individualObservation.csv file.");
        }
        int maximumRowsInErrorPerFile = this.importContext.getImportRequest().getMaximumRowsInErrorPerFile();
        GenericFormatCsvFileResult importFileResult = this.importContext.getIndividualObservationFileResult();
        try (CsvConsumerForIndividualObservation consumer = this.importContext.loadIndividualObservations(false);){
            for (ImportRow row : consumer) {
                this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.validate.individualObservations", (Object[])new Object[]{row.getLineNumber()}));
                GenericFormatImportOperationContext operationContext = consumer.validateRow(row, this.importContext);
                if (operationContext != null) {
                    consumer.prepareRowForPersist(operationContext, row);
                }
                if (consumer.getNbRowsInErrors() <= maximumRowsInErrorPerFile) continue;
                if (!log.isWarnEnabled()) break;
                log.warn((Object)"Too much errors, stop validating this file.");
                break;
            }
            this.flushConsumer(consumer, importFileResult);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close individualObservation.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
        this.importContext.doActionOnCruiseContexts((cruiseContext, progressionModel) -> {
            for (GenericFormatImportOperationContext fishingOperationContext : cruiseContext) {
                String cruiseStr = cruiseContext.getCruiseLabel();
                String operationStr = fishingOperationContext.getFishingOperationLabel();
                if (!fishingOperationContext.withIndividualObservationBatches()) continue;
                ImmutableList<IndividualObservationBatch> individualObservationBatches = fishingOperationContext.getIndividualObservationBatches();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Check " + individualObservationBatches.size() + " individual observation(s) of " + operationStr + " for cruise: " + cruiseStr));
                }
                ValidateIndividualObservationAction.prepareIndividualObservationsForPersist(this.persitenceHelper, individualObservationBatches);
            }
        });
    }

    public static void prepareIndividualObservationsForPersist(GenericformatImportPersistenceHelper persistenceHelper, ImmutableList<IndividualObservationBatch> individualObservations) {
        for (IndividualObservationBatch individualObservation : individualObservations) {
            CaracteristicMap caracteristics = individualObservation.getCaracteristics();
            CaracteristicQualitativeValue copyModeCaracteristic = caracteristics.removeQualitativeValue(persistenceHelper.getCopyIndividualObservationModeCaracteristic());
            Objects.requireNonNull(copyModeCaracteristic, "No copy mode found for individual observation: " + individualObservation.getId());
            CopyIndividualObservationMode copyMode = CopyIndividualObservationMode.valueOf((int)copyModeCaracteristic.getIdAsInt());
            individualObservation.setCopyIndividualObservationMode(copyMode);
            String lengthClassId = caracteristics.removeStringValue(persistenceHelper.getPmfmIdCaracteristic());
            Objects.requireNonNull(lengthClassId, "No lengthClassId found for individual observation: " + individualObservation.getId());
            Caracteristic lengthStepCaracteristic = persistenceHelper.getCaracteristic(Integer.valueOf(lengthClassId));
            Objects.requireNonNull(lengthStepCaracteristic, "lengthStepCaracteristic " + lengthClassId + " does not exist.");
            individualObservation.setLengthStepCaracteristic(lengthStepCaracteristic);
            Float length = caracteristics.removeFloatValue(lengthStepCaracteristic);
            individualObservation.setSize(length);
            Float weigth = caracteristics.removeFloatValue(persistenceHelper.getWeightMeasuredCaracteristic());
            individualObservation.setWeight(weigth);
            String samplingCode = caracteristics.removeStringValue(persistenceHelper.getSampleCodeCaracteristic());
            individualObservation.setSamplingCode(samplingCode);
        }
    }
}

