/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import org.dom4j.Element;
import org.hibernate.internal.util.xml.XMLHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.Instantiator;

public class Dom4jInstantiator
implements Instantiator {
    private final String nodeName;
    private final HashSet isInstanceNodeNames = new HashSet();

    public Dom4jInstantiator(Component component) {
        this.nodeName = component.getNodeName();
        this.isInstanceNodeNames.add(this.nodeName);
    }

    public Dom4jInstantiator(PersistentClass mappingInfo) {
        this.nodeName = mappingInfo.getNodeName();
        this.isInstanceNodeNames.add(this.nodeName);
        if (mappingInfo.hasSubclasses()) {
            Iterator itr = mappingInfo.getSubclassClosureIterator();
            while (itr.hasNext()) {
                PersistentClass subclassInfo = (PersistentClass)itr.next();
                this.isInstanceNodeNames.add(subclassInfo.getNodeName());
            }
        }
    }

    @Override
    public Object instantiate(Serializable id) {
        return this.instantiate();
    }

    @Override
    public Object instantiate() {
        return XMLHelper.generateDom4jElement(this.nodeName);
    }

    @Override
    public boolean isInstance(Object object) {
        if (object instanceof Element) {
            return this.isInstanceNodeNames.contains(((Element)object).getName());
        }
        return false;
    }
}

