/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.actions.StartAction;
import fr.ifremer.tutti.ui.swing.update.actions.UpdateApplicationAction;
import fr.ifremer.tutti.ui.swing.update.actions.UpdateReportAction;
import fr.ifremer.tutti.ui.swing.util.TuttiExceptionHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;

public class RunTutti {
    private static final Log log = LogFactory.getLog(RunTutti.class);
    public static final int RESTART_EXIT_CODE = 88;
    public static final int STOP_EXIT_CODE = 0;

    public static void main(String ... args) {
        TuttiUIContext context;
        TuttiConfiguration config;
        block9: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Starting Tutti with arguments: " + Arrays.toString(args)));
            }
            config = new TuttiConfiguration("tutti.config", args);
            context = TuttiUIContext.newContext(config);
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)((Object)new TuttiExceptionHandler(context.getErrorHelper())));
            context.init();
            try {
                SwingUtil.initNimbusLoookAndFeel();
                UIManager.getLookAndFeelDefaults().put("ScrollBar.minimumThumbSize", new Dimension(30, 30));
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block9;
                log.warn((Object)"Failed to init nimbus look and feel", (Throwable)e);
            }
        }
        boolean reload = false;
        if (config.isFullLaunchMode()) {
            boolean canUpdateData;
            boolean canUpdateApplication;
            if (log.isInfoEnabled()) {
                log.info((Object)"Full launch mode, try to update.");
            }
            if (canUpdateApplication = context.checkUpdateApplicationReachable(false)) {
                UpdateApplicationAction logicAction = context.getActionFactory().createLogicAction(new MainUIHandler(){

                    @Override
                    public TuttiUIContext getContext() {
                        return context;
                    }
                }, UpdateApplicationAction.class);
                context.getActionEngine().runActionAndWait((AbstractApplicationAction)logicAction);
                reload = logicAction.isReload();
            }
            if (canUpdateData = context.checkUpdateDataReachable(false)) {
                UpdateReportAction logicAction = context.getActionFactory().createLogicAction(new MainUIHandler(){

                    @Override
                    public TuttiUIContext getContext() {
                        return context;
                    }
                }, UpdateReportAction.class);
                context.getActionEngine().runActionAndWait((AbstractApplicationAction)logicAction);
                reload |= logicAction.isReload();
            }
        }
        if (!reload) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Will start Tutti...");
            }
            RunTutti.startTutti(context, true);
        }
    }

    public static void startTutti(TuttiUIContext context, boolean openContext) {
        if (openContext) {
            context.open();
        }
        UIManager.put("Table.alternateRowColor", context.getConfig().getColorAlternateRow());
        UIManager.put("Table[Disabled+Selected].textBackground", context.getConfig().getColorSelectedRow());
        UIManager.put("Table[Enabled+Selected].textBackground", context.getConfig().getColorSelectedRow());
        UIManager.put("Table.focusCellHighlightBorder", new BorderUIResource.LineBorderUIResource(Color.BLACK));
        MainUI mainUI = new MainUI(context);
        context.addMessageNotifier(mainUI.getHandler());
        SwingUtilities.invokeLater(() -> mainUI.setVisible(true));
        StartAction uiAction = context.getActionFactory().createLogicAction(mainUI.getHandler(), StartAction.class);
        context.getActionEngine().runAction((AbstractApplicationAction)uiAction);
    }

    public static void closeTutti(MainUIHandler handler, Integer exitCode) {
        TuttiUIContext context = handler.getContext();
        handler.onCloseUI();
        context.saveSwingSession();
        context.close();
        if (exitCode != null) {
            System.exit(exitCode);
        }
    }
}

