/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.cps;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.cruise.CruiseCache;
import fr.ifremer.tutti.service.export.cps.SamplingNumberRowModel;
import fr.ifremer.tutti.service.sampling.CacheExtractedKey;
import fr.ifremer.tutti.service.sampling.CruiseSamplingCache;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class CalcifiedPiecesSamplingExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(CalcifiedPiecesSamplingExportService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
    }

    public void exportCruiseCalcifiedPiecesSamplingsReport(File file, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)file, (Object)"Cannot export to a null file");
        TuttiDataContext dataContext = this.context.getDataContext();
        Preconditions.checkState((dataContext.isCanUseCruiseSamplingCache() && dataContext.isCruiseCacheLoaded() && dataContext.isCruiseCacheUpToDate() ? 1 : 0) != 0);
        Decorator<Species> decorator = this.decoratorService.getDecoratorByType(Species.class, "withSurveyCodeNoName");
        SamplingNumberRowModel csvModel = new SamplingNumberRowModel(this.context.getConfig().getCsvSeparator(), decorator);
        Map referenceSpeciesByReferenceTaxonId = Speciess.splitReferenceSpeciesByReferenceTaxonId(dataContext.getReferentSpecies());
        Optional<CruiseCache> optionalCruiseCache = this.context.getDataContext().getOptionalCruiseCache();
        if (!optionalCruiseCache.isPresent()) {
            throw new IllegalStateException("No cruise cache found");
        }
        CruiseCache cruiseCache = optionalCruiseCache.get();
        Optional<CruiseSamplingCache> optionalSamplingCruiseCache = cruiseCache.getSamplingCruiseCache();
        if (!optionalSamplingCruiseCache.isPresent()) {
            throw new IllegalStateException("No sampling cruise cache found");
        }
        List<CacheExtractedKey> rows = optionalSamplingCruiseCache.get().getSamplingNumbers(referenceSpeciesByReferenceTaxonId);
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded " + rows.size() + " keys to export to " + file));
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            progressionModel.increments(I18n.t((String)"tutti.service.cpsExport.step.toFile", (Object[])new Object[]{file.getName()}));
            Export export = Export.newExport((ExportModel)csvModel, rows);
            export.write((Writer)writer);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.cpsExport.error", (Object[])new Object[]{file}), (Throwable)e);
        }
    }
}

