/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatchs;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class EditCatchesUIModel
extends AbstractTuttiBeanUIModel<CatchBatch, EditCatchesUIModel>
implements AttachmentModelAware,
TabContentModel,
CatchBatch {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_VALIDATION_CONTEXT = "validationContext";
    public static final String PROPERTY_CATCH_BATCH = "catchBatch";
    protected static final Binder<CatchBatch, EditCatchesUIModel> fromBeanBinder = BinderFactory.newBinder(CatchBatch.class, EditCatchesUIModel.class);
    protected static final Binder<EditCatchesUIModel, CatchBatch> toBeanBinder = BinderFactory.newBinder(EditCatchesUIModel.class, CatchBatch.class);
    protected Float speciesTotalComputedWeight;
    protected ComputableData<Float> speciesTotalSortedComputedOrNotWeight = new ComputableData();
    protected Float speciesTotalUnsortedComputedWeight;
    protected Float speciesTotalSampleSortedComputedWeight;
    protected ComputableData<Float> speciesTotalInertComputedOrNotWeight = new ComputableData();
    protected ComputableData<Float> speciesTotalLivingNotItemizedComputedOrNotWeight = new ComputableData();
    protected Float benthosTotalComputedWeight;
    protected ComputableData<Float> benthosTotalSortedComputedOrNotWeight = new ComputableData();
    protected Float benthosTotalUnsortedComputedWeight;
    protected Float benthosTotalSampleSortedComputedWeight;
    protected ComputableData<Float> benthosTotalInertComputedOrNotWeight = new ComputableData();
    protected ComputableData<Float> benthosTotalLivingNotItemizedComputedOrNotWeight = new ComputableData();
    protected ComputableData<Float> marineLitterTotalComputedOrNotWeight = new ComputableData();
    protected ComputableData<Float> catchTotalComputedOrNotWeight = new ComputableData();
    protected Float catchTotalSortedComputedWeight;
    protected Float catchTotalSortedSortedComputedWeight;
    protected Float catchTotalUnsortedComputedWeight;
    protected Float catchTotalSortedTremisWeight;
    protected Float catchTotalSortedCarousselWeight;
    protected ComputableData<Float> catchTotalRejectedComputedOrNotWeight = new ComputableData();
    protected FishingOperation fishingOperation;
    protected String validationContext;
    protected final CatchBatch editObject = CatchBatchs.newCatchBatch();
    protected final List<Attachment> attachment = Lists.newArrayList();
    protected final Multimap<CaracteristicQualitativeValue, Species> speciesUsed = HashMultimap.create();
    protected final Multimap<CaracteristicQualitativeValue, CaracteristicQualitativeValue> marineLitterCategoriesUsed = ArrayListMultimap.create();
    protected boolean loadingData;
    protected final WeightUnit catchWeightUnit;
    protected final WeightUnit speciesWeightUnit;
    protected final WeightUnit benthosWeightUnit;
    protected final WeightUnit marineLitterWeightUnit;
    private boolean doNotCheckLeavingFrequencyScreen;

    public EditCatchesUIModel(WeightUnit speciesWeightUnit, WeightUnit benthosWeightUnit, WeightUnit marineLitterWeightUnit) {
        super(fromBeanBinder, toBeanBinder);
        this.catchWeightUnit = WeightUnit.G == speciesWeightUnit && WeightUnit.G == benthosWeightUnit ? WeightUnit.G : WeightUnit.KG;
        this.speciesWeightUnit = speciesWeightUnit;
        this.benthosWeightUnit = benthosWeightUnit;
        this.marineLitterWeightUnit = marineLitterWeightUnit;
        this.speciesTotalSortedComputedOrNotWeight.addPropagateListener("speciesTotalSortedWeight", this);
        this.speciesTotalInertComputedOrNotWeight.addPropagateListener("speciesTotalInertWeight", this);
        this.speciesTotalLivingNotItemizedComputedOrNotWeight.addPropagateListener("speciesTotalLivingNotItemizedWeight", this);
        this.benthosTotalSortedComputedOrNotWeight.addPropagateListener("benthosTotalSortedWeight", this);
        this.benthosTotalInertComputedOrNotWeight.addPropagateListener("benthosTotalInertWeight", this);
        this.benthosTotalLivingNotItemizedComputedOrNotWeight.addPropagateListener("benthosTotalLivingNotItemizedWeight", this);
        this.marineLitterTotalComputedOrNotWeight.addPropagateListener("marineLitterTotalWeight", this);
        this.catchTotalComputedOrNotWeight.addPropagateListener("catchTotalWeight", this);
        this.catchTotalRejectedComputedOrNotWeight.addPropagateListener("catchTotalRejectedWeight", this);
    }

    public WeightUnit getCatchWeightUnit() {
        return this.catchWeightUnit;
    }

    public boolean isLoadingData() {
        return this.loadingData;
    }

    public void setLoadingData(boolean loadingData) {
        this.loadingData = loadingData;
    }

    public String getTitle() {
        return I18n.t((String)"tutti.label.tab.catchesCaracteristics", (Object[])new Object[0]);
    }

    @Override
    protected CatchBatch newEntity() {
        return CatchBatchs.newCatchBatch();
    }

    @Override
    public void fromEntity(CatchBatch entity) {
        Integer oldObjectId = this.getObjectId();
        super.fromEntity(entity);
        this.editObject.setId(this.getId());
        this.firePropertyChange(PROPERTY_CATCH_BATCH, null, entity);
        this.firePropertyChange("objectId", oldObjectId, this.getObjectId());
        this.setFishingOperation(entity == null ? null : entity.getFishingOperation());
        if (entity != null) {
            this.setCatchTotalComputedWeight(this.catchWeightUnit.fromEntity(entity.getCatchTotalComputedWeight()));
            this.setCatchTotalRejectedComputedWeight(this.catchWeightUnit.fromEntity(entity.getCatchTotalRejectedComputedWeight()));
            this.setCatchTotalRejectedWeight(this.catchWeightUnit.fromEntity(entity.getCatchTotalRejectedWeight()));
            this.setCatchTotalSortedCarousselWeight(this.catchWeightUnit.fromEntity(entity.getCatchTotalSortedCarousselWeight()));
            this.setCatchTotalSortedComputedWeight(this.catchWeightUnit.fromEntity(entity.getCatchTotalSortedComputedWeight()));
            this.setCatchTotalSortedSortedComputedWeight(this.catchWeightUnit.fromEntity(entity.getCatchTotalSortedSortedComputedWeight()));
            this.setCatchTotalSortedTremisWeight(this.catchWeightUnit.fromEntity(entity.getCatchTotalSortedTremisWeight()));
            this.setCatchTotalUnsortedComputedWeight(this.catchWeightUnit.fromEntity(entity.getCatchTotalUnsortedComputedWeight()));
            this.setCatchTotalWeight(this.catchWeightUnit.fromEntity(entity.getCatchTotalWeight()));
            this.setSpeciesTotalComputedWeight(this.speciesWeightUnit.fromEntity(entity.getSpeciesTotalComputedWeight()));
            this.setSpeciesTotalInertComputedWeight(this.speciesWeightUnit.fromEntity(entity.getSpeciesTotalInertComputedWeight()));
            this.setSpeciesTotalInertWeight(this.speciesWeightUnit.fromEntity(entity.getSpeciesTotalInertWeight()));
            this.setSpeciesTotalLivingNotItemizedComputedWeight(this.speciesWeightUnit.fromEntity(entity.getSpeciesTotalLivingNotItemizedComputedWeight()));
            this.setSpeciesTotalLivingNotItemizedWeight(this.speciesWeightUnit.fromEntity(entity.getSpeciesTotalLivingNotItemizedWeight()));
            this.setSpeciesTotalSampleSortedComputedWeight(this.speciesWeightUnit.fromEntity(entity.getSpeciesTotalSampleSortedComputedWeight()));
            this.setSpeciesTotalSortedComputedWeight(this.speciesWeightUnit.fromEntity(entity.getSpeciesTotalSortedComputedWeight()));
            this.setSpeciesTotalSortedWeight(this.speciesWeightUnit.fromEntity(entity.getSpeciesTotalSortedWeight()));
            this.setSpeciesTotalUnsortedComputedWeight(this.speciesWeightUnit.fromEntity(entity.getSpeciesTotalUnsortedComputedWeight()));
            this.setBenthosTotalComputedWeight(this.benthosWeightUnit.fromEntity(entity.getBenthosTotalComputedWeight()));
            this.setBenthosTotalInertComputedWeight(this.benthosWeightUnit.fromEntity(entity.getBenthosTotalInertComputedWeight()));
            this.setBenthosTotalInertWeight(this.benthosWeightUnit.fromEntity(entity.getBenthosTotalInertWeight()));
            this.setBenthosTotalLivingNotItemizedComputedWeight(this.benthosWeightUnit.fromEntity(entity.getBenthosTotalLivingNotItemizedComputedWeight()));
            this.setBenthosTotalLivingNotItemizedWeight(this.benthosWeightUnit.fromEntity(entity.getBenthosTotalLivingNotItemizedWeight()));
            this.setBenthosTotalSampleSortedComputedWeight(this.benthosWeightUnit.fromEntity(entity.getBenthosTotalSampleSortedComputedWeight()));
            this.setBenthosTotalSortedComputedWeight(this.benthosWeightUnit.fromEntity(entity.getBenthosTotalSortedComputedWeight()));
            this.setBenthosTotalSortedWeight(this.benthosWeightUnit.fromEntity(entity.getBenthosTotalSortedWeight()));
            this.setBenthosTotalUnsortedComputedWeight(this.benthosWeightUnit.fromEntity(entity.getBenthosTotalUnsortedComputedWeight()));
            this.setMarineLitterTotalComputedWeight(this.marineLitterWeightUnit.fromEntity(entity.getMarineLitterTotalComputedWeight()));
            this.setMarineLitterTotalWeight(this.marineLitterWeightUnit.fromEntity(entity.getMarineLitterTotalWeight()));
        }
    }

    @Override
    public CatchBatch toEntity() {
        CatchBatch result = (CatchBatch)super.toEntity();
        result.setCatchTotalComputedWeight(this.catchWeightUnit.toEntity(this.getCatchTotalComputedWeight()));
        result.setCatchTotalRejectedComputedWeight(this.catchWeightUnit.toEntity(this.getCatchTotalRejectedComputedWeight()));
        result.setCatchTotalRejectedWeight(this.catchWeightUnit.toEntity(this.getCatchTotalRejectedWeight()));
        result.setCatchTotalSortedCarousselWeight(this.catchWeightUnit.toEntity(this.getCatchTotalSortedCarousselWeight()));
        result.setCatchTotalSortedComputedWeight(this.catchWeightUnit.toEntity(this.getCatchTotalSortedComputedWeight()));
        result.setCatchTotalSortedSortedComputedWeight(this.catchWeightUnit.toEntity(this.getCatchTotalSortedSortedComputedWeight()));
        result.setCatchTotalSortedTremisWeight(this.catchWeightUnit.toEntity(this.getCatchTotalSortedTremisWeight()));
        result.setCatchTotalUnsortedComputedWeight(this.catchWeightUnit.toEntity(this.getCatchTotalUnsortedComputedWeight()));
        result.setCatchTotalWeight(this.catchWeightUnit.toEntity(this.getCatchTotalWeight()));
        result.setSpeciesTotalComputedWeight(this.speciesWeightUnit.toEntity(this.getSpeciesTotalComputedWeight()));
        result.setSpeciesTotalInertComputedWeight(this.speciesWeightUnit.toEntity(this.getSpeciesTotalInertComputedWeight()));
        result.setSpeciesTotalInertWeight(this.speciesWeightUnit.toEntity(this.getSpeciesTotalInertWeight()));
        result.setSpeciesTotalLivingNotItemizedComputedWeight(this.speciesWeightUnit.toEntity(this.getSpeciesTotalLivingNotItemizedComputedWeight()));
        result.setSpeciesTotalLivingNotItemizedWeight(this.speciesWeightUnit.toEntity(this.getSpeciesTotalLivingNotItemizedWeight()));
        result.setSpeciesTotalSampleSortedComputedWeight(this.speciesWeightUnit.toEntity(this.getSpeciesTotalSampleSortedComputedWeight()));
        result.setSpeciesTotalSortedComputedWeight(this.speciesWeightUnit.toEntity(this.getSpeciesTotalSortedComputedWeight()));
        result.setSpeciesTotalSortedWeight(this.speciesWeightUnit.toEntity(this.getSpeciesTotalSortedWeight()));
        result.setSpeciesTotalUnsortedComputedWeight(this.speciesWeightUnit.toEntity(this.getSpeciesTotalUnsortedComputedWeight()));
        result.setBenthosTotalComputedWeight(this.benthosWeightUnit.toEntity(this.getBenthosTotalComputedWeight()));
        result.setBenthosTotalInertComputedWeight(this.benthosWeightUnit.toEntity(this.getBenthosTotalInertComputedWeight()));
        result.setBenthosTotalInertWeight(this.benthosWeightUnit.toEntity(this.getBenthosTotalInertWeight()));
        result.setBenthosTotalLivingNotItemizedComputedWeight(this.benthosWeightUnit.toEntity(this.getBenthosTotalLivingNotItemizedComputedWeight()));
        result.setBenthosTotalLivingNotItemizedWeight(this.benthosWeightUnit.toEntity(this.getBenthosTotalLivingNotItemizedWeight()));
        result.setBenthosTotalSampleSortedComputedWeight(this.benthosWeightUnit.toEntity(this.getBenthosTotalSampleSortedComputedWeight()));
        result.setBenthosTotalSortedComputedWeight(this.benthosWeightUnit.toEntity(this.getBenthosTotalSortedComputedWeight()));
        result.setBenthosTotalSortedWeight(this.benthosWeightUnit.toEntity(this.getBenthosTotalSortedWeight()));
        result.setBenthosTotalUnsortedComputedWeight(this.benthosWeightUnit.toEntity(this.getBenthosTotalUnsortedComputedWeight()));
        result.setMarineLitterTotalComputedWeight(this.marineLitterWeightUnit.toEntity(this.getMarineLitterTotalComputedWeight()));
        result.setMarineLitterTotalWeight(this.marineLitterWeightUnit.toEntity(this.getMarineLitterTotalWeight()));
        return result;
    }

    public boolean isEmpty() {
        return this.getCatchTotalWeight() == null && this.getCatchTotalRejectedWeight() == null && CollectionUtils.isEmpty(this.getAttachment());
    }

    public String getIcon() {
        return null;
    }

    @Override
    public FishingOperation getFishingOperation() {
        return this.fishingOperation;
    }

    @Override
    public void setFishingOperation(FishingOperation fishingOperation) {
        FishingOperation oldValue = this.getFishingOperation();
        this.fishingOperation = fishingOperation;
        this.firePropertyChange("fishingOperation", oldValue, fishingOperation);
    }

    public boolean isCloseable() {
        return false;
    }

    public String getValidationContext() {
        return this.validationContext;
    }

    public void setValidationContext(String validationContext) {
        String oldValue = this.getValidationContext();
        this.validationContext = validationContext;
        this.firePropertyChange(PROPERTY_VALIDATION_CONTEXT, oldValue, validationContext);
    }

    public Multimap<CaracteristicQualitativeValue, Species> getSpeciesUsed() {
        return this.speciesUsed;
    }

    public void replaceCaracteristicValue(Species species, CaracteristicQualitativeValue oldValue, CaracteristicQualitativeValue newValue) {
        this.speciesUsed.remove((Object)oldValue, (Object)species);
        this.speciesUsed.put((Object)newValue, (Object)species);
    }

    public Multimap<CaracteristicQualitativeValue, CaracteristicQualitativeValue> getMarineLitterCategoriesUsed() {
        return this.marineLitterCategoriesUsed;
    }

    public ComputableData<Float> getCatchTotalComputedOrNotWeight() {
        return this.catchTotalComputedOrNotWeight;
    }

    @Override
    public Float getCatchTotalWeight() {
        return this.catchTotalComputedOrNotWeight.getData();
    }

    @Override
    public void setCatchTotalWeight(Float catchTotalWeight) {
        Float oldValue = this.getCatchTotalWeight();
        this.catchTotalComputedOrNotWeight.setData(catchTotalWeight);
        this.firePropertyChange("catchTotalWeight", oldValue, catchTotalWeight);
    }

    @Override
    public Float getCatchTotalComputedWeight() {
        return this.catchTotalComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setCatchTotalComputedWeight(Float catchTotalComputedWeight) {
        Float oldValue = this.getCatchTotalComputedWeight();
        this.catchTotalComputedOrNotWeight.setComputedData(catchTotalComputedWeight);
        this.firePropertyChange("catchTotalComputedWeight", oldValue, catchTotalComputedWeight);
    }

    @Override
    public Float getCatchTotalSortedComputedWeight() {
        return this.catchTotalSortedComputedWeight;
    }

    @Override
    public void setCatchTotalSortedComputedWeight(Float catchTotalSortedComputedWeight) {
        Float oldValue = this.getCatchTotalSortedComputedWeight();
        this.catchTotalSortedComputedWeight = catchTotalSortedComputedWeight;
        this.firePropertyChange("catchTotalSortedComputedWeight", oldValue, catchTotalSortedComputedWeight);
    }

    @Override
    public Float getCatchTotalUnsortedComputedWeight() {
        return this.catchTotalUnsortedComputedWeight;
    }

    @Override
    public void setCatchTotalUnsortedComputedWeight(Float catchTotalUnsortedComputedWeight) {
        Float oldValue = this.getCatchTotalUnsortedComputedWeight();
        this.catchTotalUnsortedComputedWeight = catchTotalUnsortedComputedWeight;
        this.firePropertyChange("catchTotalUnsortedComputedWeight", oldValue, catchTotalUnsortedComputedWeight);
    }

    @Override
    public Float getCatchTotalSortedTremisWeight() {
        return this.catchTotalSortedTremisWeight;
    }

    @Override
    public void setCatchTotalSortedTremisWeight(Float catchTotalSortedTremisWeight) {
        Float oldValue = this.getCatchTotalSortedTremisWeight();
        this.catchTotalSortedTremisWeight = catchTotalSortedTremisWeight;
        this.firePropertyChange("catchTotalSortedTremisWeight", oldValue, catchTotalSortedTremisWeight);
    }

    @Override
    public Float getCatchTotalSortedCarousselWeight() {
        return this.catchTotalSortedCarousselWeight;
    }

    @Override
    public void setCatchTotalSortedCarousselWeight(Float catchTotalSortedCarousselWeight) {
        Float oldValue = this.getCatchTotalSortedCarousselWeight();
        this.catchTotalSortedCarousselWeight = catchTotalSortedCarousselWeight;
        this.firePropertyChange("catchTotalSortedCarousselWeight", oldValue, catchTotalSortedCarousselWeight);
    }

    public ComputableData<Float> getCatchTotalRejectedComputedOrNotWeight() {
        return this.catchTotalRejectedComputedOrNotWeight;
    }

    @Override
    public Float getCatchTotalRejectedWeight() {
        return this.catchTotalRejectedComputedOrNotWeight.getData();
    }

    @Override
    public void setCatchTotalRejectedWeight(Float catchTotalRejectedWeight) {
        Float oldValue = this.getCatchTotalRejectedWeight();
        this.catchTotalRejectedComputedOrNotWeight.setData(catchTotalRejectedWeight);
        this.firePropertyChange("catchTotalRejectedWeight", oldValue, catchTotalRejectedWeight);
    }

    @Override
    public Float getCatchTotalRejectedComputedWeight() {
        return this.catchTotalRejectedComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setCatchTotalRejectedComputedWeight(Float catchTotalRejectedComputedWeight) {
        Float oldValue = this.getCatchTotalRejectedComputedWeight();
        this.catchTotalRejectedComputedOrNotWeight.setComputedData(catchTotalRejectedComputedWeight);
        this.firePropertyChange("catchTotalRejectedComputedWeight", oldValue, catchTotalRejectedComputedWeight);
    }

    @Override
    public Float getSpeciesTotalComputedWeight() {
        return this.speciesTotalComputedWeight;
    }

    @Override
    public void setSpeciesTotalComputedWeight(Float speciesTotalComputedWeight) {
        Float oldValue = this.getSpeciesTotalComputedWeight();
        this.speciesTotalComputedWeight = speciesTotalComputedWeight;
        this.firePropertyChange("speciesTotalComputedWeight", oldValue, speciesTotalComputedWeight);
    }

    public ComputableData<Float> getSpeciesTotalSortedComputedOrNotWeight() {
        return this.speciesTotalSortedComputedOrNotWeight;
    }

    @Override
    public Float getSpeciesTotalSortedWeight() {
        return this.speciesTotalSortedComputedOrNotWeight.getData();
    }

    @Override
    public void setSpeciesTotalSortedWeight(Float speciesTotalSortedWeight) {
        Float oldValue = this.getSpeciesTotalSortedWeight();
        this.speciesTotalSortedComputedOrNotWeight.setData(speciesTotalSortedWeight);
        this.firePropertyChange("speciesTotalSortedWeight", oldValue, speciesTotalSortedWeight);
    }

    @Override
    public Float getSpeciesTotalSortedComputedWeight() {
        return this.speciesTotalSortedComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setSpeciesTotalSortedComputedWeight(Float speciesTotalSortedComputedWeight) {
        Float oldValue = this.getSpeciesTotalSortedComputedWeight();
        this.speciesTotalSortedComputedOrNotWeight.setComputedData(speciesTotalSortedComputedWeight);
        this.firePropertyChange("speciesTotalSortedComputedWeight", oldValue, speciesTotalSortedComputedWeight);
    }

    @Override
    public Float getSpeciesTotalSampleSortedComputedWeight() {
        return this.speciesTotalSampleSortedComputedWeight;
    }

    @Override
    public void setSpeciesTotalSampleSortedComputedWeight(Float speciesTotalSampleSortedComputedWeight) {
        Float oldValue = this.getSpeciesTotalSampleSortedComputedWeight();
        this.speciesTotalSampleSortedComputedWeight = speciesTotalSampleSortedComputedWeight;
        this.firePropertyChange("speciesTotalSampleSortedComputedWeight", oldValue, speciesTotalSampleSortedComputedWeight);
    }

    @Override
    public Float getSpeciesTotalUnsortedComputedWeight() {
        return this.speciesTotalUnsortedComputedWeight;
    }

    @Override
    public void setSpeciesTotalUnsortedComputedWeight(Float speciesTotalUnsortedComputedWeight) {
        Float oldValue = this.getSpeciesTotalUnsortedComputedWeight();
        this.speciesTotalUnsortedComputedWeight = speciesTotalUnsortedComputedWeight;
        this.firePropertyChange("speciesTotalUnsortedComputedWeight", oldValue, speciesTotalUnsortedComputedWeight);
    }

    public ComputableData<Float> getSpeciesTotalInertComputedOrNotWeight() {
        return this.speciesTotalInertComputedOrNotWeight;
    }

    @Override
    public Float getSpeciesTotalInertWeight() {
        return this.speciesTotalInertComputedOrNotWeight.getData();
    }

    @Override
    public void setSpeciesTotalInertWeight(Float speciesTotalInertWeight) {
        Float oldValue = this.getSpeciesTotalInertWeight();
        this.speciesTotalInertComputedOrNotWeight.setData(speciesTotalInertWeight);
        this.firePropertyChange("speciesTotalInertWeight", oldValue, speciesTotalInertWeight);
    }

    @Override
    public Float getSpeciesTotalInertComputedWeight() {
        return this.speciesTotalInertComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setSpeciesTotalInertComputedWeight(Float speciesTotalInertComputedWeight) {
        Float oldValue = this.getSpeciesTotalInertComputedWeight();
        this.speciesTotalInertComputedOrNotWeight.setComputedData(speciesTotalInertComputedWeight);
        this.firePropertyChange("speciesTotalInertComputedWeight", oldValue, speciesTotalInertComputedWeight);
    }

    public ComputableData<Float> getSpeciesTotalLivingNotItemizedComputedOrNotWeight() {
        return this.speciesTotalLivingNotItemizedComputedOrNotWeight;
    }

    @Override
    public Float getSpeciesTotalLivingNotItemizedWeight() {
        return this.speciesTotalLivingNotItemizedComputedOrNotWeight.getData();
    }

    @Override
    public void setSpeciesTotalLivingNotItemizedWeight(Float speciesTotalLivingNotItemizedWeight) {
        Float oldValue = this.getSpeciesTotalLivingNotItemizedComputedWeight();
        this.speciesTotalLivingNotItemizedComputedOrNotWeight.setData(speciesTotalLivingNotItemizedWeight);
        this.firePropertyChange("speciesTotalLivingNotItemizedWeight", oldValue, speciesTotalLivingNotItemizedWeight);
    }

    @Override
    public Float getSpeciesTotalLivingNotItemizedComputedWeight() {
        return this.speciesTotalLivingNotItemizedComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setSpeciesTotalLivingNotItemizedComputedWeight(Float speciesTotalLivingNotItemizedComputedWeight) {
        Float oldValue = this.getSpeciesTotalLivingNotItemizedComputedWeight();
        this.speciesTotalLivingNotItemizedComputedOrNotWeight.setComputedData(speciesTotalLivingNotItemizedComputedWeight);
        this.firePropertyChange("speciesTotalLivingNotItemizedComputedWeight", oldValue, speciesTotalLivingNotItemizedComputedWeight);
    }

    public boolean isSpeciesTotalUnsortedComputedWeightInWarning() {
        Float catchTotalRejectedWeight = this.getCatchTotalRejectedComputedOrNotWeight().getDataOrComputedData();
        Float speciesTotalSortedWeight = this.getSpeciesTotalSortedComputedOrNotWeight().getDataOrComputedData();
        boolean noCatchTotalRejected = WeightUnit.KG.isNullOrZero(catchTotalRejectedWeight);
        boolean noTotalUnsortedWeight = this.speciesTotalUnsortedComputedWeight != null && WeightUnit.KG.isGreaterThanZero(this.speciesTotalUnsortedComputedWeight.floatValue());
        boolean speciesWeightEquals = speciesTotalSortedWeight != null && this.speciesTotalSampleSortedComputedWeight != null && WeightUnit.KG.isEquals(speciesTotalSortedWeight.floatValue(), this.speciesTotalSampleSortedComputedWeight.floatValue());
        return noTotalUnsortedWeight && noCatchTotalRejected && speciesWeightEquals;
    }

    @Override
    public Float getBenthosTotalComputedWeight() {
        return this.benthosTotalComputedWeight;
    }

    @Override
    public void setBenthosTotalComputedWeight(Float benthosTotalComputedWeight) {
        Float oldValue = this.getBenthosTotalComputedWeight();
        this.benthosTotalComputedWeight = benthosTotalComputedWeight;
        this.firePropertyChange("benthosTotalComputedWeight", oldValue, benthosTotalComputedWeight);
    }

    public ComputableData<Float> getBenthosTotalSortedComputedOrNotWeight() {
        return this.benthosTotalSortedComputedOrNotWeight;
    }

    @Override
    public Float getBenthosTotalSortedWeight() {
        return this.benthosTotalSortedComputedOrNotWeight.getData();
    }

    @Override
    public void setBenthosTotalSortedWeight(Float benthosTotalSortedWeight) {
        Float oldValue = this.getBenthosTotalSortedWeight();
        this.benthosTotalSortedComputedOrNotWeight.setData(benthosTotalSortedWeight);
        this.firePropertyChange("benthosTotalSortedWeight", oldValue, benthosTotalSortedWeight);
    }

    @Override
    public Float getBenthosTotalSortedComputedWeight() {
        return this.benthosTotalSortedComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setBenthosTotalSortedComputedWeight(Float benthosTotalSortedComputedWeight) {
        Float oldValue = this.getBenthosTotalSortedComputedWeight();
        this.benthosTotalSortedComputedOrNotWeight.setComputedData(benthosTotalSortedComputedWeight);
        this.firePropertyChange("benthosTotalSortedComputedWeight", oldValue, benthosTotalSortedComputedWeight);
    }

    @Override
    public Float getBenthosTotalSampleSortedComputedWeight() {
        return this.benthosTotalSampleSortedComputedWeight;
    }

    @Override
    public void setBenthosTotalSampleSortedComputedWeight(Float benthosTotalSampleSortedComputedWeight) {
        Float oldValue = this.getBenthosTotalSampleSortedComputedWeight();
        this.benthosTotalSampleSortedComputedWeight = benthosTotalSampleSortedComputedWeight;
        this.firePropertyChange("benthosTotalSampleSortedComputedWeight", oldValue, benthosTotalSampleSortedComputedWeight);
    }

    @Override
    public Float getBenthosTotalUnsortedComputedWeight() {
        return this.benthosTotalUnsortedComputedWeight;
    }

    @Override
    public void setBenthosTotalUnsortedComputedWeight(Float benthosTotalUnsortedComputedWeight) {
        Float oldValue = this.getBenthosTotalUnsortedComputedWeight();
        this.benthosTotalUnsortedComputedWeight = benthosTotalUnsortedComputedWeight;
        this.firePropertyChange("benthosTotalUnsortedComputedWeight", oldValue, benthosTotalUnsortedComputedWeight);
    }

    public ComputableData<Float> getBenthosTotalInertComputedOrNotWeight() {
        return this.benthosTotalInertComputedOrNotWeight;
    }

    @Override
    public Float getBenthosTotalInertWeight() {
        return this.benthosTotalInertComputedOrNotWeight.getData();
    }

    @Override
    public void setBenthosTotalInertWeight(Float benthosTotalInertWeight) {
        Float oldValue = this.getBenthosTotalInertWeight();
        this.benthosTotalInertComputedOrNotWeight.setData(benthosTotalInertWeight);
        this.firePropertyChange("benthosTotalInertWeight", oldValue, benthosTotalInertWeight);
    }

    @Override
    public Float getBenthosTotalInertComputedWeight() {
        return this.benthosTotalInertComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setBenthosTotalInertComputedWeight(Float benthosTotalInertComputedWeight) {
        Float oldValue = this.getBenthosTotalInertComputedWeight();
        this.benthosTotalInertComputedOrNotWeight.setComputedData(benthosTotalInertComputedWeight);
        this.firePropertyChange("benthosTotalInertComputedWeight", oldValue, benthosTotalInertComputedWeight);
    }

    public ComputableData<Float> getBenthosTotalLivingNotItemizedComputedOrNotWeight() {
        return this.benthosTotalLivingNotItemizedComputedOrNotWeight;
    }

    @Override
    public Float getBenthosTotalLivingNotItemizedWeight() {
        return this.benthosTotalLivingNotItemizedComputedOrNotWeight.getData();
    }

    @Override
    public void setBenthosTotalLivingNotItemizedWeight(Float benthosTotalLivingNotItemizedWeight) {
        Float oldValue = this.getBenthosTotalLivingNotItemizedComputedWeight();
        this.benthosTotalLivingNotItemizedComputedOrNotWeight.setData(benthosTotalLivingNotItemizedWeight);
        this.firePropertyChange("benthosTotalLivingNotItemizedWeight", oldValue, benthosTotalLivingNotItemizedWeight);
    }

    @Override
    public Float getBenthosTotalLivingNotItemizedComputedWeight() {
        return this.benthosTotalLivingNotItemizedComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setBenthosTotalLivingNotItemizedComputedWeight(Float benthosTotalLivingNotItemizedComputedWeight) {
        Float oldValue = this.getBenthosTotalLivingNotItemizedComputedWeight();
        this.benthosTotalLivingNotItemizedComputedOrNotWeight.setComputedData(benthosTotalLivingNotItemizedComputedWeight);
        this.firePropertyChange("benthosTotalLivingNotItemizedComputedWeight", oldValue, benthosTotalLivingNotItemizedComputedWeight);
    }

    public boolean isBenthosTotalUnsortedComputedWeightInWarning() {
        Float catchTotalRejectedWeight = this.getCatchTotalRejectedComputedOrNotWeight().getDataOrComputedData();
        Float benthosTotalSortedWeight = this.getBenthosTotalSortedComputedOrNotWeight().getDataOrComputedData();
        boolean noCatchTotalRejected = WeightUnit.KG.isNullOrZero(catchTotalRejectedWeight);
        boolean noTotalUnsortedWeight = this.benthosTotalUnsortedComputedWeight != null && WeightUnit.KG.isGreaterThanZero(this.benthosTotalUnsortedComputedWeight.floatValue());
        boolean benthosWeightEquals = benthosTotalSortedWeight != null && this.benthosTotalSampleSortedComputedWeight != null && WeightUnit.KG.isEquals(benthosTotalSortedWeight.floatValue(), this.benthosTotalSampleSortedComputedWeight.floatValue());
        return noTotalUnsortedWeight && noCatchTotalRejected && benthosWeightEquals;
    }

    public ComputableData<Float> getMarineLitterTotalComputedOrNotWeight() {
        return this.marineLitterTotalComputedOrNotWeight;
    }

    @Override
    public Float getMarineLitterTotalWeight() {
        return this.marineLitterTotalComputedOrNotWeight.getData();
    }

    @Override
    public void setMarineLitterTotalWeight(Float marineLitterTotalWeight) {
        Float oldValue = this.getMarineLitterTotalWeight();
        this.marineLitterTotalComputedOrNotWeight.setData(marineLitterTotalWeight);
        this.firePropertyChange("marineLitterTotalWeight", oldValue, marineLitterTotalWeight);
    }

    @Override
    public Float getMarineLitterTotalComputedWeight() {
        return this.marineLitterTotalComputedOrNotWeight.getComputedData();
    }

    @Override
    public void setMarineLitterTotalComputedWeight(Float marineLitterTotalComputedWeight) {
        Float oldValue = this.getMarineLitterTotalComputedWeight();
        this.marineLitterTotalComputedOrNotWeight.setComputedData(marineLitterTotalComputedWeight);
        this.firePropertyChange("marineLitterTotalComputedWeight", oldValue, marineLitterTotalComputedWeight);
    }

    @Override
    public ObjectTypeCode getObjectType() {
        return ObjectTypeCode.CATCH_BATCH;
    }

    @Override
    public Integer getObjectId() {
        return this.editObject == null ? null : this.editObject.getIdAsInt();
    }

    @Override
    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public String getSynchronizationStatus() {
        return this.editObject.getSynchronizationStatus();
    }

    @Override
    public void setSynchronizationStatus(String synchronizationStatus) {
        String oldValue = this.getSynchronizationStatus();
        this.editObject.setSynchronizationStatus(synchronizationStatus);
        this.firePropertyChange("synchronizationStatus", oldValue, synchronizationStatus);
    }

    @Override
    public Float getCatchTotalSortedSortedComputedWeight() {
        return this.catchTotalSortedSortedComputedWeight;
    }

    @Override
    public void setCatchTotalSortedSortedComputedWeight(Float catchTotalSortedSortedComputedWeight) {
        Float oldValue = this.getCatchTotalSortedSortedComputedWeight();
        this.catchTotalSortedSortedComputedWeight = catchTotalSortedSortedComputedWeight;
        this.firePropertyChange("catchTotalSortedSortedComputedWeight", oldValue, catchTotalSortedSortedComputedWeight);
    }

    @Override
    public Integer getSpeciesDistinctSortedSpeciesCount() {
        return this.editObject.getSpeciesDistinctSortedSpeciesCount();
    }

    @Override
    public void setSpeciesDistinctSortedSpeciesCount(Integer speciesDistinctSortedSpeciesCount) {
        Integer oldValue = this.getSpeciesDistinctSortedSpeciesCount();
        this.editObject.setSpeciesDistinctSortedSpeciesCount(speciesDistinctSortedSpeciesCount);
        this.firePropertyChange("speciesDistinctSortedSpeciesCount", oldValue, speciesDistinctSortedSpeciesCount);
    }

    @Override
    public Integer getBenthosDistinctSortedSpeciesCount() {
        return this.editObject.getBenthosDistinctSortedSpeciesCount();
    }

    @Override
    public void setBenthosDistinctSortedSpeciesCount(Integer benthosDistinctSortedSpeciesCount) {
        Integer oldValue = this.getBenthosDistinctSortedSpeciesCount();
        this.editObject.setBenthosDistinctSortedSpeciesCount(benthosDistinctSortedSpeciesCount);
        this.firePropertyChange("benthosDistinctSortedSpeciesCount", oldValue, benthosDistinctSortedSpeciesCount);
    }

    @Override
    public Integer getBenthosDistinctUnsortedSpeciesCount() {
        return this.editObject.getBenthosDistinctUnsortedSpeciesCount();
    }

    @Override
    public Integer getSpeciesDistinctUnsortedSpeciesCount() {
        return this.editObject.getSpeciesDistinctUnsortedSpeciesCount();
    }

    @Override
    public void setSpeciesDistinctUnsortedSpeciesCount(Integer speciesDistinctUnsortedSpeciesCount) {
        Integer oldValue = this.getSpeciesDistinctUnsortedSpeciesCount();
        this.editObject.setSpeciesDistinctUnsortedSpeciesCount(speciesDistinctUnsortedSpeciesCount);
        this.firePropertyChange("speciesDistinctUnsortedSpeciesCount", oldValue, speciesDistinctUnsortedSpeciesCount);
    }

    @Override
    public void setBenthosDistinctUnsortedSpeciesCount(Integer benthosDistinctUnsortedSpeciesCount) {
        Integer oldValue = this.getBenthosDistinctUnsortedSpeciesCount();
        this.editObject.setBenthosDistinctUnsortedSpeciesCount(benthosDistinctUnsortedSpeciesCount);
        this.firePropertyChange("benthosDistinctUnsortedSpeciesCount", oldValue, benthosDistinctUnsortedSpeciesCount);
    }

    public void reset() {
        this.setSpeciesTotalInertComputedWeight(null);
        this.setSpeciesTotalLivingNotItemizedComputedWeight(null);
        this.setSpeciesTotalSampleSortedComputedWeight(null);
        this.setSpeciesTotalSortedComputedWeight(null);
        this.setSpeciesTotalUnsortedComputedWeight(null);
        this.setSpeciesTotalComputedWeight(null);
        this.setBenthosTotalInertComputedWeight(null);
        this.setBenthosTotalLivingNotItemizedComputedWeight(null);
        this.setBenthosTotalSampleSortedComputedWeight(null);
        this.setBenthosTotalSortedComputedWeight(null);
        this.setBenthosTotalUnsortedComputedWeight(null);
        this.setBenthosTotalComputedWeight(null);
        this.setMarineLitterTotalComputedWeight(null);
        this.setCatchTotalRejectedComputedWeight(null);
        this.setCatchTotalSortedComputedWeight(null);
        this.setCatchTotalSortedSortedComputedWeight(null);
        this.setCatchTotalUnsortedComputedWeight(null);
        this.setCatchTotalComputedWeight(null);
        this.removeAllAttachment(this.getAttachment());
        this.getSpeciesUsed().clear();
        this.getMarineLitterCategoriesUsed().clear();
        this.setSpeciesDistinctSortedSpeciesCount(null);
        this.setBenthosDistinctSortedSpeciesCount(null);
        this.setSpeciesDistinctUnsortedSpeciesCount(null);
        this.setBenthosDistinctUnsortedSpeciesCount(null);
    }

    public boolean isDoNotCheckLeavingFrequencyScreen() {
        return this.doNotCheckLeavingFrequencyScreen;
    }

    public void setDoNotCheckLeavingFrequencyScreen(boolean doNotCheckLeavingFrequencyScreen) {
        this.doNotCheckLeavingFrequencyScreen = doNotCheckLeavingFrequencyScreen;
    }
}

