/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.util.tree;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.Batchs;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.measure.Measurement;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxonImpl;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.util.MeasurementPersistenceHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BatchTreeHelperSupport
extends AbstractPersistenceService {
    public static final Integer SORTING_TYPE_ID = PmfmId.SCIENTIFIC_CRUISE_SORTING_TYPE.getValue();
    public static final Integer SORTING_TYPE2_ID = PmfmId.SCIENTIFIC_CRUISE_SORTING_TYPE2.getValue();
    private static final Log log = LogFactory.getLog(BatchTreeHelperSupport.class);
    @Resource(name="measurementPersistenceHelper")
    protected MeasurementPersistenceHelper measurementPersistenceHelper;
    @Resource(name="catchBatchDao")
    protected CatchBatchExtendDao catchBatchDao;
    protected Comparator<Batch> batchComparator = Batchs.newRankOrderComparator();

    public final SortingBatch getVracBatch(CatchBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_VRAC.getValue());
    }

    public final SortingBatch getHorsVracBatch(CatchBatch batch) {
        return this.getSortingBatch((Batch)batch, "Hors Vrac", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_HORS_VRAC.getValue());
    }

    public final SortingBatch getOrCreateVracBatch(CatchBatch batch, Float weight, Float weightBeforeSampling) {
        return this.getOrCreate(batch, (Batch)batch, "Vrac", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_VRAC.getValue(), weight, weightBeforeSampling, (short)1);
    }

    public final SortingBatch getOrCreateHorsVracBatch(CatchBatch batch) {
        return this.getOrCreate(batch, (Batch)batch, "Hors Vrac", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_HORS_VRAC.getValue(), (short)2);
    }

    public final void setWeightAndSampleRatio(SortingBatch target, Float weight, Float weightBeforeSampling) {
        this.catchBatchDao.setSortingBatchWeights(target, weight, weightBeforeSampling, PmfmId.WEIGHT_MEASURED.getValue(), this.measurementPersistenceHelper.getRecorderDepartmentId());
    }

    public final void setSortingSamplingRatio(SortingBatch target, Float weight, Float weightBeforeSampling) {
        this.catchBatchDao.setSortingSamplingRatio(target, weight, weightBeforeSampling);
    }

    protected final SortingBatch get(Batch parentBatch, Integer sortingPmfmId, Integer sortingQualitativeValueId) {
        return this.getSortingBatch(parentBatch, null, sortingPmfmId, sortingQualitativeValueId);
    }

    protected final SortingBatch getSortingBatch(Batch source, String debugMessage, Integer ... ids) {
        return this.getSortingBatch(source.getChildBatchs(), debugMessage, ids);
    }

    protected final SortingBatch getSortingBatch(Collection<Batch> childs, String debugMessage, Integer ... ids) {
        int nbParams = ids.length / 2;
        Object[] params = new Object[nbParams * 3];
        for (int i = 0; i < nbParams; ++i) {
            Integer sortingPmfmId = ids[2 * i];
            Integer sortingQualitativeValueId = ids[2 * i + 1];
            params[3 * i] = "pmfmId";
            params[3 * i + 1] = sortingPmfmId;
            params[3 * i + 2] = sortingQualitativeValueId;
        }
        SortingBatch result = this.catchBatchDao.getSortingBatch(childs, params);
        if (result != null && debugMessage != null && log.isDebugEnabled()) {
            log.debug((Object)("Loaded " + debugMessage + ": " + result.getId()));
        }
        return result;
    }

    protected final SortingBatch getOrCreate(CatchBatch rootBatch, Batch batch, String debugMessage, Integer sortingPmfmId, Integer sortingQualitativeValueId, short rankOrder) {
        return this.getOrCreate(rootBatch, batch, debugMessage, sortingPmfmId, sortingQualitativeValueId, null, null, rankOrder);
    }

    protected final SortingBatch getOrCreate(CatchBatch rootBatch, Batch batch, String debugMessage, Integer sortingPmfmId, Integer sortingQualitativeValueId, Float totalWeight, short rankOrder) {
        return this.getOrCreate(rootBatch, batch, debugMessage, sortingPmfmId, sortingQualitativeValueId, totalWeight, null, rankOrder);
    }

    protected final SortingBatch getOrCreate(CatchBatch rootBatch, Batch batch, String debugMessage, Integer sortingPmfmId, Integer sortingQualitativeValueId, Float weight, Float weightBeforeSampling, short rankOrder) {
        SortingBatch result = this.getSortingBatch(batch, debugMessage, sortingPmfmId, sortingQualitativeValueId);
        if (result == null) {
            result = SortingBatch.Factory.newInstance();
            if (batch.getChildBatchs() == null) {
                batch.setChildBatchs((Collection)Sets.newHashSet());
            }
            batch.getChildBatchs().add(result);
            QualityFlagImpl qualityFlag = this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue()));
            result.setQualityFlag((QualityFlag)qualityFlag);
            result.setRootBatch(rootBatch);
            result.setParentBatch(batch);
            result.setExhaustiveInventory(Boolean.valueOf(true));
            result.setRankOrder(Short.valueOf(rankOrder));
            result.setReferenceTaxon(null);
            result.setTaxonGroup(null);
            Collection sortingMeasurements = result.getSortingMeasurements();
            HashSet notChangedSortingMeasurements = Sets.newHashSet();
            if (sortingMeasurements != null) {
                notChangedSortingMeasurements.addAll(sortingMeasurements);
            }
            if (sortingPmfmId != null && sortingQualitativeValueId != null) {
                SortingMeasurement sm = this.measurementPersistenceHelper.setSortingMeasurement(result, sortingPmfmId, sortingQualitativeValueId);
                notChangedSortingMeasurements.remove(sm);
            }
            if (sortingMeasurements != null) {
                sortingMeasurements.removeAll(notChangedSortingMeasurements);
            }
            this.catchBatchDao.createSortingBatch(result, rootBatch);
        }
        this.setWeightAndSampleRatio(result, weight, weightBeforeSampling);
        return result;
    }

    public final void displayCatchBatch(CatchBatch result) {
        StringBuilder sb = new StringBuilder();
        this.displayBatch((Batch)result, 0, sb);
        log.info((Object)sb.toString());
    }

    protected final void displayBatch(Batch batch, int level, StringBuilder sb) {
        QuantificationMeasurement quantificationMeasurement;
        BatchTreeToStringStyle style = new BatchTreeToStringStyle();
        ToStringBuilder builder = new ToStringBuilder((Object)batch, (ToStringStyle)style);
        builder.append("id", (Object)batch.getId());
        builder.append("rankOrder", (Object)batch.getRankOrder());
        if (batch instanceof CatchBatch) {
            CatchBatch catchBatch = (CatchBatch)batch;
            builder.append("synchronizationStatus", (Object)catchBatch.getSynchronizationStatus());
        }
        if (batch instanceof SortingBatch) {
            SortingBatch sortingBatch = (SortingBatch)batch;
            if (sortingBatch.getSamplingRatio() != null) {
                builder.append("samplingRatio", (Object)sortingBatch.getSamplingRatio());
            }
            if (sortingBatch.getSamplingRatioText() != null) {
                builder.append("samplingRatioText", (Object)sortingBatch.getSamplingRatioText());
            }
            if (sortingBatch.getIndividualCount() != null) {
                builder.append("individualCount", (Object)sortingBatch.getIndividualCount());
            }
            if (sortingBatch.getReferenceTaxon() != null) {
                ReferenceTaxon referenceTaxon = sortingBatch.getReferenceTaxon();
                builder.append("referenceTaxon", (Object)this.load(ReferenceTaxonImpl.class, referenceTaxon.getId()).getName());
            }
            SortingMeasurement sm = null;
            if (sortingBatch.getSortingMeasurements() != null && sortingBatch.getSortingMeasurements().size() == 1) {
                sm = (SortingMeasurement)sortingBatch.getSortingMeasurements().iterator().next();
            } else if (sortingBatch.getReferenceTaxon() != null && sortingBatch.getReferenceTaxon().getId() != null) {
                sm = this.measurementPersistenceHelper.getInheritedSortingMeasurement(sortingBatch);
            }
            if (sm != null) {
                String sortingMeasurementStr = this.measurementPersistenceHelper.toString((Measurement)sm);
                builder.append("sortingMeasurement", (Object)sortingMeasurementStr);
            }
        }
        if ((quantificationMeasurement = this.measurementPersistenceHelper.getWeightMeasurementQuantificationMeasurement(batch)) != null) {
            String quantificationMeasurementStr = this.measurementPersistenceHelper.toString((Measurement)quantificationMeasurement);
            builder.append("weightQuantificationMeasurement", (Object)quantificationMeasurementStr);
            builder.append("weightQuantificationMeasurement.isReferenceQuantification", (Object)quantificationMeasurement.getIsReferenceQuantification());
        }
        if (batch.getWeight() != null) {
            builder.append("weight", (Object)batch.getWeight());
        }
        if (batch.getWeightBeforeSampling() != null) {
            builder.append("weightBeforeSampling", (Object)batch.getWeightBeforeSampling());
        }
        builder.append("qualityFlag", (Object)this.load(QualityFlagImpl.class, (Serializable)((Object)batch.getQualityFlag().getCode())).getName());
        String prefix = "\n" + StringUtils.leftPad((String)"", (int)(2 * level));
        String batchStr = Joiner.on((String)prefix).join((Object[])builder.build().split("\n"));
        sb.append(prefix).append(batchStr);
        Collection childBatchs = batch.getChildBatchs();
        if (childBatchs != null) {
            ArrayList childBatchList = new ArrayList(childBatchs);
            Collections.sort(childBatchList, this.batchComparator);
            for (Batch childBatch : childBatchList) {
                this.displayBatch(childBatch, level + 1, sb);
            }
        }
    }

    public final CatchBatch loadCatchBatch(Integer catchBatchId) {
        return this.catchBatchDao.loadFullTreeWithCache(catchBatchId, PmfmId.WEIGHT_MEASURED.getValue(), true, true);
    }

    static final class BatchTreeToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        BatchTreeToStringStyle() {
            this.setUseClassName(true);
            this.setUseShortClassName(true);
            this.setContentStart("");
            this.setFieldSeparator(SystemUtils.LINE_SEPARATOR + "  | ");
            this.setFieldSeparatorAtStart(true);
            this.setContentEnd("");
        }
    }
}

