/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.util.tree;

import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.tutti.persistence.service.util.tree.BatchTreeHelperSupport;
import fr.ifremer.tutti.persistence.service.util.tree.BenthosBatchTreeHelper;
import fr.ifremer.tutti.persistence.service.util.tree.SpeciesBatchTreeHelper;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="batchTreeHelper")
public class BatchTreeHelper
extends BatchTreeHelperSupport {
    @Resource(name="benthosBatchTreeHelper")
    protected BenthosBatchTreeHelper benthosBatchTreeHelper;
    @Resource(name="speciesBatchTreeHelper")
    protected SpeciesBatchTreeHelper speciesBatchTreeHelper;

    public SortingBatch getMarineLitterRootBatch(CatchBatch batch) {
        return this.getSortingBatch((Batch)batch, "Hors Vrac > Marine Litter", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_HORS_VRAC.getValue(), SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_MARINE_LITTER.getValue());
    }

    public SortingBatch getRejectedBatch(CatchBatch batch) {
        return this.getSortingBatch((Batch)batch, "Unsorted", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.UNSORTED.getValue());
    }

    public SortingBatch getSpeciesVracRootBatch(SortingBatch batch) {
        return this.speciesBatchTreeHelper.getVracRootBatch(batch);
    }

    public SortingBatch getBenthosVracRootBatch(SortingBatch batch) {
        return this.benthosBatchTreeHelper.getVracRootBatch(batch);
    }

    public SortingBatch getSpeciesVracAliveNotItemizedRootBatch(SortingBatch batch) {
        return this.speciesBatchTreeHelper.getVracAliveNotItemizedRootBatch(batch);
    }

    public SortingBatch getBenthosVracAliveNotItemizedRootBatch(SortingBatch batch) {
        return this.benthosBatchTreeHelper.getVracAliveNotItemizedRootBatch(batch);
    }

    public SortingBatch getSpeciesVracInertRootBatch(SortingBatch batch) {
        return this.speciesBatchTreeHelper.getVracInertRootBatch(batch);
    }

    public SortingBatch getBenthosVracInertRootBatch(SortingBatch batch) {
        return this.benthosBatchTreeHelper.getVracInertRootBatch(batch);
    }

    public SortingBatch getSpeciesVracAliveItemizedRootBatch(SortingBatch batch) {
        return this.speciesBatchTreeHelper.getVracAliveItemizedRootBatch(batch);
    }

    public SortingBatch getBenthosVracAliveItemizedRootBatch(SortingBatch batch) {
        return this.benthosBatchTreeHelper.getVracAliveItemizedRootBatch(batch);
    }

    public SortingBatch getSpeciesHorsVracRootBatch(SortingBatch batch) {
        return this.speciesBatchTreeHelper.getHorsVracRootBatch(batch);
    }

    public SortingBatch getBenthosHorsVracRootBatch(SortingBatch batch) {
        return this.benthosBatchTreeHelper.getHorsVracRootBatch(batch);
    }

    public SortingBatch getMarineLitterRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Hors Vrac > MarineLitter", SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_MARINE_LITTER.getValue());
    }

    public SortingBatch getOrCreateSpeciesVracRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.speciesBatchTreeHelper.getOrCreateVracRootBatch(target, batch, totalWeight);
    }

    public SortingBatch getOrCreateSpeciesVracAliveNotItemizedRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.speciesBatchTreeHelper.getOrCreateVracAliveNotItemizedRootBatch(target, batch, totalWeight);
    }

    public SortingBatch getOrCreateSpeciesVracInertRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.speciesBatchTreeHelper.getOrCreateVracInertRootBatch(target, batch, totalWeight);
    }

    public SortingBatch getOrCreateSpeciesVracAliveItemizedRootBatch(CatchBatch target, SortingBatch batch) {
        return this.speciesBatchTreeHelper.getOrCreateVracAliveItemizedRootBatch(target, batch);
    }

    public SortingBatch getOrCreateBenthosVracRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.benthosBatchTreeHelper.getOrCreateVracRootBatch(target, batch, totalWeight);
    }

    public SortingBatch getOrCreateBenthosVracAliveNotItemizedRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.benthosBatchTreeHelper.getOrCreateVracAliveNotItemizedRootBatch(target, batch, totalWeight);
    }

    public SortingBatch getOrCreateBenthosVracInertRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.benthosBatchTreeHelper.getOrCreateVracInertRootBatch(target, batch, totalWeight);
    }

    public SortingBatch getOrCreateBenthosVracAliveItemizedRootBatch(CatchBatch target, SortingBatch batch) {
        return this.benthosBatchTreeHelper.getOrCreateVracAliveItemizedRootBatch(target, batch);
    }

    public SortingBatch getOrCreateSpeciesHorsVracRootBatch(CatchBatch target, SortingBatch batch) {
        return this.speciesBatchTreeHelper.getOrCreateHorsVracRootBatch(target, batch);
    }

    public SortingBatch getOrCreateBenthosHorsVracRootBatch(CatchBatch target, SortingBatch batch) {
        return this.benthosBatchTreeHelper.getOrCreateHorsVracRootBatch(target, batch);
    }

    public SortingBatch getOrCreateMarineLitterRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, "Hors Vrac > Marine Litter", SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_MARINE_LITTER.getValue(), totalWeight, (short)3);
    }

    public SortingBatch getOrCreateRejectedBatch(CatchBatch batch, Float weight) {
        return this.getOrCreate(batch, (Batch)batch, "Unsorted", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.UNSORTED.getValue(), weight, (short)3);
    }
}

