/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.referential;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import fr.ifremer.tutti.persistence.entities.referential.AbstractVessels;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntities;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;

public class Vessels
extends AbstractVessels {
    public static final Predicate<Vessel> IS_TEMPORARY = Vessels::isTemporary;
    public static Function<Vessel, String> GET_REGISTRATION_CODE_OR_INTERNATIONAL_REGISTRATION_CODE = input -> {
        String result = input.getRegistrationCode();
        if (result == null) {
            result = input.getInternationalRegistrationCode();
        }
        return result;
    };
    public static final Function<Vessel, String> GET_INTERNAL_REGISTRATION_CODE = Vessel::getInternationalRegistrationCode;

    public static boolean isTemporary(Vessel vessel) {
        Preconditions.checkNotNull((Object)vessel);
        Preconditions.checkNotNull((Object)vessel.getId());
        return TuttiReferentialEntities.isStatusTemporary(vessel) && Vessels.isTemporaryId(vessel.getId());
    }

    public static boolean isTemporaryId(String id) {
        Preconditions.checkNotNull((Object)id);
        return id.startsWith("#TEMP\u00bf");
    }
}

