/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.dao;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameDaoImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonRefVO;
import fr.ifremer.tutti.persistence.dao.TaxonNameDaoTutti;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository(value="taxonNameDaoTutti")
@Lazy
public class TaxonNameDaoTuttiImpl
extends TaxonNameDaoImpl
implements TaxonNameDaoTutti {
    @Autowired
    public TaxonNameDaoTuttiImpl(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public TaxonRefVO[] getAllTaxonNamesWithObsoletes(boolean withSynonyms, Integer transcribingId) {
        Session session = this.getSession();
        boolean withTranscribing = transcribingId != null;
        Query query = withSynonyms ? session.getNamedQuery("allTaxonNamesWithObsoletes") : session.getNamedQuery("allTaxonNamesIsReferentWithObsoletes");
        ArrayList<TaxonRefVO> results = new ArrayList<TaxonRefVO>();
        Iterator iterator = query.iterate();
        while (iterator.hasNext()) {
            Object[] cols = (Object[])iterator.next();
            TaxonRefVO taxonNameRefTaxVO = this.loadTaxon(cols, false);
            results.add(taxonNameRefTaxVO);
        }
        if (results.size() == 0) {
            return null;
        }
        if (withTranscribing) {
            query = session.getNamedQuery("allTranscribingForAType");
            query.setInteger("transcribingTypeId", transcribingId.intValue());
            ImmutableListMultimap r = Multimaps.index(results, TaxonRefVO::getReferenceTaxonId);
            Iterator iterator2 = query.iterate();
            while (iterator2.hasNext()) {
                Object[] cols = (Object[])iterator2.next();
                Integer referencetaxonId = (Integer)cols[0];
                String externalCode = (String)cols[1];
                Collection taxonRefVOs = r.get((Object)referencetaxonId);
                if (taxonRefVOs == null) continue;
                for (TaxonRefVO taxonRefVO : taxonRefVOs) {
                    taxonRefVO.setExternalCode(externalCode);
                }
            }
        }
        return results.toArray(new TaxonRefVO[results.size()]);
    }
}

