/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment.actions;

import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentItem;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentItemModel;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class OpenAttachmentAction
extends SimpleActionSupport<AttachmentItem> {
    private static final Log log = LogFactory.getLog(OpenAttachmentAction.class);
    private static final long serialVersionUID = 1L;

    public OpenAttachmentAction(AttachmentItem ui) {
        super(ui);
    }

    @Override
    protected void onActionPerformed(AttachmentItem ui) {
        AttachmentItemModel model = ui.getModel();
        File file = model.isCreate() ? new File(model.getPath()) : ui.getHandler().getPersistenceService().getAttachmentFile(model.getId());
        if (!file.exists()) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.attachmentEditor.fileNotFound", (Object[])new Object[]{file.getAbsolutePath()}));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Open attachment: " + file));
        }
        TuttiUIUtil.openResource(file);
    }
}

