/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.rtp;

import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.SwingUtil;
import org.nuiton.i18n.I18n;

public class RtpCellRenderer
extends DefaultTableCellRenderer {
    public static final String TEXT_PATTERN = "<html><body>%s</body></html>";
    private static final long serialVersionUID = 1L;
    private final String withoutRtp;
    private final String withRtp;
    private Font defaultFont;
    private Font selectedFont;

    public RtpCellRenderer() {
        this.setHorizontalAlignment(0);
        this.setIcon(SwingUtil.createActionIcon((String)"edit-rtp"));
        this.withoutRtp = I18n.n((String)"tutti.editRtp.withoutRtp.tip", (Object[])new Object[0]);
        this.withRtp = I18n.n((String)"tutti.editRtp.withRtp.tip", (Object[])new Object[0]);
    }

    @Override
    protected void setValue(Object value) {
    }

    @Override
    public JComponent getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String textValue;
        String toolTipTextValue;
        if (this.defaultFont == null) {
            this.defaultFont = UIManager.getFont("Table.font");
            this.selectedFont = this.defaultFont.deriveFont(1);
        }
        int rowIndex = table.convertRowIndexToModel(row);
        EditProtocolSpeciesRowModel rowModel = (EditProtocolSpeciesRowModel)((EditProtocolSpeciesTableModel)((Object)table.getModel())).getEntry(rowIndex);
        boolean useRtp = rowModel.isUseRtp();
        if (!useRtp) {
            toolTipTextValue = "<i>" + I18n.t((String)this.withoutRtp, (Object[])new Object[0]) + "</i>";
            textValue = I18n.t((String)this.withoutRtp, (Object[])new Object[0]);
        } else {
            toolTipTextValue = I18n.t((String)"tutti.editRtp.tooltip", (Object[])new Object[]{rowModel.getRtpMale().getA(), rowModel.getRtpMale().getB(), rowModel.getRtpFemale().getA(), rowModel.getRtpFemale().getB(), rowModel.getRtpUndefined().getA(), rowModel.getRtpUndefined().getB()});
            textValue = I18n.t((String)this.withRtp, (Object[])new Object[0]);
        }
        boolean editable = table.isCellEditable(row, column);
        toolTipTextValue = String.format(TEXT_PATTERN, toolTipTextValue);
        this.setEnabled(editable);
        this.setText(textValue);
        this.setToolTipText(toolTipTextValue);
        this.setBackground(null);
        this.setForeground(Color.BLACK);
        if (isSelected) {
            this.setFont(this.selectedFont);
        } else {
            this.setFont(this.defaultFont);
        }
        return this;
    }
}

