/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.fishing.actions;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.FishingOperations;
import fr.ifremer.tutti.service.operationimport.FishingOperationImportService;
import fr.ifremer.tutti.service.operationimport.ImportFromColumnFileFishingOperationNotFoundException;
import fr.ifremer.tutti.service.operationimport.ImportFromColumnFileInvalidRowException;
import fr.ifremer.tutti.service.operationimport.ImportFromColumnFileMissingHeaderException;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUIModel;
import fr.ifremer.tutti.ui.swing.content.protocol.actions.LoadProtocolImportColumnsAction;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.AbstractImportErrorInfo;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class ImportFishingOperationCaracteristicsFromColumnFileAction
extends LongActionSupport<EditFishingOperationUIModel, EditFishingOperationUI, EditFishingOperationUIHandler> {
    private static final Log log = LogFactory.getLog(LoadProtocolImportColumnsAction.class);
    protected File importFile;
    protected FishingOperation fishingOperationToMerge;

    public ImportFishingOperationCaracteristicsFromColumnFileAction(EditFishingOperationUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean result;
        boolean bl = result = super.prepareAction() && ((EditFishingOperationUIModel)this.getModel()).isImportFromColumnFileEnabled();
        if (result) {
            this.importFile = this.chooseFile(I18n.t((String)"tutti.editFishingOperation.action.title.choose.importColumnsFile", (Object[])new Object[0]), I18n.t((String)"tutti.editFishingOperation.action.chooseColumnsFile.import", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            result = this.importFile != null;
        }
        return result;
    }

    @Override
    public void doAction() throws ImportFromColumnFileInvalidRowException, ImportFromColumnFileFishingOperationNotFoundException, ImportFromColumnFileMissingHeaderException, IOException {
        EditFishingOperationUIModel model = (EditFishingOperationUIModel)this.getModel();
        this.fishingOperationToMerge = FishingOperations.newFishingOperation();
        Binder toBeanBinder = BinderFactory.newBinder(EditFishingOperationUIModel.class, FishingOperation.class);
        toBeanBinder.copy((Object)model, (Object)this.fishingOperationToMerge, new String[0]);
        FishingOperationImportService importService = this.getContext().getFishingOperationImportService();
        String errorMessage = null;
        try {
            importService.importCaracteristicsFromColumnFile(this.importFile, this.fishingOperationToMerge);
        }
        catch (ImportFromColumnFileInvalidRowException error) {
            errorMessage = "";
            for (AbstractImportErrorInfo errorInfo : error.getErrors()) {
                Throwable errorInfoCause = errorInfo.getCause();
                if (log.isErrorEnabled()) {
                    log.error((Object)errorInfoCause.getLocalizedMessage());
                }
                errorMessage = errorMessage + "<li>" + errorInfoCause.getLocalizedMessage().replaceAll("\\s+", " ") + "</li>";
            }
        }
        catch (ImportFromColumnFileFishingOperationNotFoundException error) {
            errorMessage = "<li>" + I18n.t((String)"tutti.editFishingOperation.action.importColumns.operationNotFound", (Object[])new Object[0]) + "</li>";
        }
        catch (ImportFromColumnFileMissingHeaderException error) {
            errorMessage = I18n.t((String)"tutti.editFishingOperation.action.importColumns.missingHeader", (Object[])new Object[]{error.getImportColumn()});
        }
        if (errorMessage != null) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.editFishingOperation.action.importColumns.error", (Object[])new Object[]{errorMessage}));
        }
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        EditFishingOperationUI ui = (EditFishingOperationUI)this.getUI();
        EditFishingOperationUIModel model = (EditFishingOperationUIModel)this.getModel();
        model.fromEntity(this.fishingOperationToMerge);
        ui.getRecorderPersonList().getHandler().setSelected(this.fishingOperationToMerge.getRecorderPerson());
        ui.getSecondaryVesselList().getHandler().setSelected(this.fishingOperationToMerge.getSecondaryVessel());
        ui.getGearUseFeatureTabContent().getHandler().mergeCaracteristics(this.fishingOperationToMerge);
        ui.getVesselUseFeatureTabContent().getHandler().mergeCaracteristics(this.fishingOperationToMerge);
        this.sendMessage(I18n.t((String)"tutti.editFishingOperation.action.importColumns.success", (Object[])new Object[0]));
    }
}

