/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.ui.swing.content.operation.catches.species.EditSpeciesBatchPanelUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JTables;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;

public class SpeciesFrequencyCellComponent
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected Color computedDataColor;
    private static final Log log = LogFactory.getLog(SpeciesFrequencyCellComponent.class);
    private Font defaulfFont;
    private Font selectedFont;

    public SpeciesFrequencyCellComponent(Color computedDataColor) {
        this.setHorizontalAlignment(0);
        this.setIcon(SwingUtil.createActionIcon((String)"show-frequency"));
        this.computedDataColor = computedDataColor;
    }

    public void setComputedOrNotText(ComputableData<Integer> data) {
        String text;
        if (data != null && data.getData() != null) {
            text = String.valueOf(data.getData());
        } else if (data != null && data.getComputedData() != null && data.getComputedData() != 0) {
            String blue = Integer.toHexString(this.computedDataColor.getRGB()).substring(2);
            text = "<html><em style='color: #" + blue + "'>" + data.getComputedData() + "</em></html>";
        } else {
            text = " - ";
        }
        this.setText(text);
        this.setToolTipText(text);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.defaulfFont == null) {
            this.defaulfFont = UIManager.getFont("Table.font");
            this.selectedFont = this.defaulfFont.deriveFont(1);
        }
        Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected) {
            result.setFont(this.selectedFont);
        } else {
            result.setFont(this.defaulfFont);
        }
        return result;
    }

    public static TableCellRenderer newRender(Color computedDataColor) {
        return new FrequencyCellRenderer(computedDataColor);
    }

    public static TableCellEditor newEditor(SpeciesBatchUI ui, Color computedDataColor) {
        return new FrequencyCellEditor(ui, computedDataColor);
    }

    public static class FrequencyCellRenderer
    implements TableCellRenderer {
        protected final SpeciesFrequencyCellComponent component;

        public FrequencyCellRenderer(Color computedDataColor) {
            this.component = new SpeciesFrequencyCellComponent(computedDataColor);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.component.setForeground(Color.BLACK);
            ComputableData data = (ComputableData)((Object)value);
            SpeciesFrequencyCellComponent result = (SpeciesFrequencyCellComponent)this.component.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            boolean editable = table.isCellEditable(row, column);
            result.setEnabled(editable);
            result.setComputedOrNotText(data);
            return result;
        }
    }

    public static class FrequencyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        protected final SpeciesFrequencyCellComponent component;
        protected final SpeciesBatchUI ui;
        protected JTable table;
        protected SpeciesBatchTableModel tableModel;
        protected ColumnIdentifier<SpeciesBatchRowModel> columnIdentifier;
        protected SpeciesBatchRowModel editRow;
        protected Integer rowIndex;
        protected Integer nextEditableRowIndex;
        protected Integer columnIndex;
        protected SpeciesBatchRowModel previousSiblingRow;

        public FrequencyCellEditor(SpeciesBatchUI ui, Color computedDataColor) {
            this.ui = ui;
            this.component = new SpeciesFrequencyCellComponent(computedDataColor);
            this.component.setBorder(new LineBorder(Color.BLACK));
            this.component.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        e.consume();
                        this.startEdit();
                    }
                }
            });
            this.component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                    this.startEdit();
                }
            });
        }

        public SpeciesBatchRowModel getEditRow() {
            return this.editRow;
        }

        public Integer getNextEditableRowIndex() {
            return this.nextEditableRowIndex;
        }

        public SpeciesBatchRowModel getPreviousSiblingRow() {
            return this.previousSiblingRow;
        }

        public void initEditor(JTable table, int row, int column) {
            this.tableModel = (SpeciesBatchTableModel)((Object)table.getModel());
            this.table = table;
            this.columnIdentifier = SpeciesBatchTableModel.COMPUTED_NUMBER;
            this.rowIndex = row;
            this.columnIndex = column;
            this.editRow = (SpeciesBatchRowModel)this.tableModel.getEntry(row);
        }

        public void startEdit() {
            Objects.requireNonNull(this.tableModel, "No table model assigned.");
            Objects.requireNonNull(this.editRow, "No editRow found.");
            this.nextEditableRowIndex = this.tableModel.getNextEditableFrequencyRow(this.rowIndex + 1);
            this.previousSiblingRow = this.tableModel.getPreviousSibling(this.editRow);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will edit frequencies for row: " + this.rowIndex + ", nextEditableRow: " + this.nextEditableRowIndex + ", previous siblingRow: " + this.previousSiblingRow));
            }
            EditSpeciesBatchPanelUI parent = this.ui.getParentContainer(EditSpeciesBatchPanelUI.class);
            parent.getHandler().editSpeciesFrequencies(this);
        }

        public void save(SpeciesFrequencyUIModel frequencyModel) {
            if (frequencyModel.isValid()) {
                this.editRow.setWeight(frequencyModel.getTotalWeight());
                if (frequencyModel.isSimpleCountingMode()) {
                    this.editRow.setNumber(frequencyModel.getSimpleCount());
                    this.editRow.setIndividualObservation(new ArrayList<IndividualObservationBatchRowModel>());
                    this.editRow.setFrequency(new ArrayList<SpeciesFrequencyRowModel>());
                } else {
                    this.editRow.setNumber(null);
                    ArrayList<IndividualObservationBatchRowModel> individualObservation = new ArrayList<IndividualObservationBatchRowModel>();
                    individualObservation.addAll(frequencyModel.getIndividualObservationModel().getRows());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Push back " + individualObservation.size() + " observations to batch " + frequencyModel.getBatch()));
                    }
                    this.editRow.setIndividualObservation(individualObservation);
                    List<SpeciesFrequencyRowModel> frequency = frequencyModel.getRows().stream().filter(row -> row.isValid() && (row.withNumber() || row.withWeight())).collect(Collectors.toList());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Push back " + frequency.size() + " frequencies to batch " + frequencyModel.getBatch()));
                    }
                    this.editRow.setFrequency(frequency);
                }
                this.ui.getHandler().updateTotalFromFrequencies(this.editRow);
            }
            this.ui.getHandler().saveRow(this.editRow);
        }

        public void save(SpeciesFrequencyUIModel frequencyModel, boolean quit) {
            this.save(frequencyModel);
            if (quit) {
                int r = this.rowIndex;
                int c = this.columnIndex;
                this.stopCellEditing();
                JTables.doSelectCell((JTable)this.table, (int)r, (int)c);
                this.table.requestFocus();
            } else {
                int nextR = this.nextEditableRowIndex;
                int c = this.columnIndex;
                this.stopCellEditing();
                this.rowIndex = nextR;
                this.editRow = (SpeciesBatchRowModel)this.tableModel.getEntry(this.rowIndex);
                JTables.doSelectCell((JTable)this.table, (int)this.rowIndex, (int)c);
                this.startEdit();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.initEditor(table, row, column);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set columnIdentifier (" + column + ") :: " + this.columnIdentifier.getPropertyName()));
            }
            ComputableData data = (ComputableData)((Object)value);
            this.component.setComputedOrNotText(data);
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            Objects.requireNonNull(this.editRow, "No editRow found in editor.");
            ComputableData<Integer> result = null;
            if (this.columnIdentifier == SpeciesBatchTableModel.COMPUTED_NUMBER) {
                result = this.editRow.getComputedOrNotNumber();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("editor value (" + this.columnIdentifier + "): " + result));
            }
            return result;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.rowIndex = null;
            this.nextEditableRowIndex = null;
            this.columnIndex = null;
            this.editRow = null;
        }
    }
}

