/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.model.OperationDataModel;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersistenceHelper;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForOperation;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.genericformat.csv.OperationRow;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportOperationAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportOperationAction.class);
    private final GenericformatImportPersistenceHelper persistenceHelper;

    public ImportOperationAction(GenericFormatImportContext importContext, GenericformatImportPersistenceHelper persistenceHelper) {
        super(importContext);
        this.persistenceHelper = persistenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid() && this.importContext.getSurveyFileResult().isValid();
    }

    @Override
    protected void skipExecute() {
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.skip.import.operations", (Object[])new Object[0]));
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Import operation.csv file.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.operations", (Object[])new Object[0]));
        boolean importSpecies = this.importContext.getImportRequest().isImportSpecies();
        boolean importBenthos = this.importContext.getImportRequest().isImportBenthos();
        boolean importMarineLitter = this.importContext.getImportRequest().isImportMarineLitter();
        try (CsvConsumerForOperation consumer = this.importContext.loadOperations(true);){
            for (ImportRow row : consumer) {
                GenericFormatImportCruiseContext cruiseContext = consumer.validateRow(row, this.importContext);
                if (cruiseContext == null) continue;
                OperationRow bean = (OperationRow)row.getBean();
                FishingOperation fishingOperation = bean.getFishingOperation();
                CatchBatch catchBatch = bean.getCatchBatch();
                Collection<AttachmentRow> operationAttachmentRows = this.importContext.popAttachmentRows(ObjectTypeCode.OPERATION, bean.getFishingOperationObjectId());
                Collection<AttachmentRow> catchAttachmentRows = this.importContext.popAttachmentRows(ObjectTypeCode.CATCH_BATCH, bean.getCatchObjectId());
                OperationDataModel selectionFishingOperation = cruiseContext.getSelectedFishingOperation(fishingOperation);
                if (selectionFishingOperation == null) {
                    this.skipOperation(cruiseContext, fishingOperation);
                    continue;
                }
                consumer.prepareRowForPersist(row, importSpecies, importBenthos, importMarineLitter);
                this.processOperation(cruiseContext, fishingOperation, catchBatch, operationAttachmentRows, catchAttachmentRows);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close operation.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            this.importContext.getOperationFileResult().addGlobalError(e.getMessage());
        }
    }

    private void skipOperation(GenericFormatImportCruiseContext cruiseContext, FishingOperation fishingOperation) {
        String cruiseStr = cruiseContext.getCruiseLabel();
        String operationStr = this.importContext.decorate(fishingOperation);
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.skipNotSelected.operation", (Object[])new Object[]{cruiseStr, operationStr}));
        cruiseContext.addSkippedFishingOperation(fishingOperation);
    }

    private void processOperation(GenericFormatImportCruiseContext cruiseContext, FishingOperation fishingOperation, CatchBatch catchBatch, Collection<AttachmentRow> operationAttachmentRows, Collection<AttachmentRow> catchAttachmentRows) {
        Pair<FishingOperation, CatchBatch> savedFishingOperation;
        String cruiseStr = cruiseContext.getCruiseLabel();
        String operationStr = this.importContext.decorate(fishingOperation);
        OperationDataModel existingOperationData = cruiseContext.getExistingFishingOperationData(fishingOperation);
        if (existingOperationData == null) {
            this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.create.operation", (Object[])new Object[]{cruiseStr, operationStr}));
            savedFishingOperation = this.addFishingOperation(fishingOperation, catchBatch, operationAttachmentRows, catchAttachmentRows);
        } else {
            fishingOperation.setId(existingOperationData.getId());
            if (this.importContext.getImportRequest().isUpdateOperations()) {
                this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.update.operation", (Object[])new Object[]{cruiseStr, operationStr}));
                savedFishingOperation = this.updateFishingOperation(fishingOperation, catchBatch, operationAttachmentRows, catchAttachmentRows);
            } else {
                this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.skip.operation", (Object[])new Object[]{cruiseStr, operationStr}));
                savedFishingOperation = Pair.of((Object)fishingOperation, (Object)catchBatch);
            }
        }
        this.importContext.addImportedFishingOperation((FishingOperation)savedFishingOperation.getLeft(), (CatchBatch)savedFishingOperation.getRight());
    }

    private Pair<FishingOperation, CatchBatch> addFishingOperation(FishingOperation fishingOperation, CatchBatch catchBatch, Collection<AttachmentRow> operationAttachmentRows, Collection<AttachmentRow> catchAttachmentRows) {
        String cruiseStr = this.importContext.decorate(fishingOperation);
        boolean createCruise = TuttiEntities.isNew((TuttiEntity)fishingOperation);
        Preconditions.checkState((boolean)createCruise, (Object)("In addFishingOperation method, can't update existing operation: " + cruiseStr));
        if (log.isInfoEnabled()) {
            log.info((Object)("Create operation: " + cruiseStr));
        }
        FishingOperation createdFishingOperation = this.persistenceHelper.createFishingOperation(fishingOperation);
        catchBatch.setFishingOperation(createdFishingOperation);
        CatchBatch createdCatchBatch = this.persistenceHelper.createCatchBatch(catchBatch);
        boolean importAttachments = this.importContext.getImportRequest().isImportAttachments();
        if (importAttachments) {
            this.persistenceHelper.persistAttachments(createdFishingOperation.getIdAsInt(), operationAttachmentRows);
            this.persistenceHelper.persistAttachments(createdCatchBatch.getIdAsInt(), catchAttachmentRows);
        }
        return Pair.of((Object)createdFishingOperation, (Object)createdCatchBatch);
    }

    private Pair<FishingOperation, CatchBatch> updateFishingOperation(FishingOperation fishingOperation, CatchBatch catchBatch, Collection<AttachmentRow> operationAttachmentRows, Collection<AttachmentRow> catchAttachmentRows) {
        CatchBatch updatedCatchBatch;
        String operationStr = this.importContext.decorate(fishingOperation);
        boolean createFishingOperation = TuttiEntities.isNew((TuttiEntity)fishingOperation);
        Preconditions.checkState((!createFishingOperation ? 1 : 0) != 0, (Object)("In updateFishingOperation method, can't create new operation: " + operationStr));
        Preconditions.checkState((boolean)this.importContext.getImportRequest().isUpdateOperations(), (Object)("In updateFishingOperation method, must be allowed to update operation: " + operationStr));
        if (log.isInfoEnabled()) {
            log.info((Object)("Persist fishing Operation: " + operationStr));
        }
        FishingOperation updatedFishingOperation = this.persistenceHelper.saveFishingOperation(fishingOperation);
        catchBatch.setFishingOperation(updatedFishingOperation);
        if (this.persistenceHelper.isWithCatchBatch(updatedFishingOperation.getIdAsInt())) {
            CatchBatch existingCatchBatch = this.persistenceHelper.getExistingCatchBatch(updatedFishingOperation.getIdAsInt());
            catchBatch.setId(existingCatchBatch.getId());
            if (!this.importContext.getImportRequest().isImportSpecies()) {
                catchBatch.setSpeciesTotalSortedWeight(existingCatchBatch.getSpeciesTotalSortedWeight());
                catchBatch.setSpeciesTotalInertWeight(existingCatchBatch.getSpeciesTotalInertWeight());
                catchBatch.setSpeciesTotalLivingNotItemizedWeight(existingCatchBatch.getSpeciesTotalLivingNotItemizedWeight());
            }
            if (!this.importContext.getImportRequest().isImportBenthos()) {
                catchBatch.setBenthosTotalSortedWeight(existingCatchBatch.getBenthosTotalSortedWeight());
                catchBatch.setBenthosTotalInertWeight(existingCatchBatch.getBenthosTotalInertWeight());
                catchBatch.setBenthosTotalLivingNotItemizedWeight(existingCatchBatch.getBenthosTotalLivingNotItemizedWeight());
            }
            if (!this.importContext.getImportRequest().isImportMarineLitter()) {
                catchBatch.setMarineLitterTotalWeight(existingCatchBatch.getMarineLitterTotalWeight());
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Update catch batch (" + operationStr + "): " + existingCatchBatch.getId()));
            }
            updatedCatchBatch = this.persistenceHelper.saveCatchBatch(catchBatch);
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Create new catchBatch (" + operationStr + ")"));
            }
            updatedCatchBatch = this.persistenceHelper.createCatchBatch(catchBatch);
        }
        boolean importAttachments = this.importContext.getImportRequest().isImportAttachments();
        if (importAttachments) {
            this.persistenceHelper.deleteAllAttachments(ObjectTypeCode.OPERATION, fishingOperation.getIdAsInt());
            this.persistenceHelper.deleteAllAttachments(ObjectTypeCode.CATCH_BATCH, catchBatch.getIdAsInt());
            this.persistenceHelper.persistAttachments(updatedFishingOperation.getIdAsInt(), operationAttachmentRows);
            this.persistenceHelper.persistAttachments(updatedCatchBatch.getIdAsInt(), catchAttachmentRows);
        }
        return Pair.of((Object)updatedFishingOperation, (Object)updatedCatchBatch);
    }
}

