/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.service.TuttiValidationDataContextSupport;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.service.csv.CsvComsumer;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportValidationDataContext;
import fr.ifremer.tutti.service.genericformat.consumer.CruiseNotFoundException;
import fr.ifremer.tutti.service.genericformat.consumer.FishingOperationNotFoundInCruiseException;
import fr.ifremer.tutti.service.genericformat.consumer.GearNotFoundInCruiseException;
import fr.ifremer.tutti.service.genericformat.csv.RowWithCruiseContextSupport;
import fr.ifremer.tutti.service.genericformat.csv.RowWithOperationContextSupport;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.nuiton.csv.ImportRow;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;

public class GenericFormatImportValidationHelper
implements Closeable {
    private final ValidationService validationService;
    private final TuttiValidationDataContextSupport originalValidationDataContextSupport;
    private final GenericFormatImportValidationDataContext validationDataContext;

    public GenericFormatImportValidationHelper(GenericFormatContextSupport importContext, ValidationService validationService) {
        this.validationService = validationService;
        this.validationDataContext = new GenericFormatImportValidationDataContext(importContext);
        this.originalValidationDataContextSupport = TuttiValidationDataContextSupport.setValidationContext(this.validationDataContext, true);
    }

    public static String getMessage(String prefix, Set<String> messages) {
        StringBuilder builder = new StringBuilder(prefix);
        builder.append("<ul>");
        for (String message : messages) {
            builder.append("<li>").append(message).append("</li>");
        }
        builder.append("</ul>");
        return builder.toString();
    }

    public Set<String> getMessages(NuitonValidatorResult validatorResult, NuitonValidatorScope scope) {
        LinkedHashSet<String> result = null;
        if (validatorResult.hasMessagesForScope(scope)) {
            result = new LinkedHashSet<String>();
            List messagesForScope = validatorResult.getMessagesForScope(scope);
            for (String message : messagesForScope) {
                String i18nError = this.getI18nError(message);
                result.add(i18nError);
            }
        }
        return result;
    }

    protected String getI18nError(String error) {
        String text;
        if (!error.contains("##")) {
            text = I18n.t((String)error, (Object[])new Object[0]);
        } else {
            StringTokenizer stk = new StringTokenizer(error, "##");
            String errorName = stk.nextToken();
            ArrayList<String> args = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                args.add(stk.nextToken());
            }
            text = I18n.t((String)errorName, (Object[])args.toArray());
        }
        return text;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.validationService);
        TuttiValidationDataContextSupport.setValidationContext(this.originalValidationDataContextSupport, true);
    }

    public NuitonValidatorResult validateCruise(Cruise cruise) {
        return this.validationService.validateEditCruise(cruise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NuitonValidatorResult validateFishingOperation(FishingOperation fishingOperation) {
        Cruise previousCruise = this.validationDataContext.getCruise();
        try {
            Cruise cruise = fishingOperation.getCruise();
            this.validationDataContext.setCruise(cruise);
            this.validationDataContext.setFishingOperation(fishingOperation);
            NuitonValidatorResult nuitonValidatorResult = this.validationService.validateEditFishingOperation(fishingOperation);
            return nuitonValidatorResult;
        }
        finally {
            this.validationDataContext.setCruise(previousCruise);
        }
    }

    public <R extends RowWithCruiseContextSupport> GenericFormatImportCruiseContext getCruise(CsvComsumer<R, ?> consumer, ImportRow<R> row, GenericFormatContextSupport importContext) {
        GenericFormatImportCruiseContext cruiseContext = null;
        if (row.isValid()) {
            boolean cruiseSkipped;
            RowWithCruiseContextSupport bean = (RowWithCruiseContextSupport)row.getBean();
            boolean bl = cruiseSkipped = importContext instanceof GenericFormatImportContext && importContext.isCruiseSkipped(bean);
            if (!cruiseSkipped) {
                cruiseContext = importContext.getCruiseContext(bean);
                if (cruiseContext == null) {
                    consumer.addCheckError(row, new CruiseNotFoundException(bean.getCruise()));
                } else {
                    Cruise cruise = cruiseContext.getCruise();
                    bean.setCruise(cruise);
                    if (bean instanceof RowWithOperationContextSupport) {
                        ((RowWithOperationContextSupport)bean).getFishingOperation().setCruise(cruise);
                    }
                }
            }
        }
        return cruiseContext;
    }

    public <R extends RowWithOperationContextSupport> GenericFormatImportOperationContext getFishingOperationContext(CsvComsumer<R, ?> consumer, ImportRow<R> row, GenericFormatContextSupport importContext) {
        GenericFormatImportOperationContext fishingOperationContext = null;
        GenericFormatImportCruiseContext cruiseContext = this.getCruise(consumer, row, importContext);
        if (cruiseContext != null) {
            boolean fishingOperationSkipped;
            RowWithOperationContextSupport bean = (RowWithOperationContextSupport)row.getBean();
            boolean bl = fishingOperationSkipped = importContext instanceof GenericFormatImportContext && cruiseContext.isFishingOperationSkipped(bean);
            if (!fishingOperationSkipped) {
                fishingOperationContext = cruiseContext.getFishingOperationContext(bean);
                if (fishingOperationContext == null) {
                    consumer.addCheckError(row, new FishingOperationNotFoundInCruiseException(bean.getFishingOperation()));
                } else {
                    bean.setFishingOperation(fishingOperationContext.getFishingOperation());
                }
            }
        }
        return fishingOperationContext;
    }

    public <R extends RowWithCruiseContextSupport> Gear getGear(CsvComsumer<R, ?> consumer, GenericFormatContextSupport importContext, ImportRow<R> row, Gear gear, short rankOrder) {
        Gear cruiseGear = null;
        Cruise cruise = ((RowWithCruiseContextSupport)row.getBean()).getCruise();
        GenericFormatImportCruiseContext cruiseContext = importContext.getCruiseContext(cruise);
        if (cruiseContext != null && (cruiseGear = cruiseContext.getGear(gear, rankOrder)) == null) {
            consumer.addCheckError(row, new GearNotFoundInCruiseException(cruise, gear, rankOrder));
        }
        return cruiseGear;
    }
}

