/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.meta;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.synchro.meta.SynchroJoinMetadata;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;

public class SynchroColumnMetadata {
    protected final ColumnMetadata delegate;
    protected final String tableName;
    protected final int columnSize;
    protected SynchroJoinMetadata parentJoin = null;

    public SynchroColumnMetadata(String tableName, ColumnMetadata delegate, Dialect dialect) {
        Preconditions.checkNotNull((Object)delegate);
        this.delegate = delegate;
        this.tableName = tableName;
        this.columnSize = this.initColumnSize(dialect, delegate);
    }

    public SynchroColumnMetadata(SynchroColumnMetadata beanToCopy) {
        Preconditions.checkNotNull((Object)beanToCopy);
        this.delegate = beanToCopy.delegate;
        this.tableName = beanToCopy.tableName;
        this.parentJoin = beanToCopy.parentJoin;
        this.columnSize = beanToCopy.columnSize;
    }

    public String getTableName() {
        return this.tableName;
    }

    public SynchroJoinMetadata getParentJoin() {
        return this.parentJoin;
    }

    public void setParentJoin(SynchroJoinMetadata parentJoin) {
        this.parentJoin = parentJoin;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getTypeName() {
        return this.delegate.getTypeName();
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public int getDecimalDigits() {
        return this.delegate.getDecimalDigits();
    }

    public String getNullable() {
        return this.delegate.getNullable();
    }

    public boolean isNullable() {
        return "YES".equalsIgnoreCase(this.getNullable());
    }

    public String toString() {
        return this.delegate.toString();
    }

    public int getTypeCode() {
        return this.delegate.getTypeCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColumnMetadata) {
            return this.delegate.equals(obj);
        }
        return super.equals(obj);
    }

    public String getSqlTypeName() {
        int size = this.getColumnSize();
        String typeName = this.getTypeName();
        if (size == 0) {
            return typeName;
        }
        StringBuilder sqlTypeName = new StringBuilder();
        sqlTypeName.append(typeName);
        sqlTypeName.append("(").append(size);
        int decimals = this.getDecimalDigits();
        if (decimals > 0) {
            sqlTypeName.append(",").append(decimals);
        }
        sqlTypeName.append(")");
        return sqlTypeName.toString();
    }

    private int initColumnSize(Dialect dialect, ColumnMetadata delegate) {
        if (dialect instanceof HSQLDialect) {
            if (delegate.getTypeCode() == 4) {
                return 0;
            }
            if (delegate.getTypeCode() == 8) {
                return 0;
            }
            if (delegate.getTypeCode() == -5) {
                return 0;
            }
            if (delegate.getTypeCode() == 5) {
                return 0;
            }
        }
        return delegate.getColumnSize();
    }
}

