/*
 * Decompiled with CFR 0.152.
 */
package liquibase.exception;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.util.StringUtils;

public class ValidationErrors {
    protected List<String> errorMessages = new ArrayList<String>();

    public boolean hasErrors() {
        return this.errorMessages.size() > 0;
    }

    public void checkRequiredField(String requiredFieldName, Object value) {
        if (value == null) {
            this.addError(String.valueOf(requiredFieldName) + " is required");
        } else if (value instanceof Collection && ((Collection)value).size() == 0) {
            this.addError(String.valueOf(requiredFieldName) + " is empty");
        } else if (value instanceof Object[] && ((Object[])value).length == 0) {
            this.addError(String.valueOf(requiredFieldName) + " is empty");
        }
    }

    public void checkDisallowedField(String disallowedFieldName, Object value, Database database, Class<? extends Database> ... disallowedDatabases) {
        boolean isDisallowed = false;
        if (disallowedDatabases == null || disallowedDatabases.length == 0) {
            isDisallowed = true;
        } else {
            Class<? extends Database>[] classArray = disallowedDatabases;
            int n = disallowedDatabases.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends Database> databaseClass = classArray[n2];
                if (databaseClass.isAssignableFrom(database.getClass())) {
                    isDisallowed = true;
                }
                ++n2;
            }
        }
        if (isDisallowed && value != null) {
            this.addError(String.valueOf(disallowedFieldName) + " is not allowed on " + database.getShortName());
        }
    }

    public ValidationErrors addError(String message) {
        this.errorMessages.add(message);
        return this;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public ValidationErrors addAll(ValidationErrors validationErrors) {
        if (validationErrors == null) {
            return this;
        }
        this.errorMessages.addAll(validationErrors.getErrorMessages());
        return this;
    }

    public void addAll(ValidationErrors validationErrors, ChangeSet changeSet) {
        for (String message : validationErrors.getErrorMessages()) {
            this.errorMessages.add(String.valueOf(message) + ", " + changeSet);
        }
    }

    public String toString() {
        if (this.getErrorMessages().size() == 0) {
            return "No errors";
        }
        return StringUtils.join(this.getErrorMessages(), "; ");
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public List<String> getRequiredErrorMessages() {
        ArrayList<String> requiredErrorMessages = new ArrayList<String>();
        for (String message : this.errorMessages) {
            if (!message.contains("is required")) continue;
            requiredErrorMessages.add(message);
        }
        return Collections.unmodifiableList(requiredErrorMessages);
    }

    public List<String> getUnsupportedErrorMessages() {
        ArrayList<String> unsupportedErrorMessages = new ArrayList<String>();
        for (String message : this.errorMessages) {
            if (!message.contains(" is not allowed on ")) continue;
            unsupportedErrorMessages.add(message);
        }
        return Collections.unmodifiableList(unsupportedErrorMessages);
    }
}

