/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.producer;

import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.csv.CsvProducer;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.CatchModel;
import fr.ifremer.tutti.service.genericformat.csv.CatchRow;
import fr.ifremer.tutti.service.genericformat.csv.ExportSampleCategory;
import fr.ifremer.tutti.util.Numbers;
import fr.ifremer.tutti.util.Weights;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CsvProducerForCatch
extends CsvProducer<CatchRow, CatchModel> {
    private static final Log log = LogFactory.getLog(CsvProducerForCatch.class);

    public CsvProducerForCatch(Path file, CatchModel model) {
        super(file, model);
    }

    public List<CatchRow> getDataToExport(GenericFormatExportOperationContext operationExportContext, Float speciesCatchRaisingFactor, Float benthosCatchRaisingFactor) {
        ArrayList<CatchRow> rows = new ArrayList<CatchRow>();
        BatchContainer<SpeciesBatch> rootSpeciesBatch = operationExportContext.getRootSpeciesBatch();
        BatchContainer<BenthosBatch> rootBenthosBatch = operationExportContext.getRootBenthosBatch();
        Caracteristic weightMeasuredCaracteristic = operationExportContext.getWeightMeasuredCaracteristic();
        String batchWeightUnit = weightMeasuredCaracteristic.getUnit();
        this.addSpeciesBatches(operationExportContext, rootSpeciesBatch, speciesCatchRaisingFactor, batchWeightUnit, rows);
        this.addBenthosBatches(operationExportContext, rootBenthosBatch, benthosCatchRaisingFactor, batchWeightUnit, rows);
        for (CatchRow row : rows) {
            Float raisingFactor = row.isBenthos() ? benthosCatchRaisingFactor : speciesCatchRaisingFactor;
            float finalRaisingFactor = this.computeFinalRaisingFactor(row, raisingFactor);
            row.setFinalRaisingFactor(Float.valueOf(finalRaisingFactor));
        }
        return rows;
    }

    public List<CatchRow> getBenthosOnlyDataToExport(GenericFormatExportOperationContext operationExportContext, Float benthosCatchRaisingFactor) {
        ArrayList<CatchRow> rows = new ArrayList<CatchRow>();
        BatchContainer<BenthosBatch> rootBenthosBatch = operationExportContext.getRootBenthosBatch();
        Caracteristic weightMeasuredCaracteristic = operationExportContext.getWeightMeasuredCaracteristic();
        String batchWeightUnit = weightMeasuredCaracteristic.getUnit();
        this.addBenthosBatches(operationExportContext, rootBenthosBatch, benthosCatchRaisingFactor, batchWeightUnit, rows);
        for (CatchRow row : rows) {
            float finalRaisingFactor = this.computeFinalRaisingFactor(row, benthosCatchRaisingFactor);
            row.setFinalRaisingFactor(Float.valueOf(finalRaisingFactor));
        }
        return rows;
    }

    public List<CatchRow> getSpeciesOnlyDataToExport(GenericFormatExportOperationContext operationExportContext, Float speciesCatchRaisingFactor) {
        ArrayList<CatchRow> rows = new ArrayList<CatchRow>();
        BatchContainer<SpeciesBatch> rootSpeciesBatch = operationExportContext.getRootSpeciesBatch();
        Caracteristic weightMeasuredCaracteristic = operationExportContext.getWeightMeasuredCaracteristic();
        String batchWeightUnit = weightMeasuredCaracteristic.getUnit();
        this.addSpeciesBatches(operationExportContext, rootSpeciesBatch, speciesCatchRaisingFactor, batchWeightUnit, rows);
        for (CatchRow row : rows) {
            float finalRaisingFactor = this.computeFinalRaisingFactor(row, speciesCatchRaisingFactor);
            row.setFinalRaisingFactor(Float.valueOf(finalRaisingFactor));
        }
        return rows;
    }

    protected void addBenthosBatches(GenericFormatExportOperationContext operationExportContext, BatchContainer<BenthosBatch> rootBenthosBatch, Float benthosCatchRaisingFactor, String batchWeightUnit, List<CatchRow> rows) {
        for (BenthosBatch benthosBatch : rootBenthosBatch.getChildren()) {
            Float batchWeight;
            boolean vracBatch = operationExportContext.isVracBatch((SpeciesAbleBatch)benthosBatch);
            CatchRow row = new CatchRow();
            row.setVrac(vracBatch);
            row.setBenthos(true);
            row.setCruise(operationExportContext.getCruise());
            row.setFishingOperation(operationExportContext.getOperation());
            row.setSpecies(benthosBatch.getSpecies());
            row.setSpeciesToConfirm(benthosBatch.isSpeciesToConfirm());
            row.setBatchWeightUnit(batchWeightUnit);
            float raisingFactor = benthosCatchRaisingFactor.floatValue();
            if (!vracBatch) {
                raisingFactor = 1.0f;
            }
            float totalBatchWeight = (batchWeight = (Float)Numbers.getValueOrComputedValue((Number)benthosBatch.getSampleCategoryWeight(), (Number)benthosBatch.getSampleCategoryComputedWeight())) == null ? 0.0f : raisingFactor * batchWeight.floatValue();
            this.addBenthosBatch(operationExportContext, row, rows, benthosBatch, totalBatchWeight);
        }
    }

    protected void addSpeciesBatches(GenericFormatExportOperationContext operationExportContext, BatchContainer<SpeciesBatch> rootSpeciesBatch, Float speciesCatchRaisingFactor, String batchWeightUnit, List<CatchRow> rows) {
        for (SpeciesBatch speciesBatch : rootSpeciesBatch.getChildren()) {
            Float batchWeight;
            boolean vracBatch = operationExportContext.isVracBatch((SpeciesAbleBatch)speciesBatch);
            CatchRow row = new CatchRow();
            row.setVrac(vracBatch);
            row.setBenthos(false);
            row.setCruise(operationExportContext.getCruise());
            row.setFishingOperation(operationExportContext.getOperation());
            row.setSpecies(speciesBatch.getSpecies());
            row.setSpeciesToConfirm(speciesBatch.isSpeciesToConfirm());
            row.setBatchWeightUnit(batchWeightUnit);
            float raisingFactor = speciesCatchRaisingFactor.floatValue();
            if (!vracBatch) {
                raisingFactor = 1.0f;
            }
            float totalBatchWeight = (batchWeight = (Float)Numbers.getValueOrComputedValue((Number)speciesBatch.getSampleCategoryWeight(), (Number)speciesBatch.getSampleCategoryComputedWeight())) == null ? 0.0f : raisingFactor * batchWeight.floatValue();
            this.addSpeciesBatch(operationExportContext, row, rows, speciesBatch, totalBatchWeight);
        }
    }

    protected void addSpeciesBatch(GenericFormatExportOperationContext operationExportContext, CatchRow currentRow, List<CatchRow> rows, SpeciesBatch speciesBatch, float totalBatchWeight) {
        Integer number = (Integer)Numbers.getValueOrComputedValue((Number)speciesBatch.getNumber(), (Number)speciesBatch.getComputedNumber());
        Boolean numberComputed = Numbers.getValueOrComputedValueComputed((Number)speciesBatch.getNumber(), (Number)speciesBatch.getComputedNumber());
        Integer rankOrder = speciesBatch.getRankOrder();
        this.addBatchSampleCategory(operationExportContext.getSampleCategoryModel(), currentRow, speciesBatch.getIdAsInt(), speciesBatch.getSampleCategoryId(), speciesBatch.getSampleCategoryValue(), speciesBatch.getSampleCategoryWeight(), speciesBatch.getSampleCategoryComputedWeight(), speciesBatch.getWeight(), speciesBatch.getComment(), number, numberComputed, rankOrder);
        if (speciesBatch.isChildBatchsEmpty()) {
            List<SpeciesBatchFrequency> speciesBatchFrequency = operationExportContext.getAllSpeciesBatchFrequency(speciesBatch.getId());
            if (CollectionUtils.isEmpty(speciesBatchFrequency)) {
                CatchRow row = currentRow.copy();
                Float referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)speciesBatch.getWeight(), (Number)speciesBatch.getComputedWeight());
                if (referenceWeight == null) {
                    referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)speciesBatch.getSampleCategoryWeight(), (Number)speciesBatch.getSampleCategoryComputedWeight());
                }
                this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                rows.add(row);
            } else {
                boolean withNoWeightOnFrequencies = speciesBatchFrequency.get(0).getWeight() == null;
                Float referenceWeight = null;
                if (withNoWeightOnFrequencies && (referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)speciesBatch.getWeight(), (Number)speciesBatch.getComputedWeight())) == null) {
                    referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)speciesBatch.getSampleCategoryWeight(), (Number)speciesBatch.getSampleCategoryComputedWeight());
                }
                float frequencyWeights = 0.0f;
                LinkedHashSet<CatchRow> frequencyRows = new LinkedHashSet<CatchRow>();
                for (SpeciesBatchFrequency batchFrequency : speciesBatchFrequency) {
                    CatchRow row = currentRow.copy();
                    row.setFrequency((SpeciesAbleBatchFrequency)batchFrequency);
                    frequencyRows.add(row);
                    rows.add(row);
                    if (!withNoWeightOnFrequencies) {
                        referenceWeight = batchFrequency.getWeight();
                        frequencyWeights += referenceWeight.floatValue();
                    }
                    this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                }
                if (!withNoWeightOnFrequencies) {
                    float computedFrequencyTotalWeight = frequencyWeights;
                    frequencyRows.forEach(catchRow -> {
                        catchRow.getLastSampleCategoryFilled().setSampleComputedWeight(Float.valueOf(computedFrequencyTotalWeight));
                        catchRow.setComputedFrequencyTotalWeight(Float.valueOf(computedFrequencyTotalWeight));
                    });
                }
            }
        } else {
            float sampleComputedWeight = 0.0f;
            for (SpeciesBatch childBatch : speciesBatch.getChildBatchs()) {
                CatchRow childRow = currentRow.copy();
                this.addSpeciesBatch(operationExportContext, childRow, rows, childBatch, totalBatchWeight);
                ExportSampleCategory exportSampleCategory = childRow.getLastSampleCategoryFilled();
                if (exportSampleCategory == null) continue;
                Float categoryWeight = (Float)Numbers.getValueOrComputedValue((Number)exportSampleCategory.getCategoryWeight(), (Number)exportSampleCategory.getComputedWeight());
                if (categoryWeight == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)String.format("Campagne %s - Trait %s : Il existe une cat\u00e9gorie de poids non renseign\u00e9e (lot esp\u00e8ce %s)", operationExportContext.getCruise().getName(), operationExportContext.getOperationLabel(), childBatch.getId()));
                    }
                    categoryWeight = Float.valueOf(0.0f);
                }
                sampleComputedWeight += categoryWeight.floatValue();
            }
            currentRow.getLastSampleCategoryFilled().setSampleComputedWeight(Float.valueOf(sampleComputedWeight));
        }
    }

    protected void addBenthosBatch(GenericFormatExportOperationContext operationExportContext, CatchRow currentRow, List<CatchRow> rows, BenthosBatch benthosBatch, float totalBatchWeight) {
        Integer number = (Integer)Numbers.getValueOrComputedValue((Number)benthosBatch.getNumber(), (Number)benthosBatch.getComputedNumber());
        Boolean numberComputed = Numbers.getValueOrComputedValueComputed((Number)benthosBatch.getNumber(), (Number)benthosBatch.getComputedNumber());
        Integer rankOrder = benthosBatch.getRankOrder();
        this.addBatchSampleCategory(operationExportContext.getSampleCategoryModel(), currentRow, benthosBatch.getIdAsInt(), benthosBatch.getSampleCategoryId(), benthosBatch.getSampleCategoryValue(), benthosBatch.getSampleCategoryWeight(), benthosBatch.getSampleCategoryComputedWeight(), benthosBatch.getWeight(), benthosBatch.getComment(), number, numberComputed, rankOrder);
        if (benthosBatch.isChildBatchsEmpty()) {
            List<BenthosBatchFrequency> benthosBatchFrequency = operationExportContext.getAllBenthosBatchFrequency(benthosBatch.getId());
            if (CollectionUtils.isEmpty(benthosBatchFrequency)) {
                CatchRow row = currentRow.copy();
                Float referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)benthosBatch.getWeight(), (Number)benthosBatch.getComputedWeight());
                if (referenceWeight == null) {
                    referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)benthosBatch.getSampleCategoryWeight(), (Number)benthosBatch.getSampleCategoryComputedWeight());
                }
                this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                rows.add(row);
            } else {
                boolean withNoWeightOnFrequencies;
                Float referenceWeight = null;
                boolean bl = withNoWeightOnFrequencies = benthosBatchFrequency.get(0).getWeight() == null;
                if (withNoWeightOnFrequencies && (referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)benthosBatch.getWeight(), (Number)benthosBatch.getComputedWeight())) == null) {
                    referenceWeight = (Float)Numbers.getValueOrComputedValue((Number)benthosBatch.getSampleCategoryWeight(), (Number)benthosBatch.getSampleCategoryComputedWeight());
                }
                float frequencyWeights = 0.0f;
                LinkedHashSet<CatchRow> frequencyRows = new LinkedHashSet<CatchRow>();
                for (BenthosBatchFrequency batchFrequency : benthosBatchFrequency) {
                    CatchRow row = currentRow.copy();
                    row.setFrequency((SpeciesAbleBatchFrequency)batchFrequency);
                    frequencyRows.add(row);
                    rows.add(row);
                    if (!withNoWeightOnFrequencies) {
                        referenceWeight = batchFrequency.getWeight();
                        frequencyWeights += referenceWeight.floatValue();
                    }
                    this.setRaisingFactor(row, totalBatchWeight, referenceWeight);
                }
                if (!withNoWeightOnFrequencies) {
                    float computedFrequencyTotalWeight = frequencyWeights;
                    frequencyRows.forEach(catchRow -> {
                        catchRow.getLastSampleCategoryFilled().setSampleComputedWeight(Float.valueOf(computedFrequencyTotalWeight));
                        catchRow.setComputedFrequencyTotalWeight(Float.valueOf(computedFrequencyTotalWeight));
                    });
                }
            }
        } else {
            float sampleComputedWeight = 0.0f;
            for (BenthosBatch childBatch : benthosBatch.getChildBatchs()) {
                CatchRow childRow = currentRow.copy();
                this.addBenthosBatch(operationExportContext, childRow, rows, childBatch, totalBatchWeight);
                ExportSampleCategory exportSampleCategory = childRow.getLastSampleCategoryFilled();
                Float categoryWeight = (Float)Numbers.getValueOrComputedValue((Number)exportSampleCategory.getCategoryWeight(), (Number)exportSampleCategory.getComputedWeight());
                if (categoryWeight == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)String.format("Campagne %s - Trait %s : Il existe une cat\u00e9gorie de poids non renseign\u00e9e (lot benthos %s)", operationExportContext.getCruise().getName(), operationExportContext.getOperationLabel(), childBatch.getId()));
                    }
                    categoryWeight = Float.valueOf(0.0f);
                }
                sampleComputedWeight += categoryWeight.floatValue();
            }
            currentRow.getLastSampleCategoryFilled().setSampleComputedWeight(Float.valueOf(sampleComputedWeight));
        }
    }

    protected float computeFinalRaisingFactor(CatchRow row, Float raisingFactor) {
        float finalRaisingFactor = row.isVrac() ? raisingFactor.floatValue() : 1.0f;
        for (ExportSampleCategory exportSampleCategory : row.getSampleCategory()) {
            float currentRate;
            if (exportSampleCategory == null) continue;
            Float totalWeight = exportSampleCategory.getCategoryWeight();
            Float sampleWeight = (Float)Numbers.getValueOrComputedValue((Number)exportSampleCategory.getSampleWeight(), (Number)exportSampleCategory.getSampleComputedWeight());
            if (totalWeight == null || sampleWeight == null || sampleWeight.floatValue() == 0.0f || !Weights.isNotEqualWeight((float)1.0f, (float)(currentRate = totalWeight.floatValue() / sampleWeight.floatValue()))) continue;
            finalRaisingFactor *= currentRate;
        }
        if (row.isFrequencyWithWeight()) {
            Float frequencyWeight = row.getFrequencyWeight();
            Float computedFrequencyTotalWeight = row.getComputedFrequencyTotalWeight();
            float currentRate = computedFrequencyTotalWeight.floatValue() / frequencyWeight.floatValue();
            if (Weights.isNotEqualWeight((float)1.0f, (float)currentRate)) {
                finalRaisingFactor *= currentRate;
            }
        }
        return finalRaisingFactor;
    }

    protected void setRaisingFactor(CatchRow row, float totalBatchWeight, Float referenceWeight) {
        row.setReferenceWeight(referenceWeight);
        row.setRaisingFactor(referenceWeight == null ? 1.0f : totalBatchWeight / referenceWeight.floatValue());
    }

    protected void addBatchSampleCategory(SampleCategoryModel sampleCategoryModel, CatchRow currentRow, Integer batchId, Integer sampleCategoryId, Serializable sampleCategoryValue, Float sampleCategoryWeight, Float sampleCategoryComputedWeight, Float batchWeight, String comment, Integer batchNumber, Boolean batchNumberComputed, Integer batchRankOrder) {
        currentRow.setBatchNumber(batchNumber);
        currentRow.setBatchNumberComputed(batchNumberComputed);
        ExportSampleCategory sampleCategory = new ExportSampleCategory();
        sampleCategory.setBatchId(batchId);
        SampleCategoryModelEntry categoryById = sampleCategoryModel.getCategoryById(sampleCategoryId);
        sampleCategory.setCategoryDef(categoryById);
        sampleCategory.setCategoryValue(sampleCategoryValue);
        sampleCategory.setCategoryWeight(sampleCategoryWeight);
        sampleCategory.setSampleWeight(batchWeight);
        sampleCategory.setComment(comment);
        sampleCategory.setComputedWeight(sampleCategoryComputedWeight);
        sampleCategory.setWeightOrVolType("Poids");
        sampleCategory.setRankOrder(batchRankOrder);
        currentRow.addSampleCategory(sampleCategory);
    }
}

