/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

import java.math.BigDecimal;
import java.sql.Date;
import org.hsqldb.store.ValuePoolHashMap;

public class ValuePool {
    static ValuePoolHashMap intPool;
    static ValuePoolHashMap longPool;
    static ValuePoolHashMap doublePool;
    static ValuePoolHashMap bigdecimalPool;
    static ValuePoolHashMap stringPool;
    static ValuePoolHashMap datePool;
    static final int DEFAULT_VALUE_POOL_SIZE = 10000;
    static final int[] defaultPoolLookupSize;
    static final int POOLS_COUNT;
    static final int defaultSizeFactor = 2;
    static final int defaultMaxStringLength = 16;
    static ValuePoolHashMap[] poolList;
    static int maxStringLength;
    static /* synthetic */ Class class$org$hsqldb$store$ValuePool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPool() {
        int[] nArray = defaultPoolLookupSize;
        int n = 2;
        Class clazz = class$org$hsqldb$store$ValuePool == null ? (class$org$hsqldb$store$ValuePool = ValuePool.class$("org.hsqldb.store.ValuePool")) : class$org$hsqldb$store$ValuePool;
        synchronized (clazz) {
            maxStringLength = 16;
            poolList = new ValuePoolHashMap[POOLS_COUNT];
            for (int i = 0; i < POOLS_COUNT; ++i) {
                int n2 = nArray[i];
                ValuePool.poolList[i] = new ValuePoolHashMap(n2, n2 * n, 2);
            }
            intPool = poolList[0];
            longPool = poolList[1];
            doublePool = poolList[2];
            bigdecimalPool = poolList[3];
            stringPool = poolList[4];
            datePool = poolList[5];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPool(int[] nArray, int n) {
        Class clazz = class$org$hsqldb$store$ValuePool == null ? (class$org$hsqldb$store$ValuePool = ValuePool.class$("org.hsqldb.store.ValuePool")) : class$org$hsqldb$store$ValuePool;
        synchronized (clazz) {
            for (int i = 0; i < POOLS_COUNT; ++i) {
                poolList[i].resetCapacity(nArray[i] * n, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPool() {
        Class clazz = class$org$hsqldb$store$ValuePool == null ? (class$org$hsqldb$store$ValuePool = ValuePool.class$("org.hsqldb.store.ValuePool")) : class$org$hsqldb$store$ValuePool;
        synchronized (clazz) {
            ValuePool.resetPool(defaultPoolLookupSize, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPool() {
        Class clazz = class$org$hsqldb$store$ValuePool == null ? (class$org$hsqldb$store$ValuePool = ValuePool.class$("org.hsqldb.store.ValuePool")) : class$org$hsqldb$store$ValuePool;
        synchronized (clazz) {
            for (int i = 0; i < POOLS_COUNT; ++i) {
                poolList[i].clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getInt(int n) {
        ValuePoolHashMap valuePoolHashMap = intPool;
        synchronized (valuePoolHashMap) {
            return intPool.getOrAddInteger(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getLong(long l) {
        ValuePoolHashMap valuePoolHashMap = longPool;
        synchronized (valuePoolHashMap) {
            return longPool.getOrAddLong(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double getDouble(long l) {
        ValuePoolHashMap valuePoolHashMap = doublePool;
        synchronized (valuePoolHashMap) {
            return doublePool.getOrAddDouble(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String string) {
        if (string == null || string.length() > maxStringLength) {
            return string;
        }
        ValuePoolHashMap valuePoolHashMap = stringPool;
        synchronized (valuePoolHashMap) {
            return stringPool.getOrAddString(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDate(long l) {
        ValuePoolHashMap valuePoolHashMap = datePool;
        synchronized (valuePoolHashMap) {
            return datePool.getOrAddDate(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal getBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return bigDecimal;
        }
        ValuePoolHashMap valuePoolHashMap = bigdecimalPool;
        synchronized (valuePoolHashMap) {
            return (BigDecimal)bigdecimalPool.getOrAddObject(bigDecimal);
        }
    }

    public static Boolean getBoolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        defaultPoolLookupSize = new int[]{10000, 10000, 10000, 10000, 10000, 10000};
        POOLS_COUNT = defaultPoolLookupSize.length;
        ValuePool.initPool();
    }
}

