/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class AnnotatedElementUtils {
    private static final Boolean CONTINUE = null;

    public static Set<String> getMetaAnnotationTypes(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.notNull(annotationType, "annotationType must not be null");
        final LinkedHashSet<String> types = new LinkedHashSet<String>();
        try {
            Annotation annotation = element.getAnnotation(annotationType);
            if (annotation != null) {
                AnnotatedElementUtils.searchWithGetSemantics(annotation.annotationType(), annotationType, null, new SimpleAnnotationProcessor<Object>(){

                    @Override
                    public Object process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
                        types.add(annotation.annotationType().getName());
                        return CONTINUE;
                    }
                }, new HashSet<AnnotatedElement>(), 1);
            }
        }
        catch (Throwable ex) {
            AnnotationUtils.rethrowAnnotationConfigurationException(ex);
            throw new IllegalStateException("Failed to introspect annotations on " + element, ex);
        }
        return !types.isEmpty() ? types : null;
    }

    public static Set<String> getMetaAnnotationTypes(AnnotatedElement element, String annotationName) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.hasLength(annotationName, "annotationName must not be null or empty");
        final LinkedHashSet<String> types = new LinkedHashSet<String>();
        try {
            Annotation annotation = AnnotationUtils.getAnnotation(element, annotationName);
            if (annotation != null) {
                AnnotatedElementUtils.searchWithGetSemantics(annotation.annotationType(), null, annotationName, new SimpleAnnotationProcessor<Object>(){

                    @Override
                    public Object process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
                        types.add(annotation.annotationType().getName());
                        return CONTINUE;
                    }
                }, new HashSet<AnnotatedElement>(), 1);
            }
        }
        catch (Throwable ex) {
            AnnotationUtils.rethrowAnnotationConfigurationException(ex);
            throw new IllegalStateException("Failed to introspect annotations on " + element, ex);
        }
        return !types.isEmpty() ? types : null;
    }

    public static boolean hasMetaAnnotationTypes(AnnotatedElement element, final Class<? extends Annotation> annotationType) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.notNull(annotationType, "annotationType must not be null");
        return Boolean.TRUE.equals(AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, null, new SimpleAnnotationProcessor<Boolean>(){

            @Override
            public Boolean process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
                boolean found = annotation.annotationType() == annotationType;
                return found && metaDepth > 0 ? Boolean.TRUE : CONTINUE;
            }
        }));
    }

    public static boolean hasMetaAnnotationTypes(AnnotatedElement element, final String annotationName) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.hasLength(annotationName, "annotationName must not be null or empty");
        return Boolean.TRUE.equals(AnnotatedElementUtils.searchWithGetSemantics(element, null, annotationName, new SimpleAnnotationProcessor<Boolean>(){

            @Override
            public Boolean process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
                boolean found = annotation.annotationType().getName().equals(annotationName);
                return found && metaDepth > 0 ? Boolean.TRUE : CONTINUE;
            }
        }));
    }

    public static boolean isAnnotated(AnnotatedElement element, final Class<? extends Annotation> annotationType) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.notNull(annotationType, "annotationType must not be null");
        return Boolean.TRUE.equals(AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, null, new SimpleAnnotationProcessor<Boolean>(){

            @Override
            public Boolean process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
                boolean found = annotation.annotationType() == annotationType;
                return found ? Boolean.TRUE : CONTINUE;
            }
        }));
    }

    public static boolean isAnnotated(AnnotatedElement element, final String annotationName) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.hasLength(annotationName, "annotationName must not be null or empty");
        return Boolean.TRUE.equals(AnnotatedElementUtils.searchWithGetSemantics(element, null, annotationName, new SimpleAnnotationProcessor<Boolean>(){

            @Override
            public Boolean process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
                boolean found = annotation.annotationType().getName().equals(annotationName);
                return found ? Boolean.TRUE : CONTINUE;
            }
        }));
    }

    public static <A extends Annotation> A getMergedAnnotation(AnnotatedElement element, Class<A> annotationType) {
        AnnotationAttributes attributes = AnnotatedElementUtils.getMergedAnnotationAttributes(element, annotationType);
        return attributes != null ? (A)AnnotationUtils.synthesizeAnnotation(attributes, annotationType, element) : null;
    }

    public static AnnotationAttributes getMergedAnnotationAttributes(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, "annotationType must not be null");
        AnnotationAttributes attributes = AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, null, new MergedAnnotationAttributesProcessor(annotationType, null, false, false));
        AnnotationUtils.postProcessAnnotationAttributes(element, attributes, false, false);
        return attributes;
    }

    public static AnnotationAttributes getMergedAnnotationAttributes(AnnotatedElement element, String annotationName) {
        return AnnotatedElementUtils.getMergedAnnotationAttributes(element, annotationName, false, false);
    }

    public static AnnotationAttributes getMergedAnnotationAttributes(AnnotatedElement element, String annotationName, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        AnnotationAttributes attributes = AnnotatedElementUtils.searchWithGetSemantics(element, null, annotationName, new MergedAnnotationAttributesProcessor(null, annotationName, classValuesAsString, nestedAnnotationsAsMap));
        AnnotationUtils.postProcessAnnotationAttributes(element, attributes, classValuesAsString, nestedAnnotationsAsMap);
        return attributes;
    }

    public static <A extends Annotation> A findMergedAnnotation(AnnotatedElement element, Class<A> annotationType) {
        Assert.notNull(annotationType, "annotationType must not be null");
        AnnotationAttributes attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(element, annotationType, false, false);
        return attributes != null ? (A)AnnotationUtils.synthesizeAnnotation(attributes, annotationType, element) : null;
    }

    @Deprecated
    public static <A extends Annotation> A findMergedAnnotation(AnnotatedElement element, String annotationName) {
        AnnotationAttributes attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(element, annotationName, false, false);
        return (A)(attributes != null ? AnnotationUtils.synthesizeAnnotation(attributes, attributes.annotationType(), element) : null);
    }

    public static AnnotationAttributes findMergedAnnotationAttributes(AnnotatedElement element, Class<? extends Annotation> annotationType, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        AnnotationAttributes attributes = AnnotatedElementUtils.searchWithFindSemantics(element, annotationType, annotationType.getName(), new MergedAnnotationAttributesProcessor(annotationType, null, classValuesAsString, nestedAnnotationsAsMap));
        AnnotationUtils.postProcessAnnotationAttributes(element, attributes, classValuesAsString, nestedAnnotationsAsMap);
        return attributes;
    }

    public static AnnotationAttributes findMergedAnnotationAttributes(AnnotatedElement element, String annotationName, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        AnnotationAttributes attributes = AnnotatedElementUtils.searchWithFindSemantics(element, null, annotationName, new MergedAnnotationAttributesProcessor(null, annotationName, classValuesAsString, nestedAnnotationsAsMap));
        AnnotationUtils.postProcessAnnotationAttributes(element, attributes, classValuesAsString, nestedAnnotationsAsMap);
        return attributes;
    }

    @Deprecated
    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement element, String annotationName) {
        return AnnotatedElementUtils.getMergedAnnotationAttributes(element, annotationName);
    }

    @Deprecated
    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement element, String annotationName, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        return AnnotatedElementUtils.getMergedAnnotationAttributes(element, annotationName, classValuesAsString, nestedAnnotationsAsMap);
    }

    public static MultiValueMap<String, Object> getAllAnnotationAttributes(AnnotatedElement element, String annotationName) {
        return AnnotatedElementUtils.getAllAnnotationAttributes(element, annotationName, false, false);
    }

    public static MultiValueMap<String, Object> getAllAnnotationAttributes(AnnotatedElement element, final String annotationName, final boolean classValuesAsString, final boolean nestedAnnotationsAsMap) {
        final LinkedMultiValueMap<String, Object> attributesMap = new LinkedMultiValueMap<String, Object>();
        AnnotatedElementUtils.searchWithGetSemantics(element, null, annotationName, new SimpleAnnotationProcessor<Void>(){

            @Override
            public Void process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
                boolean found = annotation.annotationType().getName().equals(annotationName);
                if (found) {
                    AnnotationAttributes annotationAttributes = AnnotationUtils.getAnnotationAttributes(annotation, classValuesAsString, nestedAnnotationsAsMap);
                    for (Map.Entry entry : annotationAttributes.entrySet()) {
                        attributesMap.add(entry.getKey(), entry.getValue());
                    }
                }
                return null;
            }
        });
        return !attributesMap.isEmpty() ? attributesMap : null;
    }

    private static <T> T searchWithGetSemantics(AnnotatedElement element, Class<? extends Annotation> annotationType, String annotationName, Processor<T> processor) {
        try {
            return AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, annotationName, processor, new HashSet<AnnotatedElement>(), 0);
        }
        catch (Throwable ex) {
            AnnotationUtils.rethrowAnnotationConfigurationException(ex);
            throw new IllegalStateException("Failed to introspect annotations on " + element, ex);
        }
    }

    private static <T> T searchWithGetSemantics(AnnotatedElement element, Class<? extends Annotation> annotationType, String annotationName, Processor<T> processor, Set<AnnotatedElement> visited, int metaDepth) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        if (visited.add(element)) {
            try {
                List<Annotation> declaredAnnotations = Arrays.asList(element.getDeclaredAnnotations());
                T result = AnnotatedElementUtils.searchWithGetSemanticsInAnnotations(element, declaredAnnotations, annotationType, annotationName, processor, visited, metaDepth);
                if (result != null) {
                    return result;
                }
                if (element instanceof Class) {
                    ArrayList<Annotation> inheritedAnnotations = new ArrayList<Annotation>();
                    for (Annotation annotation : element.getAnnotations()) {
                        if (declaredAnnotations.contains(annotation)) continue;
                        inheritedAnnotations.add(annotation);
                    }
                    result = AnnotatedElementUtils.searchWithGetSemanticsInAnnotations(element, inheritedAnnotations, annotationType, annotationName, processor, visited, metaDepth);
                    if (result != null) {
                        return result;
                    }
                }
            }
            catch (Exception ex) {
                AnnotationUtils.handleIntrospectionFailure(element, ex);
            }
        }
        return null;
    }

    private static <T> T searchWithGetSemanticsInAnnotations(AnnotatedElement annotatedElement, List<Annotation> annotations, Class<? extends Annotation> annotationType, String annotationName, Processor<T> processor, Set<AnnotatedElement> visited, int metaDepth) {
        T result;
        for (Annotation annotation : annotations) {
            if (AnnotationUtils.isInJavaLangAnnotationPackage(annotation) || !(annotationType == null ? annotation.annotationType().getName().equals(annotationName) : annotation.annotationType() == annotationType) && metaDepth <= 0 || (result = processor.process(annotatedElement, annotation, metaDepth)) == null) continue;
            return result;
        }
        for (Annotation annotation : annotations) {
            if (AnnotationUtils.isInJavaLangAnnotationPackage(annotation) || (result = AnnotatedElementUtils.searchWithGetSemantics(annotation.annotationType(), annotationType, annotationName, processor, visited, metaDepth + 1)) == null) continue;
            processor.postProcess(annotatedElement, annotation, result);
            return result;
        }
        return null;
    }

    private static <T> T searchWithFindSemantics(AnnotatedElement element, Class<? extends Annotation> annotationType, String annotationName, Processor<T> processor) {
        try {
            return AnnotatedElementUtils.searchWithFindSemantics(element, annotationType, annotationName, processor, new HashSet<AnnotatedElement>(), 0);
        }
        catch (Throwable ex) {
            AnnotationUtils.rethrowAnnotationConfigurationException(ex);
            throw new IllegalStateException("Failed to introspect annotations on " + element, ex);
        }
    }

    private static <T> T searchWithFindSemantics(AnnotatedElement element, Class<? extends Annotation> annotationType, String annotationName, Processor<T> processor, Set<AnnotatedElement> visited, int metaDepth) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.hasLength(annotationName, "annotationName must not be null or empty");
        if (visited.add(element)) {
            try {
                T result;
                Annotation[] annotations;
                for (Annotation annotation : annotations = element.getDeclaredAnnotations()) {
                    if (AnnotationUtils.isInJavaLangAnnotationPackage(annotation) || !(annotationType == null ? annotation.annotationType().getName().equals(annotationName) : annotation.annotationType() == annotationType) && metaDepth <= 0 || (result = processor.process(element, annotation, metaDepth)) == null) continue;
                    return result;
                }
                for (Annotation annotation : annotations) {
                    if (AnnotationUtils.isInJavaLangAnnotationPackage(annotation) || (result = AnnotatedElementUtils.searchWithFindSemantics(annotation.annotationType(), annotationType, annotationName, processor, visited, metaDepth + 1)) == null) continue;
                    processor.postProcess(annotation.annotationType(), annotation, result);
                    return result;
                }
                if (element instanceof Method) {
                    Method method = (Method)element;
                    Method resolvedMethod = BridgeMethodResolver.findBridgedMethod(method);
                    T result2 = AnnotatedElementUtils.searchWithFindSemantics(resolvedMethod, annotationType, annotationName, processor, visited, metaDepth);
                    if (result2 != null) {
                        return result2;
                    }
                    Class<?>[] ifcs = method.getDeclaringClass().getInterfaces();
                    result2 = AnnotatedElementUtils.searchOnInterfaces(method, annotationType, annotationName, processor, visited, metaDepth, ifcs);
                    if (result2 != null) {
                        return result2;
                    }
                    Class<?> clazz = method.getDeclaringClass();
                    while ((clazz = clazz.getSuperclass()) != null && Object.class != clazz) {
                        try {
                            Method equivalentMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                            Method resolvedEquivalentMethod = BridgeMethodResolver.findBridgedMethod(equivalentMethod);
                            result2 = AnnotatedElementUtils.searchWithFindSemantics(resolvedEquivalentMethod, annotationType, annotationName, processor, visited, metaDepth);
                            if (result2 != null) {
                                return result2;
                            }
                        }
                        catch (NoSuchMethodException equivalentMethod) {
                            // empty catch block
                        }
                        if ((result2 = AnnotatedElementUtils.searchOnInterfaces(method, annotationType, annotationName, processor, visited, metaDepth, clazz.getInterfaces())) == null) continue;
                        return result2;
                    }
                }
                if (element instanceof Class) {
                    T result3;
                    Class clazz = (Class)element;
                    for (Class<?> ifc : clazz.getInterfaces()) {
                        T result4 = AnnotatedElementUtils.searchWithFindSemantics(ifc, annotationType, annotationName, processor, visited, metaDepth);
                        if (result4 == null) continue;
                        return result4;
                    }
                    Class superclass = clazz.getSuperclass();
                    if (superclass != null && Object.class != superclass && (result3 = AnnotatedElementUtils.searchWithFindSemantics(superclass, annotationType, annotationName, processor, visited, metaDepth)) != null) {
                        return result3;
                    }
                }
            }
            catch (Exception ex) {
                AnnotationUtils.handleIntrospectionFailure(element, ex);
            }
        }
        return null;
    }

    private static <T> T searchOnInterfaces(Method method, Class<? extends Annotation> annotationType, String annotationName, Processor<T> processor, Set<AnnotatedElement> visited, int metaDepth, Class<?>[] ifcs) {
        for (Class<?> iface : ifcs) {
            if (!AnnotationUtils.isInterfaceWithAnnotatedMethods(iface)) continue;
            try {
                Method equivalentMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                T result = AnnotatedElementUtils.searchWithFindSemantics(equivalentMethod, annotationType, annotationName, processor, visited, metaDepth);
                if (result == null) continue;
                return result;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private static class MergedAnnotationAttributesProcessor
    implements Processor<AnnotationAttributes> {
        private final Class<? extends Annotation> annotationType;
        private final String annotationName;
        private final boolean classValuesAsString;
        private final boolean nestedAnnotationsAsMap;

        MergedAnnotationAttributesProcessor(Class<? extends Annotation> annotationType, String annotationName, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
            this.annotationType = annotationType;
            this.annotationName = annotationName;
            this.classValuesAsString = classValuesAsString;
            this.nestedAnnotationsAsMap = nestedAnnotationsAsMap;
        }

        @Override
        public AnnotationAttributes process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
            boolean found = this.annotationType != null ? annotation.annotationType() == this.annotationType : annotation.annotationType().getName().equals(this.annotationName);
            return found ? AnnotationUtils.retrieveAnnotationAttributes(annotatedElement, annotation, this.classValuesAsString, this.nestedAnnotationsAsMap) : null;
        }

        @Override
        public void postProcess(AnnotatedElement element, Annotation annotation, AnnotationAttributes attributes) {
            annotation = AnnotationUtils.synthesizeAnnotation(annotation, element);
            Class<? extends Annotation> targetAnnotationType = attributes.annotationType();
            for (Method attributeMethod : AnnotationUtils.getAttributeMethods(annotation.annotationType())) {
                String attributeName = attributeMethod.getName();
                String attributeOverrideName = AnnotationUtils.getAttributeOverrideName(attributeMethod, targetAnnotationType);
                if (attributeOverrideName != null) {
                    if (!attributes.containsKey(attributeOverrideName)) continue;
                    this.overrideAttribute(element, annotation, attributes, attributeName, attributeOverrideName);
                    continue;
                }
                if ("value".equals(attributeName) || !attributes.containsKey(attributeName)) continue;
                this.overrideAttribute(element, annotation, attributes, attributeName, attributeName);
            }
        }

        private void overrideAttribute(AnnotatedElement element, Annotation annotation, AnnotationAttributes attributes, String sourceAttributeName, String targetAttributeName) {
            Object value = AnnotationUtils.getValue(annotation, sourceAttributeName);
            Object adaptedValue = AnnotationUtils.adaptValue(element, value, this.classValuesAsString, this.nestedAnnotationsAsMap);
            attributes.put(targetAttributeName, adaptedValue);
        }
    }

    private static abstract class SimpleAnnotationProcessor<T>
    implements Processor<T> {
        private SimpleAnnotationProcessor() {
        }

        @Override
        public final void postProcess(AnnotatedElement annotatedElement, Annotation annotation, T result) {
        }
    }

    private static interface Processor<T> {
        public T process(AnnotatedElement var1, Annotation var2, int var3);

        public void postProcess(AnnotatedElement var1, Annotation var2, T var3);
    }
}

