/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.referential;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.referential.AbstractGears;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntities;
import java.util.List;
import java.util.Map;

public class Gears
extends AbstractGears {
    public static final Predicate<Gear> IS_FISHING_GEAR = new Predicate<Gear>(){

        public boolean apply(Gear input) {
            return !input.isScientificGear();
        }
    };
    public static final Predicate<Gear> IS_SCIENTIFIC_GEAR = new Predicate<Gear>(){

        public boolean apply(Gear input) {
            return input.isScientificGear();
        }
    };
    public static final Predicate<Gear> IS_TEMPORARY = new Predicate<Gear>(){

        public boolean apply(Gear input) {
            return Gears.isTemporary(input);
        }
    };
    public static final Function<Gear, String> GET_NAME = new Function<Gear, String>(){

        public String apply(Gear input) {
            return input.getName();
        }
    };

    public static Map<String, Gear> splitByName(List<Gear> gears) {
        return Maps.uniqueIndex(gears, GET_NAME);
    }

    public static boolean isTemporary(Gear gear) {
        Preconditions.checkNotNull((Object)gear);
        Preconditions.checkNotNull((Object)gear.getId());
        return TuttiReferentialEntities.isStatusTemporary(gear) && Gears.isTemporaryId(gear.getIdAsInt());
    }

    public static boolean isTemporaryId(Integer id) {
        Preconditions.checkNotNull((Object)id);
        return id < 0;
    }
}

