package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.FileEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ImportPupitriPopupUI extends JDialog implements TuttiUI<ImportPupitriPopupUIModel, ImportPupitriPopupUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CARROUSEL_FILE_SELECTED_FILE = "carrouselFile.selectedFile";
    public static final String BINDING_IMPORT_MISSING_BATCHES_SELECTED = "importMissingBatches.selected";
    public static final String BINDING_TRUNK_FILE_SELECTED_FILE = "trunkFile.selectedFile";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVWTW8bRRieOLEb56MpcdOmIoBJI5FK1SRFQqoaVJqkjUjkQNQkqKoPMN6dxJPO7g47s81GEYifwE/g48oFiRsnxIEzBy6Iv4AQB66Id2btXa89xrEKkexYM+/zfjzvvM/MN7+jogzR6yckjnEY+Yp5FO+sP3nyfuOEOuohlU7IhApClPyNFFChjibddF0qdLNe0/CVFnxlM/BE4FO/A71WQxNSnXEqm5QqhV7JIxwpV/bT7bVYRGHba5qUzesXf/5R+Nz97MsCQrGA7CahlOogVFbJWA0VmKvQLER6TlY48Y8hjZD5x5DvtF7b5ETK94hHP0afoks1VBIkBGcKLV68ZOPD4GOhUIWBZaj2IsEg0kNGeHCs0N5RiNlRSD0aYhUpxXDEsDyFTLAT+Aoc40DQkCgW+NghymlSiaWgDoP/250e9wIRicNtIUzIkkJFL3ApV+jwvw6xq/1mccoeYf4e8XWs+VwPkiAHpMENjeUUclmBybMtxmmNNDRuVnMetwA7ZlGbzmRBUoRCS5Yg1GVAPdYGj8zPPHzWIWEYRJLyNKjeuZq3ms5Z6cXreYOrSQ93mZQQdCPhSqG5XPabTeo82wjiPHR8acdwtNpdrFnN2045xHco34BmQYNQJWefrGrL1zI+nxPOXKJotrnUsgjRyzm6YOJwNnHZSIzUUTGMuC5nvt47pI9hKxnP+a7x1A7N7t/XKr98/9t3W+2ZnILYc1bTDkmBWRGhPn6K6dAzyUBGivGVXSLW6qgM3QA9MnqzYElsv7UNyUG8lzQcazh+l8gmuChe+vWHH6999PMoKmyhCR4Qd4to+204Us0QWAi4G4t3HpiMpk7H4fsKfEYVuk4chwq1zs1pgI+i4aGkIBvFI8IlkFcG9OljKrWwjcEBhaUrLgtNPmePfH3uU+sYqFuwUJfm3yj/9Fdl/9sHbfpGoJwbfc0zCotPUYn5nPnUiFpLr6wiNikkjdwg0yWbUiHQqolsjlpzftt8r/bwNKJQqUnZcRMoKLy1Gkfa7K5JX/+6h4QAf5MNcy7NUf9XdwWgSzGlp/xGolU51cStPS1thLdI741pF1sxoBSIPc61MmwBEk2ep4rziQ5EY6jwpi2nI0a5i1NrWzpdejcoEzh8U8mxp24iefPnVaPm+Jiqg7av5VtVSG0GMpPt24dpvbh3rpYXrey1kRgw1Jda8N0MuXhLV6rdKYSH8AE4W9GZZA/H/Mx5ToYz9t/oz34OYUvGcgEM34WFji5sdvrr14n7/VjMZTO4G28O6adPR/L326D6x6B+dueuv+tTL/CZo9AdWwq2KxF7KabVu+WLQmHyVBDwAyYODPD2hWMq4A2NtzsGL7V2t5jcttjrntlIst7xg7gq9nC1kOTtBJ5nnlX6Qu+gZQIuIWjUtn6BoVKynZJVsWC7ebHbTH8oIX1O153kAJ6cv8jjL8nR9gjcNPGSKNjRt4eVy9xDZngOX83V2H7j9GNxlLhuSuGcFdpNYj+rbhr5/0TjB62IA4nseuANolLfypycBWCMLr8NOFJtMN+FdO/3eB/R3xMDPerlr/TX13YPVfDwD5QlOW1UDgAA";
    private static final Log log = LogFactory.getLog(ImportPupitriPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected FileEditor carrouselFile;
    protected JLabel carrouselFileLabel;
    protected final ImportPupitriPopupUIHandler handler = createHandler();
    protected JCheckBox importMissingBatches;
    protected ImportPupitriPopupUI importPupitriDialog = this;
    protected Table mainPanel;
    protected ImportPupitriPopupUIModel model;
    protected FileEditor trunkFile;
    protected JLabel trunkFileLabel;
    protected JButton validateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void open() {
        handler.open();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ImportPupitriPopupUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI() {
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__carrouselFile(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setFile(event, ImportPupitriPopupUIModel.PROPERTY_CARROUSEL_FILE);
    }

    public void doActionPerformed__on__trunkFile(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setFile(event, ImportPupitriPopupUIModel.PROPERTY_TRUNK_FILE);
    }

    public void doItemStateChanged__on__importMissingBatches(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, ImportPupitriPopupUIModel.PROPERTY_IMPORT_MISSING_BATCHES);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public FileEditor getCarrouselFile() {
        return carrouselFile;
    }

    public JLabel getCarrouselFileLabel() {
        return carrouselFileLabel;
    }

    public ImportPupitriPopupUIHandler getHandler() {
        return handler;
    }

    public JCheckBox getImportMissingBatches() {
        return importMissingBatches;
    }

    public Table getMainPanel() {
        return mainPanel;
    }

    public ImportPupitriPopupUIModel getModel() {
        return model;
    }

    public FileEditor getTrunkFile() {
        return trunkFile;
    }

    public JLabel getTrunkFileLabel() {
        return trunkFileLabel;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToImportPupitriDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainPanel);
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(trunkFileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(trunkFile, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(carrouselFileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(carrouselFile, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(importMissingBatches, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add($JPanel0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.common.cancel"));
        cancelButton.setToolTipText(t("tutti.common.cancel"));
        cancelButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.ImportPupitriPopupCancelAction.class);
    }

    protected void createCarrouselFile() {
        $objectMap.put("carrouselFile", carrouselFile = new FileEditor());
        
        carrouselFile.setName("carrouselFile");
        carrouselFile.setAcceptAllFileFilterUsed(false);
        carrouselFile.setShowReset(true);
        carrouselFile.setDirectoryEnabled(false);
        carrouselFile.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__carrouselFile"));
    }

    protected void createCarrouselFileLabel() {
        $objectMap.put("carrouselFileLabel", carrouselFileLabel = new JLabel());
        
        carrouselFileLabel.setName("carrouselFileLabel");
        carrouselFileLabel.setText(t("tutti.importPupitri.field.carrouselFile"));
    }

    protected ImportPupitriPopupUIHandler createHandler() {
        return new ImportPupitriPopupUIHandler();
    }

    protected void createImportMissingBatches() {
        $objectMap.put("importMissingBatches", importMissingBatches = new JCheckBox());
        
        importMissingBatches.setName("importMissingBatches");
        importMissingBatches.setText(t("tutti.importPupitri.importMissingBatches"));
        importMissingBatches.setToolTipText(t("tutti.importPupitri.importMissingBatches.tip"));
        importMissingBatches.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__importMissingBatches"));
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new Table());
        
        mainPanel.setName("mainPanel");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ImportPupitriPopupUIModel.class));
    }

    protected void createTrunkFile() {
        $objectMap.put("trunkFile", trunkFile = new FileEditor());
        
        trunkFile.setName("trunkFile");
        trunkFile.setAcceptAllFileFilterUsed(false);
        trunkFile.setShowReset(true);
        trunkFile.setDirectoryEnabled(false);
        trunkFile.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__trunkFile"));
    }

    protected void createTrunkFileLabel() {
        $objectMap.put("trunkFileLabel", trunkFileLabel = new JLabel());
        
        trunkFileLabel.setName("trunkFileLabel");
        trunkFileLabel.setText(t("tutti.importPupitri.field.trunkFile"));
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("tutti.common.validate"));
        validateButton.setToolTipText(t("tutti.common.validate"));
        validateButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.ImportPupitriPopupValidateAction.class);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToImportPupitriDialog();
        addChildrenToMainPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(validateButton);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 13 property setters
        trunkFileLabel.setLabelFor(trunkFile);
        trunkFile.setExtsDescription(t("tutti.importPupitri.trunkFile.extension.description"));
        trunkFile.setExts(t("tutti.importPupitri.trunkFile.extension"));
        carrouselFileLabel.setLabelFor(carrouselFile);
        carrouselFile.setExtsDescription(t("tutti.importPupitri.carrouselFile.extension.description"));
        carrouselFile.setExts(t("tutti.importPupitri.carrouselFile.extension"));
        importMissingBatches.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.importPupitri.importMissingBatches.mnemonic"),'Z'));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.common.cancel.mnemonic"),'Z'));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        validateButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.common.validate.mnemonic"),'Z'));
        validateButton.setIcon(SwingUtil.createActionIcon("add"));
        // late initializer
        importPupitriDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("importPupitriDialog", importPupitriDialog);
        createModel();
        createMainPanel();
        createTrunkFileLabel();
        createTrunkFile();
        createCarrouselFileLabel();
        createCarrouselFile();
        createImportMissingBatches();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancelButton();
        createValidateButton();
        // inline creation of importPupitriDialog
        setName("importPupitriDialog");
        importPupitriDialog.getContentPane().setLayout(new BorderLayout());
        setTitle(t("tutti.importPupitri.title"));
        setModal(true);
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRUNK_FILE_SELECTED_FILE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("trunkFile", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    trunkFile.setSelectedFile( model.getTrunkFile() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("trunkFile", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CARROUSEL_FILE_SELECTED_FILE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("carrouselFile", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    carrouselFile.setSelectedFile( model.getCarrouselFile() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("carrouselFile", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_IMPORT_MISSING_BATCHES_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("importMissingBatches", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    importMissingBatches.setSelected( model.isImportMissingBatches() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("importMissingBatches", this);
                }
            }
        });
    }

}