// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringDao.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.operation;

import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.andromda.spring.PaginationResult;

/**
 * Opération de peche durant laquelle un prélèvement peut etre effectué, au cours d'une sortie en
 * mer (marée observée en mer, marée enquetée au débarquement, sortie lors d'une campagne à la mer,
 * etc.).
 * Il peut également s'agir d'une séquence de peche, lorsque les dates début/fin ne sont pas connus,
 * et si la zone de peche est unique.
 * Les dates/heures et lat/long de début/fin caractérisent le début/fin de la capture réalisée (hors
 * temps d'établissement de l'engin).
 * REMARQUE : les caractéristiques "indicateur jour/nuit" et "Trajectoire rectiligne ou non" sont
 * présent à ce niveau dans Harmonie, mais gérés dans Allegro via les "cracatéristique d'utilisation
 * du navire" (VesselUseFeatures) rattachée à l'opération parente.
 * @see FishingOperation
 */
public interface FishingOperationDao
{
    /**
     * This constant is used as a transformation flag; entities can be converted automatically into value objects
     * or other types, different methods in a class implementing this interface support this feature: look for
     * an <code>int</code> parameter called <code>transform</code>.
     * <p>
     * This specific flag denotes no transformation will occur.
     */
    public static final int TRANSFORM_NONE = 0;


    /**
     * Transforms the given results to a collection of {@link FishingOperation}
     * instances (this is useful when the returned results contains a row of data and you want just entities only).
     *
     * @param results the query results.
     */
    public void toEntities(final Collection<?> results);

    /**
     * Gets an instance of FishingOperation from the persistent store.
     * @param id
     * @return FishingOperation
     */
    public FishingOperation get(Integer id);

    /**
     * <p>
     * Does the same thing as {@link #get(Integer)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined in this class then the result <strong>WILL BE</strong> passed through an operation which can
     * optionally transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform flag to determine transformation type.
     * @param id the identifier of the entity to get.
     * @return either the entity or the object transformed from the entity.
     */
    public Object get(int transform, Integer id);

    /**
     * Loads an instance of FishingOperation from the persistent store.
     * @param id
     * @return FishingOperation
     */
    public FishingOperation load(Integer id);

    /**
     * <p>
     * Does the same thing as {@link #load(Integer)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined in this class then the result <strong>WILL BE</strong> passed through an operation which can
     * optionally transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform flag to determine transformation type.
     * @param id the identifier of the entity to load.
     * @return either the entity or the object transformed from the entity.
     */
    public Object load(int transform, Integer id);

    /**
     * Loads all entities of type {@link FishingOperation}.
     *
     * @return the loaded entities.
     */
    public Collection<FishingOperation> loadAll();

    /**
     * <p>
     * Does the same thing as {@link #loadAll()} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform the flag indicating what transformation to use.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int transform);

    /**
     * <p>
     * Does the same thing as {@link #loadAll()} with an
     * additional two arguments called <code>pageNumber</code> and <code>pageSize</code>. The <code>pageNumber</code>
     * argument allows you to specify the page number when you are paging the results and the pageSize allows you to specify the size of the
     * page retrieved.
     * </p>
     *
     * @param pageNumber the page number to retrieve when paging results.
     * @param pageSize the size of the page to retrieve when paging results.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int pageNumber, final int pageSize);

    /**
     * <p>
     * Does the same thing as {@link #loadAll(int)} with an
     * additional two arguments called <code>pageNumber</code> and <code>pageSize</code>. The <code>pageNumber</code>
     * argument allows you to specify the page number when you are paging the results and the pageSize allows you to specify the size of the
     * page retrieved.
     * </p>
     *
     * @param transform the flag indicating what transformation to use.
     * @param pageNumber the page number to retrieve when paging results.
     * @param pageSize the size of the page to retrieve when paging results.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int transform, final int pageNumber, final int pageSize);

    /**
     * Creates an instance of FishingOperation and adds it to the persistent store.
     * @param fishingOperation
     * @return FishingOperation
     */
    public FishingOperation create(FishingOperation fishingOperation);

    /**
     * <p>
     * Does the same thing as {@link #create(FishingOperation)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param fishingOperation
     * @return Object
     */
    public Object create(int transform, FishingOperation fishingOperation);

    /**
     * Creates a new instance of FishingOperation and adds
     * from the passed in <code>entities</code> collection
     *
     * @param entities the collection of FishingOperation
     * instances to create.
     *
     * @return the created instances.
     */
    public Collection<FishingOperation> create(Collection<FishingOperation> entities);

    /**
     * <p>
     * Does the same thing as {@link #create(FishingOperation)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entities (into value objects for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param entities
     * @return Collection
     */
    public Collection<?> create(int transform, Collection<FishingOperation> entities);

    /**
     * <p>
     * Creates a new <code>FishingOperation</code>
     * instance from <strong>all</strong> attributes and adds it to
     * the persistent store.
     * </p>
     * @param fishingStartDateTime Date/heure au début du prélèvement.
Par exemple, pour le cas d'une opération avec un chalut, il s'agit la date/heure à l'établissement
du chalut (le temps de descente n'est pas pris en compte).
     * @param fishingEndDateTime Date/heure à la fin du prélèvement.
Par exemple, pour le cas d'une opération avec un chalut, le temps de remontée n'est pas
comptabilisé.
     * @param hasCatch Une capture a t elle été prélevée ?
Si non, il s'agit d'une opération de peche infructueuse.
A priori, si une capture avec quantification différente de 0 est saisie, ou bien si des produits
sont rattachés à l'opération, alors hasCapture=true (HAS_CAPTURE=1).
Si on ne sait pas si une capture a été réalisée ou non, le champ est laissé vide.
Champ utile pour les marées observées au débarquement, pour lesquelles on ne peut pas saisir
systématiquement de lot capture ou bien des produits.
     * @param name @deprecated - NE PLUS UTILISER
Libellé de l'opération.
REMARQUE : attribut absent des IHM. Présent pour les données historiques. Sans doute à supprimer
dans l'avenir.
     * @param rankOrderOnPeriod Rang (de présentation) de l'opération, sur la période date début/fin.
ATTENTION : Lorsque plusieurs opérations sont présentes sur la meme période, cela permet de les
dissocier.
C'est par exemple le cas des séquences de peches (opérations agrégées en Jour/Métier/Secteur) :
plusieurs opérations peuvent etre sur le meme jour (avec des engin/secteur différents), il faut donc
leur attribuer un rang, pour les distinguer. Ce rang peut etre celui de la déclaration du pecheur
(ordre de saisie), ou bien un ordre quelconque.
Dans Allegro, ce rang sera utilisé pour ordonner ces opérations entre elles, dans les listes qui les
représentent. S'il est absent, seule la date de début est utilisée pour cela.
     * @param startDateTime Date/heure de début de l'opération
     * @param endDateTime Date/heure de fin de l'opération
     * @param isMainOperation <html>
<head>
</head>
<body>
<p>
Indique s'il s'agit d'une op&#233;ration ou d'un groupe d'op&#233;rations
&quot;principal&quot;.
</p>
<p>
Cela est utilis&#233; notamment quand on ne connait que l'activit&#233; principale
(le m&#233;tier) d'un navire. On parle alors de m&#233;trier principal.
<br>    </p>
<p>
</p>
<p>
G&#233;n&#233;ralement, cet atrribut est utilis&#233; pour des groupes d'op&#233;rations
(<i>rankOrderOnPerod
is not null</i>), pou identifier sur la mar&#233;e ou une journ&#233;e de peche,
le groupe d'op&#233;ration portant le m&#233;tier principal de la mar&#233;e ou de la
journ&#233;e.
</p>
</body>
</html>
     * @param position Géométrie de l'opération.
Ce champ est optionnel pour etre compatible avec uDIG/geotools.
     * @param comments 
     * @param controlDate 
     * @param validationDate 
     * @param qualificationDate 
     * @param qualificationComments 
     * @param remoteId 
     * @return FishingOperation
     */
    public FishingOperation create(
        Date fishingStartDateTime,
        Date fishingEndDateTime,
        Boolean hasCatch,
        String name,
        Short rankOrderOnPeriod,
        Date startDateTime,
        Date endDateTime,
        Boolean isMainOperation,
        String position,
        String comments,
        Date controlDate,
        Date validationDate,
        Date qualificationDate,
        String qualificationComments,
        Integer remoteId);

    /**
     * <p>
     * Does the same thing as {@link #create(Date, Date, Boolean, String, Short, Date, Date, Boolean, String, String, Date, Date, Date, String, Integer)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param fishingStartDateTime Date/heure au début du prélèvement.
Par exemple, pour le cas d'une opération avec un chalut, il s'agit la date/heure à l'établissement
du chalut (le temps de descente n'est pas pris en compte).
     * @param fishingEndDateTime Date/heure à la fin du prélèvement.
Par exemple, pour le cas d'une opération avec un chalut, le temps de remontée n'est pas
comptabilisé.
     * @param hasCatch Une capture a t elle été prélevée ?
Si non, il s'agit d'une opération de peche infructueuse.
A priori, si une capture avec quantification différente de 0 est saisie, ou bien si des produits
sont rattachés à l'opération, alors hasCapture=true (HAS_CAPTURE=1).
Si on ne sait pas si une capture a été réalisée ou non, le champ est laissé vide.
Champ utile pour les marées observées au débarquement, pour lesquelles on ne peut pas saisir
systématiquement de lot capture ou bien des produits.
     * @param name @deprecated - NE PLUS UTILISER
Libellé de l'opération.
REMARQUE : attribut absent des IHM. Présent pour les données historiques. Sans doute à supprimer
dans l'avenir.
     * @param rankOrderOnPeriod Rang (de présentation) de l'opération, sur la période date début/fin.
ATTENTION : Lorsque plusieurs opérations sont présentes sur la meme période, cela permet de les
dissocier.
C'est par exemple le cas des séquences de peches (opérations agrégées en Jour/Métier/Secteur) :
plusieurs opérations peuvent etre sur le meme jour (avec des engin/secteur différents), il faut donc
leur attribuer un rang, pour les distinguer. Ce rang peut etre celui de la déclaration du pecheur
(ordre de saisie), ou bien un ordre quelconque.
Dans Allegro, ce rang sera utilisé pour ordonner ces opérations entre elles, dans les listes qui les
représentent. S'il est absent, seule la date de début est utilisée pour cela.
     * @param startDateTime Date/heure de début de l'opération
     * @param endDateTime Date/heure de fin de l'opération
     * @param isMainOperation <html>
<head>
</head>
<body>
<p>
Indique s'il s'agit d'une op&#233;ration ou d'un groupe d'op&#233;rations
&quot;principal&quot;.
</p>
<p>
Cela est utilis&#233; notamment quand on ne connait que l'activit&#233; principale
(le m&#233;tier) d'un navire. On parle alors de m&#233;trier principal.
<br>    </p>
<p>
</p>
<p>
G&#233;n&#233;ralement, cet atrribut est utilis&#233; pour des groupes d'op&#233;rations
(<i>rankOrderOnPerod
is not null</i>), pou identifier sur la mar&#233;e ou une journ&#233;e de peche,
le groupe d'op&#233;ration portant le m&#233;tier principal de la mar&#233;e ou de la
journ&#233;e.
</p>
</body>
</html>
     * @param position Géométrie de l'opération.
Ce champ est optionnel pour etre compatible avec uDIG/geotools.
     * @param comments 
     * @param controlDate 
     * @param validationDate 
     * @param qualificationDate 
     * @param qualificationComments 
     * @param remoteId 
     * @return FishingOperation
     */
    public Object create(
        int transform,
        Date fishingStartDateTime,
        Date fishingEndDateTime,
        Boolean hasCatch,
        String name,
        Short rankOrderOnPeriod,
        Date startDateTime,
        Date endDateTime,
        Boolean isMainOperation,
        String position,
        String comments,
        Date controlDate,
        Date validationDate,
        Date qualificationDate,
        String qualificationComments,
        Integer remoteId);

    /**
     * <p>
     * Creates a new <code>FishingOperation</code>
     * instance from only <strong>required</strong> properties (attributes
     * and association ends) and adds it to the persistent store.
     * </p>
     * @param qualityFlag
     * @param vessel
     * @return FishingOperation
     */
    public FishingOperation create(
        QualityFlag qualityFlag,
        Vessel vessel);

    /**
     * <p>
     * Does the same thing as {@link #create()} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform flag to determine transformation type.
     * @param qualityFlag
     * @param vessel
     * @return Object
     */
    public Object create(
        int transform,
        QualityFlag qualityFlag,
        Vessel vessel);

    /**
     * Updates the <code>fishingOperation</code> instance in the persistent store.
     * @param fishingOperation
     */
    public void update(FishingOperation fishingOperation);

    /**
     * Updates all instances in the <code>entities</code> collection in the persistent store.
     * @param entities
     */
    public void update(Collection<FishingOperation> entities);

    /**
     * Removes the instance of FishingOperation from the persistent store.
     * @param fishingOperation
     */
    public void remove(FishingOperation fishingOperation);

    /**
     * Removes the instance of FishingOperation having the given
     * <code>identifier</code> from the persistent store.
     * @param id
     */
    public void remove(Integer id);

    /**
     * Removes all entities in the given <code>entities</code> collection.
     * @param entities
     */
    public void remove(Collection<FishingOperation> entities);


    /**
     * Does the same thing as {@link #search(int, Search)} but with an
     * additional two flags called <code>pageNumber</code> and <code>pageSize</code>. These flags allow you to
     * limit your data to a specified page number and size.
     *
     * @param transform the transformation flag.
     * @param pageNumber the page number in the data to retrieve
     * @param pageSize the size of the page to retrieve.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search wrapped in a {@link PaginationResult} instance.
     */
    public PaginationResult search(final int transform, final int pageNumber, final int pageSize, final Search search);

    /**
     * Does the same thing as {@link #search(Search)} but with an
     * additional two flags called <code>pageNumber</code> and <code>pageSize</code>. These flags allow you to
     * limit your data to a specified page number and size.
     *
     * @param pageNumber the page number in the data to retrieve
     * @param pageSize the size of the page to retrieve.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search wrapped in a {@link PaginationResult} instance.
     */
    public PaginationResult search(final int pageNumber, final int pageSize, final Search search);

    /**
     * Does the same thing as {@link #search(Search)} but with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * finder results will <strong>NOT</strong> be transformed during retrieval.
     * If this flag is any of the other constants defined here
     * then results <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entities (into value objects for example). By default, transformation does
     * not occur.
     *
     * @param transform the transformation flag.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search.
     */
    public Set<?> search(final int transform, final Search search);

    /**
     * Performs a search using the parameters specified in the given <code>search</code> object.
     *
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search.
     */
    public Set<FishingOperation> search(final Search search);

    /**
     * Allows transformation of entities into value objects
     * (or something else for that matter), when the <code>transform</code>
     * flag is set to one of the constants defined in <code>fr.ifremer.adagio.core.dao.data.operation.FishingOperationDao</code>, please note
     * that the {@link #TRANSFORM_NONE} constant denotes no transformation, so the entity itself
     * will be returned.
     *
     * If the integer argument value is unknown {@link #TRANSFORM_NONE} is assumed.
     *
     * @param transform one of the constants declared in {@link fr.ifremer.adagio.core.dao.data.operation.FishingOperationDao}
     * @param entity an entity that was found
     * @return the transformed entity (i.e. new value object, etc)
     * @see #transformEntities(int,Collection)
     */
    public Object transformEntity(final int transform, final FishingOperation entity);

    /**
     * Transforms a collection of entities using the
     * {@link #transformEntity(int,FishingOperation)}
     * method. This method does not instantiate a new collection.
     * <p>
     * This method is to be used internally only.
     *
     * @param transform one of the constants declared in <code>fr.ifremer.adagio.core.dao.data.operation.FishingOperationDao</code>
     * @param entities the collection of entities to transform
     * @see #transformEntity(int,FishingOperation)
     */
    public void transformEntities(final int transform, final Collection<?> entities);

    // spring-dao merge-point
}