/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.consumer;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrders;
import fr.ifremer.tutti.persistence.model.CruiseDataModel;
import fr.ifremer.tutti.service.csv.CsvComsumer;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportValidationHelper;
import fr.ifremer.tutti.service.genericformat.consumer.CruiseAlreadyExistException;
import fr.ifremer.tutti.service.genericformat.consumer.CruiseNotValidException;
import fr.ifremer.tutti.service.genericformat.consumer.MismatchProgramException;
import fr.ifremer.tutti.service.genericformat.csv.SurveyModel;
import fr.ifremer.tutti.service.genericformat.csv.SurveyRow;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.nuiton.csv.ImportRow;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;

public class CsvConsumerForSurvey
extends CsvComsumer<SurveyRow, SurveyModel> {
    public CsvConsumerForSurvey(Path file, char separator, GenericFormatImportEntityParserFactory parserFactory, boolean reportError) {
        super(file, SurveyModel.forImport(separator, parserFactory), reportError);
    }

    public void validateRow(ImportRow<SurveyRow> row, GenericFormatContextSupport importContext) {
        if (row.isValid()) {
            boolean cruiseExist;
            SurveyRow bean = (SurveyRow)row.getBean();
            Cruise cruise = bean.getCruise();
            CruiseDataModel existingCruiseData = importContext.getImportRequest().getExistingCruiseData(cruise);
            boolean bl = cruiseExist = existingCruiseData != null;
            if (importContext.isCruiseAlreadyImported(cruise)) {
                this.addCheckError(row, new CruiseAlreadyExistException(cruise));
            } else {
                Program expectedProgram;
                Program program;
                GenericFormatImportValidationHelper validationHelper;
                NuitonValidatorResult nuitonValidatorResult;
                if (cruiseExist) {
                    cruise.setId(existingCruiseData.getId());
                }
                if ((nuitonValidatorResult = (validationHelper = importContext.getValidationHelper()).validateCruise(cruise)).hasErrorMessagess()) {
                    Set<String> errorMessages = validationHelper.getMessages(nuitonValidatorResult, NuitonValidatorScope.ERROR);
                    this.addCheckError(row, new CruiseNotValidException(cruise, errorMessages));
                }
                if ((program = cruise.getProgram()) != null && !(expectedProgram = importContext.getImportRequest().getProgram()).equals(program)) {
                    this.addCheckError(row, new MismatchProgramException(cruise, expectedProgram));
                }
            }
        }
        this.reportError(row);
    }

    public void prepareRowForPersist(ImportRow<SurveyRow> row) {
        Cruise bean = ((SurveyRow)row.getBean()).getCruise();
        if (!bean.isGearEmpty()) {
            List gear = bean.getGear();
            List gearWithOriginalRankOrders = GearWithOriginalRankOrders.toGearWithOriginalRankOrders((List)gear);
            bean.setGear(gearWithOriginalRankOrders);
        }
    }
}

