/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.sumatra;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TaxonCache;
import fr.ifremer.tutti.persistence.entities.referential.TaxonCaches;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.service.export.ExportBatchEntry;
import fr.ifremer.tutti.service.export.ExportCatchContext;
import fr.ifremer.tutti.service.export.sumatra.CatchRow;
import fr.ifremer.tutti.service.export.sumatra.CatchRowModel;
import fr.ifremer.tutti.service.export.sumatra.SumatraExportResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class CatchesSumatraExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(CatchesSumatraExportService.class);
    protected PersistenceService persistenceService;
    protected WeightComputingService weightComputingService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.weightComputingService = this.getService(WeightComputingService.class);
    }

    public SumatraExportResult exportCruiseForSumatra(File file, String cruiseId, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)cruiseId, (Object)"Cannot export a null cruise");
        Preconditions.checkNotNull((Object)file, (Object)"Cannot export to a null file");
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export cruise " + cruiseId + " to file: " + file));
        }
        progressionModel.increments(I18n.t((String)"tutti.service.sumatra.export.step.load.cruise", (Object[])new Object[]{cruiseId}));
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Preconditions.checkNotNull((Object)cruise, (Object)("Cruise [" + cruiseId + "] not found"));
        progressionModel.increments(I18n.t((String)"tutti.service.sumatra.export.step.load.fishingOperationIds", (Object[])new Object[0]));
        List<String> operations = this.persistenceService.getAllFishingOperationIds(cruiseId);
        if (log.isInfoEnabled()) {
            log.info((Object)(operations.size() + " operations found for cruise: " + cruiseId));
        }
        progressionModel.adaptTotal(operations.size() + 3);
        SumatraExportResult result = new SumatraExportResult();
        this.prepareOperationsAndExport(file, operations, progressionModel, result);
        return result;
    }

    public SumatraExportResult exportFishingOperationForSumatra(File file, String cruiseId, String fishingOperationId, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)file, (Object)"Cannot export to a null file");
        Preconditions.checkNotNull((Object)cruiseId, (Object)"Cannot export a null cruise");
        Preconditions.checkNotNull((Object)fishingOperationId, (Object)"Cannot export a null fishing operation");
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export fishing operation " + fishingOperationId + " to file: " + file));
        }
        progressionModel.increments(I18n.t((String)"tutti.service.sumatra.export.step.load.cruise", (Object[])new Object[]{cruiseId}));
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Preconditions.checkNotNull((Object)cruise, (Object)("Cruise [" + cruiseId + "] not found"));
        ArrayList operations = Lists.newArrayList((Object[])new String[]{fishingOperationId});
        SumatraExportResult result = new SumatraExportResult();
        this.prepareOperationsAndExport(file, operations, progressionModel, result);
        return result;
    }

    protected void prepareOperationsAndExport(File file, List<String> operations, ProgressionModel progressionModel, SumatraExportResult result) {
        ArrayList rows = Lists.newArrayList();
        CatchRowModel csvModel = new CatchRowModel(this.context.getConfig().getCsvSeparator());
        if (operations != null) {
            TuttiProtocol protocol = this.context.getDataContext().getProtocol();
            TaxonCache speciesCache = TaxonCaches.createSpeciesCacheWithoutVernacularCode((TuttiPersistence)this.persistenceService, (TuttiProtocol)protocol);
            TaxonCache benthosCache = TaxonCaches.createBenthosCacheWithoutVernacularCode((TuttiPersistence)this.persistenceService, (TuttiProtocol)protocol);
            for (String operationId : operations) {
                progressionModel.increments(I18n.t((String)"tutti.service.sumatra.export.step.load.fishingOperation", (Object[])new Object[]{operationId}));
                if (!this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
                    if (!log.isWarnEnabled()) break;
                    log.warn((Object)("No catch for operation with id: " + operationId));
                    break;
                }
                this.prepareFishingOperation(speciesCache, benthosCache, csvModel, rows, operationId, result);
            }
        }
        progressionModel.increments(I18n.t((String)"tutti.service.sumatra.export.step.export", (Object[])new Object[]{file}));
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)rows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.sumatra.export.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected void prepareFishingOperation(TaxonCache speciesCache, TaxonCache benthosCache, CatchRowModel csvModel, List<CatchRow> rows, String operationId, SumatraExportResult result) {
        List<ExportBatchEntry> entries;
        ExportCatchContext exportContext = ExportCatchContext.newExportContext(this.persistenceService, this.weightComputingService, operationId, true);
        FishingOperation operation = exportContext.getFishingOperation();
        if (exportContext.withSpeciesBatches()) {
            entries = exportContext.getSpeciesBatchEntry(true);
            Set<String> badSpecies = this.prepareFishingOperationSpecies(speciesCache, entries, csvModel, rows, operation);
            result.setBadSpecies(badSpecies);
        }
        if (exportContext.withBenthosBatches()) {
            entries = exportContext.getBenthosBatchEntry(true);
            Set<String> badBenthos = this.prepareFishingOperationBenthos(benthosCache, entries, csvModel, rows, operation);
            result.setBadBenthos(badBenthos);
        }
    }

    protected Set<String> prepareFishingOperationSpecies(TaxonCache taxonCache, List<ExportBatchEntry> entries, CatchRowModel csvModel, List<CatchRow> rows, FishingOperation operation) {
        HashSet<String> badSpecies = new HashSet<String>();
        for (ExportBatchEntry entry : entries) {
            Species species = entry.getBatch().getSpecies();
            taxonCache.load(species);
            if (StringUtils.isBlank((CharSequence)species.getSurveyCode())) {
                badSpecies.add(species.getName());
            }
            CatchRow row = csvModel.newRow(operation, entry);
            rows.add(row);
        }
        return badSpecies;
    }

    protected Set<String> prepareFishingOperationBenthos(TaxonCache taxonCache, List<ExportBatchEntry> entries, CatchRowModel csvModel, List<CatchRow> rows, FishingOperation operation) {
        HashSet<String> badBenthos = new HashSet<String>();
        for (ExportBatchEntry entry : entries) {
            Species species = entry.getBatch().getSpecies();
            taxonCache.load(species);
            if (StringUtils.isBlank((CharSequence)species.getSurveyCode())) {
                badBenthos.add(species.getName());
            }
            CatchRow row = csvModel.newRow(operation, entry);
            rows.add(row);
        }
        return badBenthos;
    }
}

