/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.hive;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.birt.report.data.oda.jdbc.Statement;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class HiveDriver
extends OdaJdbcDriver {
    private static Logger logger = Logger.getLogger(HiveDriver.class.getName());
    public static final String DATA_SOURCE_ID = "org.eclipse.birt.report.data.oda.hive";

    @Override
    public IConnection getConnection(String connectionClassName) throws OdaException {
        return new HiveConnection();
    }

    private static class HiveConnection
    extends org.eclipse.birt.report.data.oda.jdbc.Connection {
        private String addFileStatement = null;

        private HiveConnection() {
        }

        @Override
        public void open(Properties connProperties) throws OdaException {
            logger.entering(HiveConnection.class.getName(), "open");
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Opening Hive connection. DriverClass=odaDriverClass");
            }
            if (connProperties.getProperty("addListFile") != null) {
                this.addFileStatement = connProperties.getProperty("addListFile");
            }
            super.open(connProperties);
            logger.exiting(HiveConnection.class.getName(), "open");
        }

        @Override
        public IQuery newQuery(String query) throws OdaException {
            return new HiveQuery(this.jdbcConn, this.addFileStatement);
        }
    }

    private static class HiveQuery
    extends Statement {
        private String parentAddFileStatement;
        private boolean added = false;

        public HiveQuery(Connection connection, String addfile) throws OdaException {
            super(connection);
            this.parentAddFileStatement = addfile;
        }

        @Override
        public void prepare(String command) throws OdaException {
            if (!this.added) {
                String addFileStatement = null;
                if (this.getSpecification() != null) {
                    Object temp = this.getSpecification().getProperty("addListFile");
                    String string = addFileStatement = temp == null ? null : temp.toString();
                }
                if (addFileStatement != null || this.parentAddFileStatement != null) {
                    try {
                        java.sql.Statement st = this.conn.createStatement();
                        String addfilestatementstr = null;
                        addfilestatementstr = addFileStatement == null ? this.parentAddFileStatement : addFileStatement;
                        String delimiter = ";";
                        String[] aFiles = addfilestatementstr.split(delimiter);
                        int i = 0;
                        while (i < aFiles.length) {
                            if (aFiles[i] != null && aFiles[i].length() > 0) {
                                st.execute(aFiles[i]);
                            }
                            ++i;
                        }
                        st.close();
                        this.added = true;
                    }
                    catch (SQLException e) {
                        logger.logp(Level.WARNING, HiveQuery.class.getName(), "executeQuery", "Add File Operation Failed", e);
                    }
                }
            }
            super.prepare(command);
        }

        @Override
        public void close() throws OdaException {
            super.close();
            this.added = false;
        }
    }
}

