/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.table;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.beans.Binder;

public abstract class AbstractTuttiTableUIModel<E, R extends AbstractTuttiBeanUIModel, B extends AbstractTuttiTableUIModel<E, R, B>>
extends AbstractTuttiBeanUIModel<E, B> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractTuttiTableUIModel.class);
    public static final String PROPERTY_ROWS = "rows";
    public static final String PROPERTY_ROWS_IN_ERROR = "rowsInError";
    protected List<R> rows;
    protected Set<R> rowsInError;

    protected AbstractTuttiTableUIModel(Class<E> entityType, Binder<E, B> fromBeanBinder, Binder<B, E> toBeanBinder) {
        super(fromBeanBinder, toBeanBinder);
        this.addPropertyChangeListener(PROPERTY_ROWS_IN_ERROR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Set rowsInErorr = (Set)evt.getNewValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("rowsInError changed " + rowsInErorr.size()));
                }
                AbstractTuttiTableUIModel.this.setValid(CollectionUtils.isEmpty((Collection)rowsInErorr));
            }
        });
        this.setRowsInError(Sets.newHashSet());
    }

    public List<R> getRows() {
        return this.rows;
    }

    public void setRows(List<R> rows) {
        if (rows == null) {
            rows = Lists.newArrayList();
        }
        this.rows = rows;
        this.firePropertyChange(PROPERTY_ROWS, null, rows);
        this.rowsInError.clear();
        for (AbstractTuttiBeanUIModel row : rows) {
            if (row.isValid()) continue;
            this.rowsInError.add(row);
        }
        this.setRowsInError(this.rowsInError);
    }

    public int getRowCount() {
        return this.rows == null ? 0 : this.rows.size();
    }

    public Set<R> getRowsInError() {
        return this.rowsInError;
    }

    public void setRowsInError(Set<R> rowsInError) {
        this.rowsInError = rowsInError;
        this.firePropertyChange(PROPERTY_ROWS_IN_ERROR, null, rowsInError);
    }

    public void addRowInError(R row) {
        this.rowsInError.add(row);
        this.firePropertyChange(PROPERTY_ROWS_IN_ERROR, null, this.rowsInError);
    }

    public void removeRowInError(R row) {
        this.rowsInError.remove(row);
        this.firePropertyChange(PROPERTY_ROWS_IN_ERROR, null, this.rowsInError);
    }
}

