/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.actions;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.multipost.MultiPostExportService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.actions.SaveCatchBatchAction;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import javax.swing.JOptionPane;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;

public abstract class ExportMultiPostActionSupport<M extends AbstractBean, UI extends TuttiUI<M, ?>, H extends AbstractTuttiUIHandler<M, UI>>
extends LongActionSupport<M, UI, H> {
    private Boolean doSaveCatches;
    private File file;
    private FishingOperation fishingOperation;

    protected abstract String getFileExtension();

    protected abstract String getFileExtensionDescription();

    protected abstract String getFileChooserTitle();

    protected abstract String getFileChooserButton();

    protected abstract String getSuccessMessage(File var1);

    protected abstract void doExport(MultiPostExportService var1, File var2, FishingOperation var3);

    public ExportMultiPostActionSupport(H handler) {
        super(handler, false);
    }

    protected EditCatchesUI getEditCatchUI() {
        EditCatchesUI catchesUI = (EditCatchesUI)((TuttiUI)this.getUI()).getParentContainer(EditCatchesUI.class);
        return catchesUI;
    }

    public final boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            boolean canSave;
            this.doSaveCatches = false;
            EditCatchesUI catchesUI = this.getEditCatchUI();
            EditCatchesUIModel model = catchesUI.getModel();
            this.fishingOperation = model.getFishingOperation();
            boolean bl = canSave = model.isModify() && model.isValid();
            if (canSave) {
                String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.askToSaveCatch.message", (Object[])new Object[0]), I18n.t((String)"tutti.askToSaveCatchBeforeExport.help", (Object[])new Object[0]));
                int saveResponse = JOptionPane.showOptionDialog(((AbstractTuttiUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"tutti.askToSaveCatch.title", (Object[])new Object[0]), 2, 3, null, new String[]{I18n.t((String)"tutti.option.saveCatch", (Object[])new Object[0]), I18n.t((String)"tutti.option.notSaveCatch", (Object[])new Object[0]), I18n.t((String)"tutti.option.cancelExport", (Object[])new Object[0])}, I18n.t((String)"tutti.option.saveCatch", (Object[])new Object[0]));
                switch (saveResponse) {
                    case 0: {
                        this.doSaveCatches = true;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        doAction = false;
                    }
                }
            }
            if (doAction) {
                String extension = this.getFileExtension();
                this.file = this.saveFile(this.decorate(this.fishingOperation, "fileNameCompatible"), extension, this.getFileChooserTitle(), this.getFileChooserButton(), new String[]{"^.*\\." + extension, this.getFileExtensionDescription()});
                doAction = this.file != null;
            }
        }
        return doAction;
    }

    @Override
    public final void doAction() throws Exception {
        if (this.doSaveCatches.booleanValue()) {
            this.setProgressionModel(new ProgressionModel());
            ProgressionModel progressionModel = this.getProgressionModel();
            progressionModel.setTotal(2);
            progressionModel.increments("Sauvegarde de la capture");
            EditCatchesUI catchesUI = this.getEditCatchUI();
            this.getActionEngine().runInternalAction((AbstractApplicationUIHandler)catchesUI.getHandler(), SaveCatchBatchAction.class);
            progressionModel.increments("Lancement de l'export");
        }
        MultiPostExportService multiPostImportExportService = this.getContext().getMultiPostExportService();
        this.doExport(multiPostImportExportService, this.file, this.fishingOperation);
    }

    public final void releaseAction() {
        this.file = null;
        this.fishingOperation = null;
        this.doSaveCatches = null;
        super.releaseAction();
    }

    public final void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(this.getSuccessMessage(this.file));
    }
}

