/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home.actions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.actions.AbstractChangeScreenAction;
import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class ImportProtocolAction
extends AbstractChangeScreenAction {
    private static final Log log = LogFactory.getLog(ImportProtocolAction.class);
    public static final JAXXContextEntryDef<TuttiProtocol> IMPORT_PROTOCOL_ENTRY = JAXXUtil.newContextEntryDef((String)"importProtocol", TuttiProtocol.class);
    protected TuttiProtocol protocol;

    public ImportProtocolAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.EDIT_PROTOCOL);
    }

    @Override
    public boolean prepareAction() throws Exception {
        IMPORT_PROTOCOL_ENTRY.removeContextValue((JAXXContext)this.getContext().getMainUI());
        boolean doAction = super.prepareAction();
        File file = null;
        if (doAction) {
            file = this.chooseFile(I18n.t((String)"tutti.selectCruise.title.choose.importProtocolFile", (Object[])new Object[0]), I18n.t((String)"tutti.selectCruise.action.importProtocol", (Object[])new Object[0]), new String[]{"^.+\\.tuttiProtocol$", I18n.t((String)"tutti.common.file.protocol", (Object[])new Object[0])});
            boolean bl = doAction = file != null;
        }
        if (doAction) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Will import protocol file: " + file));
            }
            ProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
            this.protocol = service.importProtocol(file);
            this.protocol.setId((String)null);
            this.sendMessage(I18n.t((String)"tutti.importProtocol.action.success", (Object[])new Object[]{this.protocol.getName()}));
        }
        if (doAction) {
            doAction = this.cleanCategories(this.protocol);
        }
        if (doAction) {
            TuttiProtocols.translateReferenceTaxonIds(this.protocol, (Map<Integer, Integer>)this.getContext().getPersistenceService().getAllObsoleteReferentTaxons());
            List allReferentSpecies = this.getContext().getPersistenceService().getAllReferentSpecies();
            doAction = this.cleanSpecies(allReferentSpecies, this.protocol);
            if (doAction) {
                doAction = this.cleanBenthos(allReferentSpecies, this.protocol);
            }
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.protocol);
        IMPORT_PROTOCOL_ENTRY.setContextValue((JAXXContext)this.getContext().getMainUI(), (Object)this.protocol);
        this.protocol = null;
        this.createProgressionModelIfRequired(4);
        this.getContext().setProtocolId(null);
        super.doAction();
    }

    protected boolean cleanCategories(TuttiProtocol protocol) {
        boolean doAction = true;
        SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        HashSet badCategories = Sets.newHashSet();
        TuttiProtocols.checkSampleCategories(sampleCategoryModel, protocol, badCategories);
        if (!badCategories.isEmpty()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("There is some bad categories: " + badCategories));
            }
            String message = TuttiProtocols.getBadCategoriesMessage(badCategories, (Decorator<Caracteristic>)this.getDecorator(Caracteristic.class, null), (TuttiPersistence)this.getContext().getPersistenceService());
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", message, I18n.t((String)"tutti.common.askBeforeImportProtocol.help", (Object[])new Object[0]));
            int response = JOptionPane.showOptionDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n.t((String)"tutti.common.askBeforeEditProtocol.title", (Object[])new Object[0]), 0, 2, UIManager.getIcon("warning"), new Object[]{I18n.t((String)"tutti.option.cleanAndImport", (Object[])new Object[0]), I18n.t((String)"tutti.option.import", (Object[])new Object[0]), I18n.t((String)"tutti.option.cancel", (Object[])new Object[0])}, I18n.t((String)"tutti.option.cancel", (Object[])new Object[0]));
            switch (response) {
                case 0: {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Clean and Import");
                    }
                    TuttiProtocols.removeBadCategories(sampleCategoryModel, protocol);
                    break;
                }
                case 1: {
                    if (!log.isInfoEnabled()) break;
                    log.info((Object)"Import with no cleaning");
                    break;
                }
                default: {
                    doAction = false;
                }
            }
        }
        return doAction;
    }

    protected boolean cleanSpecies(List<Species> allReferentSpecies, TuttiProtocol protocol) {
        boolean withBadSpecies;
        boolean doAction = true;
        Map<Integer, String> missingSpecies = TuttiProtocols.detectMissingSpecies(protocol, allReferentSpecies);
        boolean bl = withBadSpecies = !missingSpecies.isEmpty();
        if (withBadSpecies) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"There is some bad species to remove.");
            }
            String message = TuttiProtocols.getBadSpeciesMessage(missingSpecies);
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", message, I18n.t((String)"tutti.common.askBeforeImportProtocolSpecies.help", (Object[])new Object[0]));
            int response = JOptionPane.showOptionDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n.t((String)"tutti.common.askBeforeEditProtocolSpecies.title", (Object[])new Object[0]), 0, 2, UIManager.getIcon("warning"), new Object[]{I18n.t((String)"tutti.option.cleanAndImport", (Object[])new Object[0]), I18n.t((String)"tutti.option.cancel", (Object[])new Object[0])}, I18n.t((String)"tutti.option.cancel", (Object[])new Object[0]));
            switch (response) {
                case 0: {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Clean species and Import");
                    }
                    TuttiProtocols.removeBadSpecies(protocol, missingSpecies);
                    break;
                }
                default: {
                    doAction = false;
                }
            }
        }
        return doAction;
    }

    protected boolean cleanBenthos(List<Species> allReferentSpecies, TuttiProtocol protocol) {
        boolean withBadBenthos;
        boolean doAction = true;
        Map<Integer, String> missingBenthos = TuttiProtocols.detectMissingBenthos(protocol, allReferentSpecies);
        boolean bl = withBadBenthos = !missingBenthos.isEmpty();
        if (withBadBenthos) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"There is some bad benthos to remove.");
            }
            String message = TuttiProtocols.getBadBenthosMessage(missingBenthos);
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", message, I18n.t((String)"tutti.common.askBeforeImportProtocolBenthos.help", (Object[])new Object[0]));
            int response = JOptionPane.showOptionDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n.t((String)"tutti.common.askBeforeEditProtocolBenthos.title", (Object[])new Object[0]), 0, 2, UIManager.getIcon("warning"), new Object[]{I18n.t((String)"tutti.option.cleanAndImport", (Object[])new Object[0]), I18n.t((String)"tutti.option.cancel", (Object[])new Object[0])}, I18n.t((String)"tutti.option.cancel", (Object[])new Object[0]));
            switch (response) {
                case 0: {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Clean benthos and Import");
                    }
                    TuttiProtocols.removeBadBenthos(protocol, missingBenthos);
                    break;
                }
                default: {
                    doAction = false;
                }
            }
        }
        return doAction;
    }
}

