package fr.ifremer.tutti.ui.swing.content.report;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class ReportUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<ReportUIModel, ReportUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DISPLAY_REPORT_BUTTON_ENABLED = "displayReportButton.enabled";
    public static final String BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM = "fishingOperationComboBox.selectedItem";
    public static final String BINDING_GENERATE_BUTTON_ENABLED = "generateButton.enabled";
    public static final String BINDING_REPORT_COMBO_BOX_SELECTED_ITEM = "reportComboBox.selectedItem";
    public static final String BINDING_SAVE_REPORT_BUTTON_ENABLED = "saveReportButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXQW8bRRSemNiJk5amjRLS0ICTNk3Tlk0DKkIUlTYtpokSEjUGVeQQxrvjeMp6Z9gdp46sIn4CPwHuXJC4cUIcOHPggvoXoEKCK+LN7HrXu5712iVSNtmZ97557/tm3pv97g+U91y0+Bi3WobbdARtEGPr7qNHu9XHxBT3iWe6lAvmIv9nJIdyB2jSCsc9gS4ebEv3tcB97R5rcOYQp8v71jaa8MSJTbw6IUKghbiH6Xlr++H0rRZvuh3UMCgd6jd/Pc99bX31bQ6hFofozkIqpSyvKJPRbZSjlkDnYKVjvGZj5wjCcKlzBPGelmP3bOx5H+EG+QJ9ica2UYFjF8AEWho8ZYWh/FtcoJddwpkrKozvYYfYAq3XXIPWXNIgriGaQlCjSQ3vCQRhmMwRgGn4LsZD9efjTc4VXEGgfINZEuPtoTF2pGMEVKi67HPiCrSajlSRrw/Aa0PZRs7FY2xTC0POAl2LsR9OBBD78vlJZzBCGK0xtyHQXMw5WBVXbcV+MbQev7SluLsBykmRWoGpPyqNZkLbmRr16jC5y4mLBWXONq5KxuKOajDuOJd0BImrbIO1BLqpCZNYVKZZJdgxNuBRprYAR4i94xeHn/T1CBdeiE8Hu6TbtxS36JCwLt/n1RygVkEj5qiJEOqIODIFsqHmBJqOpe6PStvlHuw3Q+xobtqiHrfxib+RIu+r8nEtNJvy8DHJsJk0beaRxHRvFG9FGXI436/G2IfKYUSVIzraIwco7zZhGJQ86C02D2HKLzNziTIjAdXsv7PTv/347Idyp7ZMw9ozWtOu0ghnnrsMtoygcukzfmFpCmqv7WB+6wAVPWJDXVV184ImsP1gGoKD9c5Kd0O6Gw+wVweI/NjvP/08+9mvL6FcGU3YDFtlLO03UVHUXWCB2VaLv39HRXTqyTg8p+A3B6cU5p48JJ4sv6PCbQJbo3K7CjTWVmXkaQvouKChI4ypWvzln+n97+90KBmBEM+nmke05D9FBerY1CGq4Aa1VFtgJ7lHmhaLaqauiiKoo7P6UxbUlHfV83YPDyNwHg59CXadMjObIEOhLdmA7KXLfZWW/K8sV5nYqpCWKFNiW9nIPQzrISFo8oEqF9mQhTqhR3XAy928oUHjXHPm0+BgD5yuMtci7h6m0BSg8eVr2IZwUbEGO0lIHjtjvYsJ9AprCt4UMv67piyJFcbsKoY0MvPIH9ahcUA5bi/5XSVoR3J0SUN9T5/MWmMU6oUti2lZdqGpdrx+PpWCgJACnY8tX5PCBi9RkEuJILutgoiBdgHJVyivKNiFdAdBuS6/7gYwQHKn/E1LrE1BoFNO+0fWOCLCL7JXViGm8aD2nMDG6SR15jBswkHrK7XFlfQElyTQEEz00S46k8NoN99O67yRihc1USW9oiyua7NI2qcouzKIa4rG+svH8GovRGqXE4hJ3ad6aejdAVdTdkDSN7YXhmJRx0bqjSqLELgLnKLr7zg7Dmkwh5pJ/bEqRoaJHRNIaoRW5w4x5zY11WJ+xRJoq519V/YBPeNDVmF7LjmmrOntmy4hAYphymYE3Ez4lpvSERX8AMJNOp8eZMTqxQSr8Vz0W/K1Ph5p1abrqpVF91gP3cu6BTvXyizCdwYgPIYMvAfQfmnrx/l4J4qQ9Qv9Yo14X9bzHialZ77U1we4h8sUcWQfheZ6Nji11FNfPHBStbUyfj0fXpxFXUzy9p0lzObwwuyHl/p+oozK1UNB5tLii8RY1IuhktALoVVZ2SdEWE2KULp8udQZ8lO5Dx/uKeL0fMUML8+KLlKo1o4P2yVSjMOiNHmjRu2ISO2xj5AiOlf0dHYtqic1y+uFqYWL56FHG7xzb3yhvbcbBhLbezrZdN+oA1xSC+ACV1w4k+9Bt8SlKnUsCOh2zxIj8jkxAOK4/MCqnHD1dfNcj/N6Jo4c/rsPwqWBEP7sg3D5fyNcB4T/AO8ouEBMFAAA";
    private static final Log log = LogFactory.getLog(ReportUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton closeButton;
    protected JButton displayReportButton;
    @ValidatorField( validatorId = "validator",  propertyName = "fishingOperation",  editorName = "fishingOperationComboBox")
    protected BeanFilterableComboBox<FishingOperation> fishingOperationComboBox;
    protected JLabel fishingOperationLabel;
    protected Table form;
    protected JButton generateButton;
    protected final ReportUIHandler handler = createHandler();
    protected ReportUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "report",  editorName = "reportComboBox")
    protected BeanFilterableComboBox<File> reportComboBox;
    protected JLabel reportLabel;
    protected ReportUI reportTopPanel = this;
    protected JButton saveReportButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<ReportUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ReportUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public ReportUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReportUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReportUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ReportUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReportUI() {
        $initialize();
    }

    public ReportUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReportUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ReportUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JButton getDisplayReportButton() {
        return displayReportButton;
    }

    public BeanFilterableComboBox<FishingOperation> getFishingOperationComboBox() {
        return fishingOperationComboBox;
    }

    public JLabel getFishingOperationLabel() {
        return fishingOperationLabel;
    }

    public Table getForm() {
        return form;
    }

    public JButton getGenerateButton() {
        return generateButton;
    }

    public ReportUIHandler getHandler() {
        return handler;
    }

    public ReportUIModel getModel() {
        return model;
    }

    public BeanFilterableComboBox<File> getReportComboBox() {
        return reportComboBox;
    }

    public JLabel getReportLabel() {
        return reportLabel;
    }

    public JButton getSaveReportButton() {
        return saveReportButton;
    }

    public SwingValidator<ReportUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add($JPanel0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(fishingOperationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(fishingOperationComboBox), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(reportLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(reportComboBox), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add($JPanel1, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add($JPanel3, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.1, 15, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToReportTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(form);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.report.help"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(t("tutti.report.action.cancel"));
        closeButton.setToolTipText(t("tutti.report.action.cancel.tip"));
        closeButton.putClientProperty("help", "tutti.report.action.cancel.help");
        closeButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.GoToPreviousScreenAction.class);
    }

    protected void createDisplayReportButton() {
        $objectMap.put("displayReportButton", displayReportButton = new JButton());
        
        displayReportButton.setName("displayReportButton");
        displayReportButton.setText(t("tutti.report.action.openReport"));
        displayReportButton.setToolTipText(t("tutti.report.action.openReport.tip"));
        displayReportButton.putClientProperty("help", "tutti.report.action.openReport.help");
        displayReportButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.report.actions.OpenReportAction.class);
    }

    protected void createFishingOperationComboBox() {
        $objectMap.put("fishingOperationComboBox", fishingOperationComboBox = new BeanFilterableComboBox<FishingOperation>(this));
        
        fishingOperationComboBox.setName("fishingOperationComboBox");
        fishingOperationComboBox.setProperty("fishingOperation");
        fishingOperationComboBox.setShowReset(true);
        fishingOperationComboBox.putClientProperty("help", "tutti.report.field.fishingOperation.help");
        fishingOperationComboBox.putClientProperty("validatorLabel", t("tutti.report.field.fishingOperation"));
    }

    protected void createFishingOperationLabel() {
        $objectMap.put("fishingOperationLabel", fishingOperationLabel = new JLabel());
        
        fishingOperationLabel.setName("fishingOperationLabel");
        fishingOperationLabel.setText(t("tutti.report.field.fishingOperation"));
        fishingOperationLabel.setToolTipText(t("tutti.report.field.fishingOperation.tip"));
        fishingOperationLabel.putClientProperty("help", "tutti.report.field.fishingOperation.help");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createGenerateButton() {
        $objectMap.put("generateButton", generateButton = new JButton());
        
        generateButton.setName("generateButton");
        generateButton.setText(t("tutti.report.action.generate"));
        generateButton.setToolTipText(t("tutti.report.action.generate.tip"));
        generateButton.putClientProperty("help", "tutti.report.action.generate.help");
        generateButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.report.actions.GenerateReportAction.class);
    }

    protected ReportUIHandler createHandler() {
        return new ReportUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ReportUIModel.class));
    }

    protected void createReportComboBox() {
        $objectMap.put("reportComboBox", reportComboBox = new BeanFilterableComboBox<File>(this));
        
        reportComboBox.setName("reportComboBox");
        reportComboBox.setProperty("report");
        reportComboBox.setShowReset(true);
        reportComboBox.putClientProperty("help", "tutti.report.field.report.help");
        reportComboBox.putClientProperty("validatorLabel", t("tutti.report.field.report"));
    }

    protected void createReportLabel() {
        $objectMap.put("reportLabel", reportLabel = new JLabel());
        
        reportLabel.setName("reportLabel");
        reportLabel.setText(t("tutti.report.field.report"));
        reportLabel.setToolTipText(t("tutti.report.field.report.tip"));
        reportLabel.putClientProperty("help", "tutti.report.field.report.help");
    }

    protected void createSaveReportButton() {
        $objectMap.put("saveReportButton", saveReportButton = new JButton());
        
        saveReportButton.setName("saveReportButton");
        saveReportButton.setText(t("tutti.report.action.save"));
        saveReportButton.setToolTipText(t("tutti.report.action.save.tip"));
        saveReportButton.putClientProperty("help", "tutti.report.action.save.help");
        saveReportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.report.actions.SaveReportAction.class);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(ReportUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToReportTopPanel();
        addChildrenToValidator();
        addChildrenToForm();
        // inline complete setup of $JPanel1
        $JPanel1.add(generateButton);
        $JPanel1.add($JPanel2);
        $JPanel1.add(closeButton);
        // inline complete setup of $JPanel2
        $JPanel2.add(displayReportButton);
        $JPanel2.add(saveReportButton);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        fishingOperationComboBox.setBeanType(FishingOperation.class);
        reportComboBox.setBeanType(File.class);
        fishingOperationLabel.setLabelFor(fishingOperationComboBox);
        fishingOperationComboBox.setBean(model);
        reportLabel.setLabelFor(reportComboBox);
        reportComboBox.setBean(model);
        generateButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.report.action.generate.mnemonic"),'Z'));
        generateButton.setIcon(SwingUtil.createActionIcon("generate"));
        displayReportButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.report.action.openReport.mnemonic"),'Z'));
        displayReportButton.setIcon(SwingUtil.createActionIcon("open-file"));
        saveReportButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.report.action.save.mnemonic"),'Z'));
        saveReportButton.setIcon(SwingUtil.createActionIcon("save"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.report.action.cancel.mnemonic"),'Z'));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, reportTopPanel, "tutti.report.help");
        registerHelpId(_broker, fishingOperationLabel, "tutti.report.field.fishingOperation.help");
        registerHelpId(_broker, fishingOperationComboBox, "tutti.report.field.fishingOperation.help");
        registerHelpId(_broker, reportLabel, "tutti.report.field.report.help");
        registerHelpId(_broker, reportComboBox, "tutti.report.field.report.help");
        registerHelpId(_broker, generateButton, "tutti.report.action.generate.help");
        registerHelpId(_broker, displayReportButton, "tutti.report.action.openReport.help");
        registerHelpId(_broker, saveReportButton, "tutti.report.action.save.help");
        registerHelpId(_broker, closeButton, "tutti.report.action.cancel.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("reportTopPanel", reportTopPanel);
        createModel();
        createBroker();
        createValidator();
        createForm();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createFishingOperationLabel();
        createFishingOperationComboBox();
        createReportLabel();
        createReportComboBox();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(0, 1));
        SwingUtil.setComponentHeight($JPanel1,50);
        createGenerateButton();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1, 0));
        createDisplayReportButton();
        createSaveReportButton();
        createCloseButton();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        // inline creation of reportTopPanel
        setName("reportTopPanel");
        setLayout(new BorderLayout());
        reportTopPanel.putClientProperty("help", "tutti.report.help");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationComboBox.setSelectedItem(model.getFishingOperation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPORT_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("report", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    reportComboBox.setSelectedItem(model.getReport());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("report", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISPLAY_REPORT_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("reportDone", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    displayReportButton.setEnabled(model.isValid() && model.isReportDone());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("reportDone", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_REPORT_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("reportDone", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveReportButton.setEnabled(model.isValid() && model.isReportDone());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("reportDone", this);
                }
            }
        });
    }

}