package fr.ifremer.tutti.ui.swing.content.referential.replace;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import javax.swing.JButton;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ReplaceTemporaryGearUI extends AbstractReplaceTemporaryUI<Gear, ReplaceTemporaryGearUIModel> implements TuttiUI<ReplaceTemporaryGearUIModel, ReplaceTemporaryGearUIHandler> {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1TS08UQRCuXV1gQRTYQDBisj7isdcLB8UoD7MKWXwAJsQ9SO9Ms9tkdqbtrpEhRuNP8Cfo3YuJN0/Gg2cPXox/wRgPXo3Vs8M+YBBi3ENlU9X11Vc13/fmO+SMhnNbPIqYDn2UTcGW5tbX79a2hIM3hXG0VBhoaP0yWchWYcht5w3ChWrFtpeS9tJC0FSBL/yu7pkKDBrc8YRpCIEIZ3s7HGNKq+3yTKRCvYvaJpWG+urnj+xL98XrLECkiJ1dpXhYV2eT4xXIShdhjCY94SWP+3WioaVfJ77DNrfgcWPu8KZ4DM+hvwJ9imsCQzh/9JVjjLg/UgjjWiiPO2JNUIfmeufB4lpA+cqmZnJTi6bQDENEyULJzDZxYU7gI0EzLTaFnS65xxIUtrIH7Zbg+sGiUvHAPoRcM3CFh3D/f8IvW8zOjDEThNoRFWmQ7lAL5oMIYbrnM7QmCVfSYVhNcJ/NUyhLD4XmNbpR0mcR8x1g5LousBvYVkZ7Xw0nZOdpLVoFCvbDRcnIpVY26dBwpocW6Y51dNcRRqYKOR1SGmGyul+qK1RqiXRyj0gtYFz9PVH48v7bu3K3MsdTn3YZixSjdKCERmlHn2rJMkTplZa5mqlC3giPXBm7biqF2GpSJnI0b9S2M9vObnPTIIhc/9cPHyc2Ph+DbBkGvYC7ZW7fL0IeG5quEHhupG7MxoxObA9QHLHcEPoaQtYbJPzs9OWIFp9KWbw9vZb/9Kuw+nZ2d/kMkTl94PPOAXIPoU/6nvRFbMzEc6lGHFJGhG7Q8Vaa20ApctZQLZbAPe4LL65MxbGYtmYOJXqkhGLLI3u9auXP4idRaDEuxsvZf5fgIGurxCh/mTr2iCvlSYejDPw5x0aEjaf/Zlke95tU67awmWNv9CxthV4vHYH6gDXz2o6im5285nLkxZr0XeJ4fR98xsaRQzFt+ooNV9MRCoTwB7Z8CWq2BgAA";
    private static final Log log = LogFactory.getLog(ReplaceTemporaryGearUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected final ReplaceTemporaryGearUIHandler handler = createHandler();
    protected ReplaceTemporaryGearUIModel model;
    protected JButton replaceButton;
    protected ReplaceTemporaryGearUI replaceTemporaryUITop = this;
    protected BeanFilterableComboBox<Gear> sourceListComboBox;
    protected BeanFilterableComboBox<Gear> targetListComboBox;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ReplaceTemporaryGearUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0, Frame param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryGearUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public ReplaceTemporaryGearUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0, Dialog param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryGearUI() {
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporaryGearUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0, Frame param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryGearUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0, Frame param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryGearUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0, Frame param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryGearUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0, Window param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryGearUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0, Window param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryGearUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0, Window param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryGearUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0, Window param1, String param2, ModalityType param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryGearUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public ReplaceTemporaryGearUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0, Dialog param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryGearUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0, Dialog param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryGearUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0, Dialog param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryGearUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryGearUI(JAXXContext param0, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ReplaceTemporaryGearUIHandler getHandler() {
        return handler;
    }

    public ReplaceTemporaryGearUIModel getModel() {
        return model;
    }

    public JButton getReplaceButton() {
        return replaceButton;
    }

    public BeanFilterableComboBox<Gear> getSourceListComboBox() {
        return sourceListComboBox;
    }

    public BeanFilterableComboBox<Gear> getTargetListComboBox() {
        return targetListComboBox;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToReplaceTemporaryUITop() {
        if (!allComponentsCreated) {
            return;
        }
        add(sourceListComboBox);
        add(targetListComboBox);
        add(replaceButton);
    }

    protected ReplaceTemporaryGearUIHandler createHandler() {
        return new ReplaceTemporaryGearUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ReplaceTemporaryGearUIModel.class));
    }

    protected void createReplaceButton() {
        $objectMap.put("replaceButton", replaceButton = new JButton());
        
        replaceButton.setName("replaceButton");
        replaceButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.replace.actions.ReplaceTemporaryGearAction.class);
    }

    protected void createSourceListComboBox() {
        $objectMap.put("sourceListComboBox", sourceListComboBox = new BeanFilterableComboBox<Gear>());
        
        sourceListComboBox.setName("sourceListComboBox");
    }

    protected void createTargetListComboBox() {
        $objectMap.put("targetListComboBox", targetListComboBox = new BeanFilterableComboBox<Gear>());
        
        targetListComboBox.setName("targetListComboBox");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToReplaceTemporaryUITop();
        
        // apply 2 property setters
        sourceListComboBox.setBeanType(Gear.class);
        targetListComboBox.setBeanType(Gear.class);
        // late initializer
        replaceTemporaryUITop.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("replaceTemporaryUITop", replaceTemporaryUITop);
        createModel();
        createSourceListComboBox();
        createTargetListComboBox();
        createReplaceButton();
        // inline creation of replaceTemporaryUITop
        setName("replaceTemporaryUITop");
        setTitle(t("tutti.replaceTemporaryGear.title"));
        
        $completeSetup();
        handler.afterInit(this);
    }

}