/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.serializer.SnapshotSerializer;
import liquibase.servicelocator.ServiceLocator;

public class SnapshotSerializerFactory {
    private static SnapshotSerializerFactory instance;
    private Map<String, SnapshotSerializer> serializers = new HashMap<String, SnapshotSerializer>();

    public static void reset() {
        instance = new SnapshotSerializerFactory();
    }

    public static SnapshotSerializerFactory getInstance() {
        if (instance == null) {
            instance = new SnapshotSerializerFactory();
        }
        return instance;
    }

    private SnapshotSerializerFactory() {
        try {
            Class<SnapshotSerializer>[] classes;
            Class<SnapshotSerializer>[] classArray = classes = ServiceLocator.getInstance().findClasses(SnapshotSerializer.class);
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<SnapshotSerializer> clazz = classArray[n2];
                this.register(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                ++n2;
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public Map<String, SnapshotSerializer> getSerializers() {
        return this.serializers;
    }

    public SnapshotSerializer getSerializer(String fileNameOrExtension) {
        SnapshotSerializer snapshotSerializer = this.serializers.get(fileNameOrExtension = fileNameOrExtension.replaceAll(".*\\.", ""));
        if (snapshotSerializer == null) {
            throw new RuntimeException("No serializer associated with the filename or extension '" + fileNameOrExtension + "'");
        }
        return snapshotSerializer;
    }

    public void register(SnapshotSerializer snapshotSerializer) {
        String[] stringArray = snapshotSerializer.getValidFileExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            this.serializers.put(extension, snapshotSerializer);
            ++n2;
        }
    }

    public void unregister(SnapshotSerializer snapshotSerializer) {
        ArrayList<Map.Entry<String, SnapshotSerializer>> entrysToRemove = new ArrayList<Map.Entry<String, SnapshotSerializer>>();
        for (Map.Entry<String, SnapshotSerializer> entry : this.serializers.entrySet()) {
            if (!entry.getValue().equals(snapshotSerializer)) continue;
            entrysToRemove.add(entry);
        }
        for (Map.Entry<String, SnapshotSerializer> entry : entrysToRemove) {
            this.serializers.remove(entry.getKey());
        }
    }
}

