/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.table.filter;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.swing.CompoundIcon;
import jaxx.runtime.swing.JAXXWidgetUtil;
import jaxx.runtime.swing.table.filter.TableFilter;

class FilterTableHeaderRenderer
extends JComponent
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private ImageIcon icon;
    private final TableFilter<?> tableFilter;
    private boolean rendererInit = true;
    private int originalHorizontalTextPosition;

    public FilterTableHeaderRenderer(TableFilter<?> tableFilter) {
        this.tableFilter = tableFilter;
    }

    private Icon getFilterIcon() {
        if (this.icon == null) {
            this.icon = JAXXWidgetUtil.createImageIcon((String)"funnel.png");
            this.icon = new ImageIcon(this.icon.getImage().getScaledInstance(12, 12, 4));
        }
        return this.icon;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int modelColumn;
        JLabel label = (JLabel)table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.rendererInit) {
            this.originalHorizontalTextPosition = label.getHorizontalTextPosition();
            this.rendererInit = false;
        }
        if (this.tableFilter.isFiltered(modelColumn = table.convertColumnIndexToModel(column))) {
            Icon originalIcon = label.getIcon();
            if (originalIcon == null) {
                label.setIcon(this.getFilterIcon());
            } else {
                label.setIcon(new CompoundIcon(this.getFilterIcon(), originalIcon));
            }
            label.setHorizontalTextPosition(11);
        } else {
            label.setHorizontalTextPosition(this.originalHorizontalTextPosition);
        }
        return label;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }
}

