/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.gis;

import java.util.regex.Matcher;
import jaxx.runtime.swing.editor.gis.DmsCoordinate;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.converter.NuitonConverter;
import org.nuiton.i18n.I18n;

public class DmsCoordinateConverter
implements NuitonConverter<DmsCoordinate> {
    protected boolean useSign;
    protected boolean forLongitude;

    public void setUseSign(boolean useSign) {
        this.useSign = useSign;
    }

    public void setForLongitude(boolean forLongitude) {
        this.forLongitude = forLongitude;
    }

    public <T> T convert(Class<T> aClass, Object value) {
        if (!this.isEnabled(aClass)) {
            throw new ConversionException(I18n.t((String)"jaxx.error.no.convertor.coordinateDms", (Object[])new Object[]{value}));
        }
        Object result = null;
        if (value == null) {
            if (aClass.equals(String.class)) {
                result = String.format("%s%s\u00b0%s'%s''", this.useSign ? "-" : "", StringUtils.leftPad((String)"", (int)(this.forLongitude ? 3 : 2), (char)' '), StringUtils.leftPad((String)"", (int)2, (char)' '), StringUtils.leftPad((String)"", (int)2, (char)' '));
            }
        } else if (aClass.equals(value.getClass())) {
            result = value;
        } else if (value instanceof String) {
            Matcher matcher = DmsCoordinate.COORDINATE_PATTERN.matcher((String)value);
            if (matcher.matches()) {
                String degresStr = matcher.group(1).replaceAll("\\s", "");
                String minutesStr = matcher.group(2).replaceAll("\\s", "");
                String secondsStr = matcher.group(3).replaceAll("\\s", "");
                Integer degre = degresStr.isEmpty() || "-".equals(degresStr) ? null : Integer.valueOf(Math.abs(Integer.valueOf(degresStr)));
                Integer minutes = minutesStr.isEmpty() ? null : Integer.valueOf(minutesStr);
                Integer seconds = secondsStr.isEmpty() ? null : Integer.valueOf(secondsStr);
                boolean signed = degresStr.contains("-");
                result = DmsCoordinate.valueOf(signed, degre, minutes, seconds);
            }
        } else if (value instanceof DmsCoordinate) {
            DmsCoordinate coordinate = (DmsCoordinate)((Object)value);
            boolean sign = coordinate.isSign();
            String signStr = sign ? "-" : "";
            Integer degree = coordinate.getDegree();
            String degreeStr = degree == null ? "" : degree.toString();
            Integer minute = coordinate.getMinute();
            String minuteStr = minute == null ? "" : minute.toString();
            Integer second = coordinate.getSecond();
            String secondStr = second == null ? "" : second.toString();
            result = String.format("%s%s\u00b0%s'%s''", signStr, StringUtils.leftPad((String)degreeStr, (int)(this.forLongitude ? 3 : 2), (char)' '), StringUtils.leftPad((String)minuteStr, (int)2, (char)' '), StringUtils.leftPad((String)secondStr, (int)2, (char)' '));
        }
        return aClass.cast(result);
    }

    protected boolean isEnabled(Class<?> aClass) {
        return String.class.isAssignableFrom(aClass) || DmsCoordinate.class.isAssignableFrom(aClass);
    }

    public Class<DmsCoordinate> getType() {
        return DmsCoordinate.class;
    }
}

