/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.postscript.truetypefont;

public class Util {
    private static int toInt(byte b) {
        return 0xFF & b;
    }

    private static long toLong(byte b) {
        return 0xFF & b;
    }

    private static int mergeInt(byte ch1, byte ch2, byte ch3, byte ch4) {
        int i1 = Util.toInt(ch1);
        int i2 = Util.toInt(ch2);
        int i3 = Util.toInt(ch3);
        int i4 = Util.toInt(ch4);
        return (i1 << 24) + (i2 << 16) + (i3 << 8) + i4;
    }

    private static long mergeLong(byte ch1, byte ch2, byte ch3, byte ch4) {
        long i1 = Util.toLong(ch1);
        long i2 = Util.toLong(ch2);
        long i3 = Util.toLong(ch3);
        long i4 = Util.toLong(ch4);
        return (i1 << 24) + (i2 << 16) + (i3 << 8) + i4;
    }

    private static byte[] get4Bytes(long data) {
        byte[] result = new byte[]{(byte)(data >> 24), (byte)(data >> 16), (byte)(data >> 8), (byte)data};
        return result;
    }

    private static byte[] get2Bytes(int data) {
        byte[] result = new byte[]{(byte)(data >> 8), (byte)data};
        return result;
    }

    public static String toHexString(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        int length = 0;
        int i = 0;
        while (i < bytes.length) {
            result.append(Util.toHexString(bytes[i]));
            if ((length += 2) > 80) {
                result.append("\n");
                length = 0;
            }
            ++i;
        }
        return result.toString();
    }

    private static String toHexString(byte b) {
        String result = Integer.toHexString(Util.toInt(b));
        if (result.length() == 1) {
            result = "0" + result;
        }
        return result;
    }

    public static void putInt16(byte[] bytes, int index, int data) {
        assert (bytes.length > index + 1);
        byte[] intBytes = Util.get2Bytes(data);
        int i = 0;
        while (i < 2) {
            bytes[index + i] = intBytes[i];
            ++i;
        }
    }

    public static void putInt32(byte[] bytes, int index, long data) {
        assert (bytes.length > index + 3);
        byte[] intBytes = Util.get4Bytes(data);
        int i = 0;
        while (i < 4) {
            bytes[index + i] = intBytes[i];
            ++i;
        }
    }

    public static int getUnsignedShort(byte[] source, int index) {
        assert (source.length >= index + 2);
        return ((0xFF & source[index]) << 8) + (0xFF & source[index + 1]);
    }

    public static int getInt(byte[] source, int index) {
        assert (source.length >= index + 4);
        return Util.mergeInt(source[index], source[index + 1], source[index + 2], source[index + 3]);
    }

    public static int getIntLE(byte[] source, int index) {
        return Util.mergeInt(source[index + 3], source[index + 2], source[index + 1], source[index]);
    }

    public static long getUnsignedInt(byte[] source, int index) {
        assert (source.length >= index + 4);
        return Util.mergeLong(source[index], source[index + 1], source[index + 2], source[index + 3]);
    }

    public static float div(int dividend, int divisor) {
        return (float)dividend / (float)divisor;
    }

    public static String toBase85String(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        int i = 0;
        while (i <= data.length - 4) {
            char[] base85String = Util.toBase85String(Util.getUnsignedInt(data, i));
            buffer.append(base85String);
            if ((count += base85String.length) > 80) {
                buffer.append('\n');
                count = 0;
            }
            i += 4;
        }
        return buffer.toString();
    }

    private static char[] toBase85String(long data) {
        if (data == 0L) {
            return new char[]{'z'};
        }
        char[] result = new char[5];
        long tempData = data;
        int i = 0;
        while (i < 5) {
            long number = tempData % 85L;
            result[i] = Util.getBase85Char(number);
            tempData = (tempData - number) / 85L;
            ++i;
        }
        return result;
    }

    private static char getBase85Char(long number) {
        return (char)(33L + number);
    }

    public static String toHexString(int c) {
        String[] padding = new String[]{"0", "00", "000"};
        String result = Integer.toHexString(c);
        if (result.length() < 4) {
            result = String.valueOf(padding[3 - result.length()]) + result;
        }
        return result;
    }
}

