/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.io.Closeable;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class DisposableBeanAdapter
implements DisposableBean,
Runnable,
Serializable {
    private static final String CLOSE_METHOD_NAME = "close";
    private static final String SHUTDOWN_METHOD_NAME = "shutdown";
    private static final Log logger = LogFactory.getLog(DisposableBeanAdapter.class);
    private static Class<?> closeableInterface;
    private final Object bean;
    private final String beanName;
    private final boolean invokeDisposableBean;
    private final boolean nonPublicAccessAllowed;
    private final AccessControlContext acc;
    private String destroyMethodName;
    private transient Method destroyMethod;
    private List<DestructionAwareBeanPostProcessor> beanPostProcessors;

    public DisposableBeanAdapter(Object bean, String beanName, RootBeanDefinition beanDefinition, List<BeanPostProcessor> postProcessors, AccessControlContext acc) {
        Assert.notNull((Object)bean, (String)"Disposable bean must not be null");
        this.bean = bean;
        this.beanName = beanName;
        this.invokeDisposableBean = this.bean instanceof DisposableBean && !beanDefinition.isExternallyManagedDestroyMethod("destroy");
        this.nonPublicAccessAllowed = beanDefinition.isNonPublicAccessAllowed();
        this.acc = acc;
        String destroyMethodName = this.inferDestroyMethodIfNecessary(bean, beanDefinition);
        if (!(destroyMethodName == null || this.invokeDisposableBean && "destroy".equals(destroyMethodName) || beanDefinition.isExternallyManagedDestroyMethod(destroyMethodName))) {
            this.destroyMethodName = destroyMethodName;
            this.destroyMethod = this.determineDestroyMethod();
            if (this.destroyMethod == null) {
                if (beanDefinition.isEnforceDestroyMethod()) {
                    throw new BeanDefinitionValidationException("Couldn't find a destroy method named '" + destroyMethodName + "' on bean with name '" + beanName + "'");
                }
            } else {
                Class<?>[] paramTypes = this.destroyMethod.getParameterTypes();
                if (paramTypes.length > 1) {
                    throw new BeanDefinitionValidationException("Method '" + destroyMethodName + "' of bean '" + beanName + "' has more than one parameter - not supported as destroy method");
                }
                if (paramTypes.length == 1 && Boolean.TYPE != paramTypes[0]) {
                    throw new BeanDefinitionValidationException("Method '" + destroyMethodName + "' of bean '" + beanName + "' has a non-boolean parameter - not supported as destroy method");
                }
            }
        }
        this.beanPostProcessors = this.filterPostProcessors(postProcessors);
    }

    public DisposableBeanAdapter(Object bean, List<BeanPostProcessor> postProcessors, AccessControlContext acc) {
        Assert.notNull((Object)bean, (String)"Disposable bean must not be null");
        this.bean = bean;
        this.beanName = null;
        this.invokeDisposableBean = this.bean instanceof DisposableBean;
        this.nonPublicAccessAllowed = true;
        this.acc = acc;
        this.beanPostProcessors = this.filterPostProcessors(postProcessors);
    }

    private DisposableBeanAdapter(Object bean, String beanName, boolean invokeDisposableBean, boolean nonPublicAccessAllowed, String destroyMethodName, List<DestructionAwareBeanPostProcessor> postProcessors) {
        this.bean = bean;
        this.beanName = beanName;
        this.invokeDisposableBean = invokeDisposableBean;
        this.nonPublicAccessAllowed = nonPublicAccessAllowed;
        this.acc = null;
        this.destroyMethodName = destroyMethodName;
        this.beanPostProcessors = postProcessors;
    }

    private String inferDestroyMethodIfNecessary(Object bean, RootBeanDefinition beanDefinition) {
        String destroyMethodName = beanDefinition.getDestroyMethodName();
        if ("(inferred)".equals(destroyMethodName) || destroyMethodName == null && closeableInterface.isInstance(bean)) {
            if (!(bean instanceof DisposableBean)) {
                try {
                    return bean.getClass().getMethod(CLOSE_METHOD_NAME, new Class[0]).getName();
                }
                catch (NoSuchMethodException ex) {
                    try {
                        return bean.getClass().getMethod(SHUTDOWN_METHOD_NAME, new Class[0]).getName();
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
        return StringUtils.hasLength((String)destroyMethodName) ? destroyMethodName : null;
    }

    private List<DestructionAwareBeanPostProcessor> filterPostProcessors(List<BeanPostProcessor> postProcessors) {
        ArrayList<DestructionAwareBeanPostProcessor> filteredPostProcessors = null;
        if (!CollectionUtils.isEmpty(postProcessors)) {
            filteredPostProcessors = new ArrayList<DestructionAwareBeanPostProcessor>(postProcessors.size());
            for (BeanPostProcessor postProcessor : postProcessors) {
                if (!(postProcessor instanceof DestructionAwareBeanPostProcessor)) continue;
                filteredPostProcessors.add((DestructionAwareBeanPostProcessor)postProcessor);
            }
        }
        return filteredPostProcessors;
    }

    @Override
    public void run() {
        this.destroy();
    }

    @Override
    public void destroy() {
        Method methodToCall;
        if (!CollectionUtils.isEmpty(this.beanPostProcessors)) {
            for (DestructionAwareBeanPostProcessor processor : this.beanPostProcessors) {
                processor.postProcessBeforeDestruction(this.bean, this.beanName);
            }
        }
        if (this.invokeDisposableBean) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking destroy() on bean with name '" + this.beanName + "'"));
            }
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            ((DisposableBean)DisposableBeanAdapter.this.bean).destroy();
                            return null;
                        }
                    }, this.acc);
                } else {
                    ((DisposableBean)this.bean).destroy();
                }
            }
            catch (Throwable ex) {
                String msg = "Invocation of destroy method failed on bean with name '" + this.beanName + "'";
                if (logger.isDebugEnabled()) {
                    logger.warn((Object)msg, ex);
                }
                logger.warn((Object)(msg + ": " + ex));
            }
        }
        if (this.destroyMethod != null) {
            this.invokeCustomDestroyMethod(this.destroyMethod);
        } else if (this.destroyMethodName != null && (methodToCall = this.determineDestroyMethod()) != null) {
            this.invokeCustomDestroyMethod(methodToCall);
        }
    }

    private Method determineDestroyMethod() {
        try {
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(new PrivilegedAction<Method>(){

                    @Override
                    public Method run() {
                        return DisposableBeanAdapter.this.findDestroyMethod();
                    }
                });
            }
            return this.findDestroyMethod();
        }
        catch (IllegalArgumentException ex) {
            throw new BeanDefinitionValidationException("Couldn't find a unique destroy method on bean with name '" + this.beanName + ": " + ex.getMessage());
        }
    }

    private Method findDestroyMethod() {
        return this.nonPublicAccessAllowed ? BeanUtils.findMethodWithMinimalParameters(this.bean.getClass(), this.destroyMethodName) : BeanUtils.findMethodWithMinimalParameters(this.bean.getClass().getMethods(), this.destroyMethodName);
    }

    private void invokeCustomDestroyMethod(final Method destroyMethod) {
        block10: {
            Class<?>[] paramTypes = destroyMethod.getParameterTypes();
            final Object[] args = new Object[paramTypes.length];
            if (paramTypes.length == 1) {
                args[0] = Boolean.TRUE;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking destroy method '" + this.destroyMethodName + "' on bean with name '" + this.beanName + "'"));
            }
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            ReflectionUtils.makeAccessible((Method)destroyMethod);
                            return null;
                        }
                    });
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                destroyMethod.invoke(DisposableBeanAdapter.this.bean, args);
                                return null;
                            }
                        }, this.acc);
                        break block10;
                    }
                    catch (PrivilegedActionException pax) {
                        throw (InvocationTargetException)pax.getException();
                    }
                }
                ReflectionUtils.makeAccessible((Method)destroyMethod);
                destroyMethod.invoke(this.bean, args);
            }
            catch (InvocationTargetException ex) {
                String msg = "Invocation of destroy method '" + this.destroyMethodName + "' failed on bean with name '" + this.beanName + "'";
                if (logger.isDebugEnabled()) {
                    logger.warn((Object)msg, ex.getTargetException());
                } else {
                    logger.warn((Object)(msg + ": " + ex.getTargetException()));
                }
            }
            catch (Throwable ex) {
                logger.error((Object)("Couldn't invoke destroy method '" + this.destroyMethodName + "' on bean with name '" + this.beanName + "'"), ex);
            }
        }
    }

    protected Object writeReplace() {
        ArrayList<DestructionAwareBeanPostProcessor> serializablePostProcessors = null;
        if (this.beanPostProcessors != null) {
            serializablePostProcessors = new ArrayList<DestructionAwareBeanPostProcessor>();
            for (DestructionAwareBeanPostProcessor postProcessor : this.beanPostProcessors) {
                if (!(postProcessor instanceof Serializable)) continue;
                serializablePostProcessors.add(postProcessor);
            }
        }
        return new DisposableBeanAdapter(this.bean, this.beanName, this.invokeDisposableBean, this.nonPublicAccessAllowed, this.destroyMethodName, serializablePostProcessors);
    }

    public static boolean hasDestroyMethod(Object bean, RootBeanDefinition beanDefinition) {
        if (bean instanceof DisposableBean || closeableInterface.isInstance(bean)) {
            return true;
        }
        String destroyMethodName = beanDefinition.getDestroyMethodName();
        if ("(inferred)".equals(destroyMethodName)) {
            return ClassUtils.hasMethod(bean.getClass(), (String)CLOSE_METHOD_NAME, (Class[])new Class[0]);
        }
        return StringUtils.hasLength((String)destroyMethodName);
    }

    static {
        try {
            closeableInterface = ClassUtils.forName((String)"java.lang.AutoCloseable", (ClassLoader)DisposableBeanAdapter.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            closeableInterface = Closeable.class;
        }
    }
}

