/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.util.Collection;
import java.util.HashSet;
import liquibase.database.Database;
import liquibase.util.StringUtils;

public class DatabaseList {
    public static boolean definitionMatches(String definition, Database database, boolean returnValueIfEmpty) {
        return DatabaseList.definitionMatches(StringUtils.splitAndTrim(StringUtils.trimToNull(definition), ","), database, returnValueIfEmpty);
    }

    public static boolean definitionMatches(Collection<String> definition, Database database, boolean returnValueIfEmptyList) {
        if (definition == null || definition.isEmpty()) {
            return returnValueIfEmptyList;
        }
        if (definition.contains("all")) {
            return true;
        }
        if (definition.contains("none")) {
            return false;
        }
        if (definition.contains("!" + database.getShortName())) {
            return false;
        }
        HashSet<String> dbmsSupported = new HashSet<String>();
        for (String dbms : definition) {
            if (dbms.startsWith("!")) continue;
            dbmsSupported.add(dbms);
        }
        return dbmsSupported.isEmpty() || dbmsSupported.contains(database.getShortName());
    }
}

