/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import java.util.Stack;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter;
import org.eclipse.birt.report.engine.internal.content.wrap.CellContentWrapper;

class TableLayout {
    Stack<int[]> layoutStack = new Stack();
    Stack<Integer> columnCountStack = new Stack();
    int columnCount;
    int[] cells = null;
    ICellContent currentCell = null;
    HTMLReportEmitter emitter = null;
    ITableContent table = null;

    TableLayout(HTMLReportEmitter emitter) {
        this.emitter = emitter;
    }

    protected void startTable(ITableContent tableContent) {
        int columnCount = tableContent.getColumnCount();
        this.cells = new int[columnCount];
        this.columnCount = columnCount;
        this.layoutStack.push(this.cells);
        this.columnCountStack.push(columnCount);
        this.table = tableContent;
    }

    protected void endTable(ITableContent tableContent) {
        this.layoutStack.pop();
        this.columnCountStack.pop();
        if (!this.layoutStack.isEmpty()) {
            this.cells = this.layoutStack.peek();
        }
        if (!this.columnCountStack.isEmpty()) {
            this.columnCount = this.columnCountStack.peek();
        }
    }

    protected void startRow() {
    }

    protected void endRow() {
        this.addEmptyCell();
        this.currentCell = null;
        int i = 0;
        while (i < this.columnCount) {
            int n = i++;
            this.cells[n] = this.cells[n] - 1;
        }
    }

    protected void startCell(ICellContent cell) {
        if (this.needAddEmptyCell(cell)) {
            this.addEmptyCell(cell);
        }
    }

    protected void endCell(ICellContent cell) {
        this.currentCell = cell;
        int i = cell.getColumn();
        while (i < cell.getColumn() + cell.getColSpan()) {
            int n = i++;
            this.cells[n] = this.cells[n] + cell.getRowSpan();
        }
    }

    protected boolean isInvisibaleRow() {
        int i = 0;
        if (i < this.columnCount) {
            return this.cells[i] == 0;
        }
        return false;
    }

    protected void addEmptyCell() {
        if (this.isInvisibaleRow()) {
            int i = 0;
            while (i < this.columnCount) {
                int n = i++;
                this.cells[n] = this.cells[n] + 1;
            }
            return;
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.cells[i] == 0) {
                ICellContent newCell = null;
                if (this.currentCell != null) {
                    newCell = this.newCell(this.currentCell, i, i + 1);
                } else if (this.table != null) {
                    newCell = this.newCell(this.table.getReportContent().createCellContent(), i, i + 1);
                }
                if (newCell != null) {
                    this.emitter.startCell(newCell);
                    this.emitter.endCell(newCell);
                }
            }
            ++i;
        }
    }

    protected boolean needAddEmptyCell(ICellContent cell) {
        return cell.getColumn() > 0 && this.cells[cell.getColumn() - 1] == 0;
    }

    protected ICellContent newCell(ICellContent cell, int startCol, int endCol) {
        CellContentWrapper tempCell = new CellContentWrapper(cell);
        tempCell.setRowSpan(cell.getRowSpan());
        tempCell.setColumn(startCol);
        tempCell.setColSpan(endCol - startCol);
        return tempCell;
    }

    protected int getEmptyStartIndex(int columnIndex) {
        int i = 0;
        while (i < columnIndex) {
            if (this.cells[i] == 0) {
                return i;
            }
            ++i;
        }
        return columnIndex;
    }

    protected void addEmptyCell(ICellContent cell) {
        int endCol;
        int startCol = this.getEmptyStartIndex(cell.getColumn());
        if (startCol < (endCol = cell.getColumn())) {
            ICellContent newCell = this.newCell(this.currentCell == null ? cell : this.currentCell, startCol, endCol);
            this.emitter.startCell(newCell);
            this.emitter.endCell(newCell);
        }
    }
}

