/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.service.referential.ReferentialTemporarySpeciesService;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportExistingTemporarySpeciesAction
extends LongActionSupport<ManageTemporaryReferentialUIModel, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {
    private static final Log log = LogFactory.getLog(ExportExistingTemporarySpeciesAction.class);
    private File file;

    public ExportExistingTemporarySpeciesAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction;
        boolean bl = doAction = super.prepareAction() && ((ManageTemporaryReferentialUI)this.getUI()).getExportExistingSpeciesButton().isEnabled();
        if (doAction) {
            this.file = this.saveFile("exportTemporarySpecies", "csv", I18n.t((String)"tutti.manageTemporaryReferential.title.choose.exportExistingTemporarySpeciesFile", (Object[])new Object[0]), I18n.t((String)"tutti.manageTemporaryReferential.action.chooseExistingReferentialSpeciesFile.export", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export existing species temporary referential to file: " + this.file));
        }
        ReferentialTemporarySpeciesService service = this.getContext().getReferentialTemporarySpeciesService();
        service.exportExistingTemporarySpecies(this.file);
    }

    public void postSuccessAction() {
        ((ManageTemporaryReferentialUIHandler)this.getHandler()).resetComboBoxAction(((ManageTemporaryReferentialUI)this.getUI()).getSpeciesActionComboBox());
        super.postSuccessAction();
        this.sendMessage(I18n.t((String)"tutti.manageTemporaryReferential.action.chooseExistingReferentialSpeciesFile.export.success", (Object[])new Object[]{this.file}));
    }
}

