/* 
 * ===================================================================================
 * script upgrade_to_v3.1.0.sql
 * ===================================================================================
 */

/* Drop table DENORMALIZED_BATCH_SORT_VAL */
drop table DENORMALIZED_BATCH_SORT_VAL IF EXISTS;

/* Drop table DENORMALIZED_BATCH */
drop table DENORMALIZED_BATCH IF EXISTS;

/* Drop table DENORMALIZED_OPERATION */
drop table DENORMALIZED_OPERATION IF EXISTS;

/* Create table DENORMALIZED_BATCH */
create table DENORMALIZED_BATCH (
    ID BIGINT  not null,
    RANK_ORDER INTEGER not null,
    FLAT_RANK_ORDER INTEGER not null,
    WEIGHT REAL,
    WEIGHT_METHOD_FK INTEGER,
    INDIRECT_WEIGHT REAL,
    ELEVATE_WEIGHT REAL,
    INDIVIDUAL_COUNT INTEGER,
    INDIRECT_INDIVIDUAL_COUNT REAL,
    ELEVATE_INDIVIDUAL_COUNT REAL,
    SAMPLING_RATIO REAL,
    SAMPLING_RATIO_TEXT VARCHAR(50),
    EXHAUSTIVE_INVENTORY BOOLEAN not null,
    CHILD_BATCHS_REPLICATION BOOLEAN not null,
    COMMENTS VARCHAR(256),
    LEVEL INTEGER,
    TREE_INDENT VARCHAR(256),
    SORTING_VALUES_TEXT VARCHAR(256),
    PARENT_BATCH_FK BIGINT,
    TAXON_GROUP_FK BIGINT,
    INHERITED_TAXON_GROUP_FK BIGINT,
    CALCULATED_TAXON_GROUP_FK BIGINT,
    REFERENCE_TAXON_FK BIGINT,
    INHERITED_REFERENCE_TAXON_FK BIGINT,
    OPERATION_FK BIGINT,
    SALE_FK BIGINT,
    IS_LANDING BIT,
    IS_DISCARD BIT,
    primary key (ID)
  );

/* Create table DENORMALIZED_BATCH_SORT_VAL */
create table DENORMALIZED_BATCH_SORT_VAL (
    ID BIGINT not null,
    NUMERICAL_VALUE REAL,
    QUALITATIVE_VALUE_FK BIGINT,
    RANK_ORDER REAL,
    IS_INHERITED BOOLEAN not null,
    PMFM_FK BIGINT not null,
    PARAMETER_FK VARCHAR(256) not null,
    UNIT_FK VARCHAR(256) not null,
    BATCH_FK BIGINT,
    primary key (ID)
);

/* Create table DENORMALIZED_OPERATION */
create table DENORMALIZED_OPERATION (
    ID BIGINT not null,
    RANK_ORDER INTEGER not null,
    GEAR_FK INTEGER not null,
    METIER_FK INTEGER not null,
    FISHING_TRIP_FK BIGINT not null,
    IS_LANDING_SAMPLING BOOLEAN not null,
    IS_DISCARD_SAMPLING BOOLEAN not null,
    GEAR_MESH_SIZE REAL,
    GEAR_DEPTH REAL,
    SELECTION_DEVICE_QUALITATIVE_VALUE_FK INTEGER,
    MAIN_WATER_DEPTH REAL,
    RECTANGLE_LOCATION_FK INTEGER,
    primary key (ID)
);

/* Create constraints on DENORMALIZED_BATCH_SORT_VAL */
alter table DENORMALIZED_BATCH_SORT_VAL 
    add constraint DENORMALIZED_BATCH_SORT_VAL_C
        foreign key (BATCH_FK) 
        references DENORMALIZED_BATCH;

/* Create index on DENORMALIZED_BATCH */
create index IX_DENORMALIZED_BATCH_1 on DENORMALIZED_BATCH (OPERATION_FK, PARENT_BATCH_FK, RANK_ORDER);

/* Create index on DENORMALIZED_BATCH */
create index IX_DENORMALIZED_BATCH_2 on DENORMALIZED_BATCH (SALE_FK, PARENT_BATCH_FK, RANK_ORDER);

/* Create index on DENORMALIZED_BATCH */
create index IX_DENORMALIZED_BATCH_3 on DENORMALIZED_BATCH (TAXON_GROUP_FK, INHERITED_TAXON_GROUP_FK, REFERENCE_TAXON_FK, INHERITED_REFERENCE_TAXON_FK);

/* Create index on DENORMALIZED_BATCH_SORT_VAL */
create index IX_DENORMALIZED_BATCH_SORT_VAL_1 on DENORMALIZED_BATCH_SORT_VAL (BATCH_FK, RANK_ORDER);

/* Create index on DENORMALIZED_BATCH_SORT_VAL */
create index IX_DENORMALIZED_BATCH_SORT_VAL_2 on DENORMALIZED_BATCH_SORT_VAL (PMFM_FK, PARAMETER_FK, QUALITATIVE_VALUE_FK, UNIT_FK);

/* Create index on DENORMALIZED_OPERATION */
create index IX_DENORMALIZED_OPERATION_1 on DENORMALIZED_OPERATION (FISHING_TRIP_FK, METIER_FK, GEAR_FK, RANK_ORDER);

/* Drop table dual_DENORMALIZED_BATCH_SORT_SEQ */
drop table dual_DENORMALIZED_BATCH_SORT_SEQ IF EXISTS;

/* Drop sequence DENORMALIZED_BATCH_SORT_SEQ */
drop sequence DENORMALIZED_BATCH_SORT_SEQ IF EXISTS;

/* Create sequence DENORMALIZED_BATCH_SORT_SEQ (1/3)*/
create table dual_DENORMALIZED_BATCH_SORT_SEQ (
        zero integer
    );

/* Create sequence DENORMALIZED_BATCH_SORT_SEQ (2/3)*/
insert into dual_DENORMALIZED_BATCH_SORT_SEQ values (0);

/* Create sequence DENORMALIZED_BATCH_SORT_SEQ (3/3)*/
create sequence DENORMALIZED_BATCH_SORT_SEQ start with 1 increment by 1;


/* 
 * ===================================================================================
 * script upgrade_3.1.6_to_v3.2.2.sql
 * ===================================================================================
 */

/* add column ROOT_BATCH_FK batch */
alter table BATCH ADD COLUMN ROOT_BATCH_FK integer;

/* alter batch add constraint SORTING_BATCH_ROOT_BATCH_FKC */ 
alter table BATCH add constraint SORTING_BATCH_ROOT_BATCH_FKC foreign key (ROOT_BATCH_FK) references BATCH;

/* Clean table constraint DENORMALIZED_BATCH_SORT_VAL (mantis #12373 - 1/6) */
delete from DENORMALIZED_BATCH_SORT_VAL;

/* Drop constraint DENORMALIZED_BATCH_SORT_VAL_BC (mantis #12373 - 2/6) */
alter table DENORMALIZED_BATCH_SORT_VAL drop constraint DENORMALIZED_BATCH_SORT_VAL_BC;

/* Add constraint with 'on delete cascade' in DENORMALIZED_BATCH_SORT_VAL.BATCH_FK (mantis #12373 - 3/6) */
alter table DENORMALIZED_BATCH_SORT_VAL add constraint DENORMALIZED_BATCH_SORT_VAL_BC foreign key (BATCH_FK) references DENORMALIZED_BATCH on delete cascade;

/* Clean table constraint DENORMALIZED_OPERATION (mantis #12373 - 4/6) */
delete from DENORMALIZED_OPERATION;

/* Drop constraint DENORMALIZED_OPERATION_FISHINC (mantis #12373 - 5/6) */
alter table DENORMALIZED_OPERATION drop constraint DENORMALIZED_OPERATION_FISHINC;

/* Add constraint with 'on delete cascade' in DENORMALIZED_OPERATION.FISHING_TRIP_FK (mantis #12373 - 6/6) */
alter table DENORMALIZED_OPERATION add constraint DENORMALIZED_OPERATION_FISHINC foreign key (FISHING_TRIP_FK) references FISHING_TRIP on delete cascade;


/* create table PERSON_SESSION */
create table PERSON_SESSION (
            ID integer not null,
            UPDATE_DATE TIMESTAMP not null,
            PERSON_FK integer not null,
            primary key (ID)
    );

/* create table PERSON_SESSION_VESSEL */
create table PERSON_SESSION_VESSEL (
    START_DATE_TIME TIMESTAMP not null,
    PERSON_SESSION_FK integer not null,
    OBJECT_TYPE_FK VARCHAR(40) not null,
    VESSEL_FK VARCHAR(12) not null,
    PROGRAM_FK VARCHAR(40) not null,
    READ_VESSEL BIT not null,
    READ_DATA BIT not null,
    WRITE_DATA BIT not null,
    UPDATE_DATE TIMESTAMP,
    END_DATE_TIME TIMESTAMP not null,
    primary key (START_DATE_TIME, PERSON_SESSION_FK, OBJECT_TYPE_FK, VESSEL_FK, PROGRAM_FK)
);

/* create BATCH_EXHAUSTIVE_INVENTORY */     
select * into BATCH_EXHAUSTIVE_INVENTORY from BATCH_EXHAUTIVE_INVENTORY;

/* create dual_BATCH_EXHAUSTIVE_INVENTORY */ 
select * into dual_BATCH_EXHAUSTIVE_INVENTORY_SEQ from dual_BATCH_EXHAUTIVE_INVENTORY_SEQ;

/* drop BATCH_EXHAUTIVE_INVENTORY */ 
drop table BATCH_EXHAUTIVE_INVENTORY;

/* drop dual_BATCH_EXHAUSTIVE_INVENTORY */ 
drop table dual_BATCH_EXHAUTIVE_INVENTORY_SEQ;

/* drop sequence BATCH_EXHAUTIVE_INVENTORY_SEQ */ 
drop sequence BATCH_EXHAUTIVE_INVENTORY_SEQ; 

/*create index IX_RMTID_BATCH_EXHAUSTIVE_INVENTORY */         
create index IX_RMTID_BATCH_EXHAUSTIVE_INVENTORY on BATCH_EXHAUSTIVE_INVENTORY (REMOTE_ID);

/* add constraint BATCH_EXHAUSTIVE_INVENTORY_BAC */ 
alter table BATCH_EXHAUSTIVE_INVENTORY add constraint BATCH_EXHAUSTIVE_INVENTORY_BAC foreign key (BATCH_FK) references BATCH;
        
/* Drop index SALE_NATIDX (mantis #12669 - 1/2) */
DROP INDEX SALE_NATIDX;

/* Create index SALE_NATIDX with a new order (mantis #12669 - 2/2) */
CREATE INDEX SALE_NATIDX ON SALE(PROGRAM_FK,VESSEL_FK,SALE_START_DATE,DECLARED_DOCUMENT_REFERENCE_FK);

/*
 * ===================================================================================
 * script upgrade_to_v3.2.2.sql
 * ===================================================================================
 */
/* Drop constraint SORTING_BATCH_BATCH_FKC (mantis #10542 - 1/3) */
alter table BATCH drop constraint SORTING_BATCH_BATCH_FKC;

/* Rename BATCH_FK in ROOT_BATCH_FK (mantis #10542 - 2/3) */
Alter table BATCH ALTER COLUMN BATCH_FK RENAME TO ROOT_BATCH_FK;

/* Add constraint SORTING_BATCH_ROOT_BATCH_FKC (mantis #10542 - 4/4) */
alter table BATCH add constraint SORTING_BATCH_ROOT_BATCH_FKC foreign key (ROOT_BATCH_FK) references BATCH;

/* Drop index SALE_NATIDX (mantis #12669 - 1/2) */
DROP INDEX SALE_NATIDX;

/* Create index SALE_NATIDX with a new order (mantis #12669 - 2/2) */
CREATE INDEX SALE_NATIDX ON SALE(PROGRAM_FK,VESSEL_FK,SALE_START_DATE,DECLARED_DOCUMENT_REFERENCE_FK)

/* Clean table constraint DENORMALIZED_BATCH_SORT_VAL (mantis #12373 - 1/6) */
delete from DENORMALIZED_BATCH_SORT_VAL;

/* Drop constraint DENORMALIZED_BATCH_SORT_VAL_BC (mantis #12373 - 2/6) */
alter table DENORMALIZED_BATCH_SORT_VAL drop constraint DENORMALIZED_BATCH_SORT_VAL_BC;

/* Add constraint with 'on delete cascade' in DENORMALIZED_BATCH_SORT_VAL.BATCH_FK (mantis #12373 - 3/6) */
alter table DENORMALIZED_BATCH_SORT_VAL add constraint DENORMALIZED_BATCH_SORT_VAL_BC foreign key (BATCH_FK) references DENORMALIZED_BATCH on delete cascade;

/* Clean table constraint DENORMALIZED_OPERATION (mantis #12373 - 4/6) */
delete from DENORMALIZED_OPERATION;

/* Drop constraint DENORMALIZED_OPERATION_FISHINC (mantis #12373 - 5/6) */
alter table DENORMALIZED_OPERATION drop constraint DENORMALIZED_OPERATION_FISHINC;

/* Add constraint with 'on delete cascade' in DENORMALIZED_OPERATION.FISHING_TRIP_FK (mantis #12373 - 6/6) */
alter table DENORMALIZED_OPERATION add constraint DENORMALIZED_OPERATION_FISHINC foreign key (FISHING_TRIP_FK) references FISHING_TRIP on delete cascade;

/* Add PERSON_SESSION_VESSEL.UPDATE_DATE (mantis #10528 - 1/3) */
Alter table PERSON_SESSION_VESSEL ADD COLUMN UPDATE_DATE TIMESTAMP;

/* Drop constraint PERSON_SESSION_VES_PROGRAM_FKC (mantis #10528- 2/3) */
Alter table PERSON_SESSION_VESSEL drop constraint PERSON_SESSION_VES_PROGRAM_FKC;

/* Drop constraint PERSON_SESSION_VES_VESSEL_FKC (mantis #10528- 3/3) */
Alter table PERSON_SESSION_VESSEL drop constraint PERSON_SESSION_VES_VESSEL_FKC;

/* Create sequence BATCH_EXHAUSTIVE_INVENTORY_SEQ (mantis #12262)*/
CREATE SEQUENCE BATCH_EXHAUSTIVE_INVENTORY_SEQ AS INTEGER START WITH 0; 

/* Create dual table for sequence BATCH_EXHAUSTIVE_INVENTORY_SEQ (mantis #12262)*/
CREATE TABLE DUAL_BATCH_EXHAUSTIVE_INVENTORY_SEQ(ZERO INTEGER);

/* Init dual table for sequence BATCH_EXHAUSTIVE_INVENTORY_SEQ (mantis #12262)*/
INSERT INTO DUAL_BATCH_EXHAUSTIVE_INVENTORY_SEQ VALUES(0);

/* Drop constraint on table BATCH_EXHAUTIVE_INVENTORY (mantis #12262) */
ALTER TABLE BATCH_EXHAUTIVE_INVENTORY DROP CONSTRAINT BATCH_EXHAUTIVE_INVENTORY_BATC;

/* Create table BATCH_EXHAUSTIVE_INVENTORY (mantis #12262)*/
CREATE TABLE BATCH_EXHAUSTIVE_INVENTORY(ID INTEGER NOT NULL PRIMARY KEY,PRIORITY_LEVEL SMALLINT NOT NULL,REMOTE_ID INTEGER,BATCH_FK INTEGER NOT NULL,CONSTRAINT BATCH_EXHAUSTIVE_INVENTORY_BAC FOREIGN KEY(BATCH_FK) REFERENCES BATCH(ID));

/* Create index on BATCH_EXHAUSTIVE_INVENTORY for remote_id (mantis #12262)*/
CREATE INDEX IX_RMTID_BATCH_EXHAUSTIVE_INVENTORY ON BATCH_EXHAUSTIVE_INVENTORY(REMOTE_ID);

/* Copy data from BATCH_EXHAUTIVE_INVENTORY to BATCH_EXHAUSTIVE_INVENTORY (mantis #12262)*/
Insert into BATCH_EXHAUSTIVE_INVENTORY (ID,PRIORITY_LEVEL,REMOTE_ID,BATCH_FK)
select
    NEXT VALUE FOR BATCH_EXHAUSTIVE_INVENTORY_SEQ,
    PRIORITY_LEVEL,
    REMOTE_ID,
    BATCH_FK
from BATCH_EXHAUTIVE_INVENTORY;

/* Drop old sequence BATCH_EXHAUTIVE_INVENTORY_SEQ (mantis #12262) */
DROP SEQUENCE BATCH_EXHAUTIVE_INVENTORY_SEQ;

/* Drop old dual table for sequence BATCH_EXHAUTIVE_INVENTORY_SEQ (mantis #12262) */
DROP TABLE DUAL_BATCH_EXHAUTIVE_INVENTORY_SEQ;

/* commit */
Commit;


/* 
 * ===================================================================================
 * script upgrade_to_v3.3.0.sql
 * ===================================================================================
 */
/* Drop table DENORMALIZED_BATCH_OBSERVED_SALE */
drop table DENORMALIZED_BATCH_OBSERVED_SALE IF EXISTS;

/* Create table DENORMALIZED_BATCH_OBSERVED_SALE */
CREATE TABLE DENORMALIZED_BATCH_OBSERVED_SALE
(
   ID bigint,
   SALE_FK bigint,
   TAXON_GROUP_FK bigint,
   TAXON_GROUP_BATCH_FK bigint,
   TAXON_GROUP_SORTING_TYPE varchar,
   CATEGORY varchar,
   CATEGORY_BATCH_FK bigint,
   CASE_NAME varchar,
   CASE_BATCH_FK bigint,
   REF_TAXON_FK bigint,
   REF_TAXON_BATCH_FK bigint,
   SEX_AGE varchar,
   SEX_AGE_BATCH_FK bigint,
   LENGTH real,
   LENGTH_LABEL varchar,
   LENGTH_BATCH_FK bigint,
   PAGE integer,
   primary key (ID)
);

/* 12951 Ajout de la colonne QUALITY_FLAG_FK */
alter table denormalized_batch add QUALITY_FLAG_FK VARCHAR(40);

/* commit */
Commit;


/* 
 * ===================================================================================
 * script upgrade_to_v3.3.1.sql
 * ===================================================================================
 */
/* Ajout colonne DENORMALIZED_BATCH.ELEVATE_CONTEXT_WEIGHT (mantis #13713) */
ALTER TABLE DENORMALIZED_BATCH ADD ELEVATE_CONTEXT_WEIGHT REAL;

/* DELETE FROM PERSON_SESSION_VESSEL */
DELETE FROM PERSON_SESSION_VESSEL

/* DROP TABLE FROM PERSON_SESSION_VESSEL */
DROP TABLE PERSON_SESSION_VESSEL

/* create table PERSON_SESSION_VESSEL */
create table PERSON_SESSION_VESSEL ( ID BIGINT not null, READ_VESSEL BIT not null, READ_DATA BIT not null, WRITE_DATA BIT not null, VALIDATE_DATA BIT, START_DATE_TIME TIMESTAMP not null, END_DATE_TIME TIMESTAMP not null, UPDATE_DATE TIMESTAMP not null, OBJECT_TYPE_FK VARCHAR(40) not null, PROGRAM_FK VARCHAR(40) not null, PERSON_SESSION_FK integer not null, VESSEL_FK VARCHAR(12) not null, primary key (ID) );

/* create index PERSON_SESSION_VESSEL_NATIDX */
create index PERSON_SESSION_VESSEL_NATIDX on PERSON_SESSION_VESSEL (START_DATE_TIME, OBJECT_TYPE_FK, PROGRAM_FK, PERSON_SESSION_FK, VESSEL_FK);
    
/* alter table PERSON_SESSION_VESSEL add constraint PERSON_SESSION_VESSEL_PROGRAMC */
alter table PERSON_SESSION_VESSEL add constraint PERSON_SESSION_VESSEL_PROGRAMC foreign key (PROGRAM_FK) references PROGRAM;

/* alter table PERSON_SESSION_VESSEL add constraint PERSON_SESSION_VESSEL_FKC */
alter table PERSON_SESSION_VESSEL add constraint PERSON_SESSION_VESSEL_FKC foreign key (VESSEL_FK) references VESSEL;

/* alter table PERSON_SESSION_VESSEL add constraint PERSON_SESSION_VESSEL_OBJECT_C */
alter table PERSON_SESSION_VESSEL add constraint PERSON_SESSION_VESSEL_OBJECT_C foreign key (OBJECT_TYPE_FK) references OBJECT_TYPE;

/* alter table PERSON_SESSION_VESSEL add constraint PERSON_SESSION_VESSEL_PERSON_C */
alter table PERSON_SESSION_VESSEL add constraint PERSON_SESSION_VESSEL_PERSON_C foreign key (PERSON_SESSION_FK) references PERSON_SESSION;

/* Ajout table DENORMALIZED_SAMPLING_STRATA (mantis #12901) */
CREATE TABLE DENORMALIZED_SAMPLING_STRATA ( 
    ID integer not null,
    LABEL VARCHAR(40) not null, 
    START_DATE DATETIME, 
    END_DATE DATETIME,  
    DESCRIPTION VARCHAR(255),
    COMMENTS VARCHAR(2000),
    OBSERVATION_LOCATION_COMMENTS VARCHAR(100),
    SAMPLING_STRATEGY VARCHAR(100),
    TAXON_GROUP_NAME VARCHAR(100), 
    SAMPLING_SCHEME_LABEL VARCHAR(40) not null, 
    SAMPLING_SCHEME_NAME VARCHAR(100) not null, 
    SAMPLING_SCHEME_DESCRIPTION VARCHAR(255),
    GEAR_MESH_RANGE VARCHAR(100),
    VESSEL_LENGTH_RANGE VARCHAR(100),
    METIER VARCHAR(255),
    AREA_NAME VARCHAR(100),
    SUB_AREA_LOCATION_IDS VARCHAR(255), 
    PERSON_FK integer,
    OBSERVATION_LOCATION_FK integer,
    PROGRAM_FK VARCHAR(40) not null, 
    DEPARTMENT_FK integer,       
    UPDATE_DATE TIMESTAMP,
    primary key (ID)
);

/* DENORMALIZED_SAMPLING_STRATA (mantis #12901) - cl trangre vers Department */
alter table DENORMALIZED_SAMPLING_STRATA add constraint DENORMALIZED_SAMPLING_STRATA_C foreign key (DEPARTMENT_FK) references DEPARTMENT;
/* DENORMALIZED_SAMPLING_STRATA (mantis #12901) - cl trangre vers Program */
alter table DENORMALIZED_SAMPLING_STRATA add constraint DENORMALIZED_SAMPLING_STRATA_L foreign key (PROGRAM_FK) references PROGRAM;
/* DENORMALIZED_SAMPLING_STRATA (mantis #12901) - cl trangre vers Person */
alter table DENORMALIZED_SAMPLING_STRATA add constraint DENORMALIZED_SAMPLING_STRATA__ foreign key (PERSON_FK) references PERSON;
/* DENORMALIZED_SAMPLING_STRATA (mantis #12901) - cl trangre vers Location */
alter table DENORMALIZED_SAMPLING_STRATA add constraint DENORMALIZED_SAMPLING_STRATA_P foreign key (OBSERVATION_LOCATION_FK) references LOCATION;

/* 12901 - lien fishingTrip-samplingStrata - colonne pour la cl trangre */
ALTER TABLE FISHING_TRIP ADD COLUMN SAMPLING_STRATA_FK INTEGER;
/* 12901 - lien fishingTrip-samplingStrata - contrainte d'intgrit sur la cl trangre */
ALTER TABLE FISHING_TRIP ADD CONSTRAINT OBSERVED_FISHING_TRIP_SAMPLINC FOREIGN KEY (SAMPLING_STRATA_FK) REFERENCES DENORMALIZED_SAMPLING_STRATA;
/* 12901 - lien sale-samplingStrata - colonne pour la cl trangre */
ALTER TABLE SALE ADD COLUMN SAMPLING_STRATA_FK INTEGER;
/* 12901 - lien sale-samplingStrata - contrainte d'intgrit sur la cl trangre */
ALTER TABLE SALE ADD CONSTRAINT OBSERVED_SALE_SAMPLING_STRATAC FOREIGN KEY (SAMPLING_STRATA_FK) REFERENCES DENORMALIZED_SAMPLING_STRATA;
/* 12901 - suppression colonne obsolte FISHING_TRIP.SAMPLING_PLAN_REFERENCE */
ALTER TABLE FISHING_TRIP DROP COLUMN SAMPLING_PLAN_REFERENCE;
/* 12901 - suppression colonne obsolte SALE.SAMPLING_PLAN_REFERENCE */
ALTER TABLE SALE DROP COLUMN SAMPLING_PLAN_REFERENCE;

/* 13091 - Ajout des colonnes location_fk dans la table batch */
ALTER TABLE BATCH ADD COLUMN LOCATION_FK INTEGER;
/* 13091 - Ajout des colonnes label dans la table batch */
ALTER TABLE BATCH ADD COLUMN LABEL VARCHAR(40);
/* 13091 - lien batch-location - contrainte d'intgrit sur la cl trangre */
ALTER TABLE BATCH add constraint BATCH_LOCATION_FKC foreign key (LOCATION_FK) references LOCATION;


/* commit */
Commit;


/* 
 * ===================================================================================
 * script upgrade_upgrade_to_v3.3.4.e.sql
 * ===================================================================================
 */

/* Mise  jour de la colonne BATCH.quality_flag_fk (mantis #14915) */
update batch set quality_flag_fk = 0 where quality_flag_fk is null;

/* Ajout de la contrainte not null */
alter table batch alter column quality_flag_fk set not null;

/* commit */
Commit;


/* 
 * ===================================================================================
 * script upgrade_to_v3.3.4.f.sql
 * ===================================================================================
 */

/* Suppression de la cl unique des ventes */
DROP INDEX SALE_NATIDX;

/* commit */
Commit;