// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.taxon;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;

/**
 * Type de groupe de taxon.
 * On distingue plusieurs types de regroupements de taxons :
 * - les groupes descriptifs des taxons, et utilisés à l'extraction des données (groupes écologiques
 * par exemple)
 * - les groupes utilisés pour l'identification sur les navires de pêche ou dans les criées : espèce
 * commerciale, ou espèce communes (nom vernaculaire)
 * -  ...
 */
// HibernateEntity.vsl annotations merge-point
public abstract class TaxonGroupType
    implements Serializable, Comparable<TaxonGroupType>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -6658880623947843642L;

    // Generate 3 attributes
    private String code;

    /**
     * Code unique du groupe de taxons.
     * @return this.code String
     */
    public String getCode()
    {
        return this.code;
    }

    /**
     * Code unique du groupe de taxons.
     * @param codeIn String
     */
    public void setCode(String codeIn)
    {
        this.code = codeIn;
    }

    private String name;

    /**
     * Libellé (court) décrivant le type de groupe de taxon.
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Libellé (court) décrivant le type de groupe de taxon.
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 2 associations
    private Collection<TaxonGroup> taxonGroups = new HashSet<TaxonGroup>();

    /**
     * Il désigne un ensemble de taxons appartenant à des groupes taxinomiques différents mais ayant
     * les
     * mêmes caractéristiques pour un critère donné. Ce critère peut être morpho-anatomique (par
     * exemple
     * les strates algales ou la taille des organismes), comportemental (par exemple des groupes
     * trophiques
     * ou des modes de déplacement), ou encore basé sur des notions plus complexes comme la
     * polluo-sensibilité (exemple des groupes écologiques définis pour les macroinvertébrés
     * benthiques).
     * Pour un critère donné, les groupes de taxons sont rassemblés dans un regroupement appelé
     * groupe de
     * taxons père.
     * Les groupes de taxons sont de deux catégories :
     * - Descriptif : c'est à dire seulement utilisé pour l'extraction de données. Les regroupements
     * de
     * taxons sont effectués en aval de la mesure effectuée.
     * - Identification : il s'agit de regroupements utilisés pour identifier des catégories de
     * taxons sur
     * le terrain ou en laboratoire, lorsqu'il est difficile d'opérer une identification précise ou
     * lorsque
     * celle-ci s'avère tout simplement impossible ou non pertinente. Le regroupement des taxons
     * s'effectue
     * alors en amont de la mesure.
     * Certains groupes peuvent être figés, c'est à dire qu'ils sont définis une bonne fois pour
     * toute dans
     * un document. Pour ce dernier cas particulier, il n'y a donc, a priori, pas besoin de mise à
     * jour, et
     * encore moins de pouvoir les supprimer : ils sont donc non modifiables (mais ce ne doit pas
     * être une
     * règle générale)
     * @return this.taxonGroups Collection<TaxonGroup>
     */
    public Collection<TaxonGroup> getTaxonGroups()
    {
        return this.taxonGroups;
    }

    /**
     * Il désigne un ensemble de taxons appartenant à des groupes taxinomiques différents mais ayant
     * les
     * mêmes caractéristiques pour un critère donné. Ce critère peut être morpho-anatomique (par
     * exemple
     * les strates algales ou la taille des organismes), comportemental (par exemple des groupes
     * trophiques
     * ou des modes de déplacement), ou encore basé sur des notions plus complexes comme la
     * polluo-sensibilité (exemple des groupes écologiques définis pour les macroinvertébrés
     * benthiques).
     * Pour un critère donné, les groupes de taxons sont rassemblés dans un regroupement appelé
     * groupe de
     * taxons père.
     * Les groupes de taxons sont de deux catégories :
     * - Descriptif : c'est à dire seulement utilisé pour l'extraction de données. Les regroupements
     * de
     * taxons sont effectués en aval de la mesure effectuée.
     * - Identification : il s'agit de regroupements utilisés pour identifier des catégories de
     * taxons sur
     * le terrain ou en laboratoire, lorsqu'il est difficile d'opérer une identification précise ou
     * lorsque
     * celle-ci s'avère tout simplement impossible ou non pertinente. Le regroupement des taxons
     * s'effectue
     * alors en amont de la mesure.
     * Certains groupes peuvent être figés, c'est à dire qu'ils sont définis une bonne fois pour
     * toute dans
     * un document. Pour ce dernier cas particulier, il n'y a donc, a priori, pas besoin de mise à
     * jour, et
     * encore moins de pouvoir les supprimer : ils sont donc non modifiables (mais ce ne doit pas
     * être une
     * règle générale)
     * @param taxonGroupsIn Collection<TaxonGroup>
     */
    public void setTaxonGroups(Collection<TaxonGroup> taxonGroupsIn)
    {
        this.taxonGroups = taxonGroupsIn;
    }

    /**
     * Il désigne un ensemble de taxons appartenant à des groupes taxinomiques différents mais ayant
     * les
     * mêmes caractéristiques pour un critère donné. Ce critère peut être morpho-anatomique (par
     * exemple
     * les strates algales ou la taille des organismes), comportemental (par exemple des groupes
     * trophiques
     * ou des modes de déplacement), ou encore basé sur des notions plus complexes comme la
     * polluo-sensibilité (exemple des groupes écologiques définis pour les macroinvertébrés
     * benthiques).
     * Pour un critère donné, les groupes de taxons sont rassemblés dans un regroupement appelé
     * groupe de
     * taxons père.
     * Les groupes de taxons sont de deux catégories :
     * - Descriptif : c'est à dire seulement utilisé pour l'extraction de données. Les regroupements
     * de
     * taxons sont effectués en aval de la mesure effectuée.
     * - Identification : il s'agit de regroupements utilisés pour identifier des catégories de
     * taxons sur
     * le terrain ou en laboratoire, lorsqu'il est difficile d'opérer une identification précise ou
     * lorsque
     * celle-ci s'avère tout simplement impossible ou non pertinente. Le regroupement des taxons
     * s'effectue
     * alors en amont de la mesure.
     * Certains groupes peuvent être figés, c'est à dire qu'ils sont définis une bonne fois pour
     * toute dans
     * un document. Pour ce dernier cas particulier, il n'y a donc, a priori, pas besoin de mise à
     * jour, et
     * encore moins de pouvoir les supprimer : ils sont donc non modifiables (mais ce ne doit pas
     * être une
     * règle générale)
     * @param elementToAdd TaxonGroup
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addTaxonGroups(TaxonGroup elementToAdd)
    {
        return this.taxonGroups.add(elementToAdd);
    }

    /**
     * Il désigne un ensemble de taxons appartenant à des groupes taxinomiques différents mais ayant
     * les
     * mêmes caractéristiques pour un critère donné. Ce critère peut être morpho-anatomique (par
     * exemple
     * les strates algales ou la taille des organismes), comportemental (par exemple des groupes
     * trophiques
     * ou des modes de déplacement), ou encore basé sur des notions plus complexes comme la
     * polluo-sensibilité (exemple des groupes écologiques définis pour les macroinvertébrés
     * benthiques).
     * Pour un critère donné, les groupes de taxons sont rassemblés dans un regroupement appelé
     * groupe de
     * taxons père.
     * Les groupes de taxons sont de deux catégories :
     * - Descriptif : c'est à dire seulement utilisé pour l'extraction de données. Les regroupements
     * de
     * taxons sont effectués en aval de la mesure effectuée.
     * - Identification : il s'agit de regroupements utilisés pour identifier des catégories de
     * taxons sur
     * le terrain ou en laboratoire, lorsqu'il est difficile d'opérer une identification précise ou
     * lorsque
     * celle-ci s'avère tout simplement impossible ou non pertinente. Le regroupement des taxons
     * s'effectue
     * alors en amont de la mesure.
     * Certains groupes peuvent être figés, c'est à dire qu'ils sont définis une bonne fois pour
     * toute dans
     * un document. Pour ce dernier cas particulier, il n'y a donc, a priori, pas besoin de mise à
     * jour, et
     * encore moins de pouvoir les supprimer : ils sont donc non modifiables (mais ce ne doit pas
     * être une
     * règle générale)
     * @param elementToRemove TaxonGroup
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeTaxonGroups(TaxonGroup elementToRemove)
    {
        return this.taxonGroups.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an TaxonGroupType instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof TaxonGroupType))
        {
            return false;
        }
        final TaxonGroupType that = (TaxonGroupType)object;
        if (this.code == null || that.getCode() == null || !this.code.equals(that.getCode()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.code == null ? 0 : this.code.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link TaxonGroupType}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link TaxonGroupType}.
         * @return new TaxonGroupTypeImpl()
         */
        public static TaxonGroupType newInstance()
        {
            return new TaxonGroupTypeImpl();
        }

        /**
         * Constructs a new instance of {@link TaxonGroupType}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @return newInstance
         */
        public static TaxonGroupType newInstance(String name)
        {
            final TaxonGroupType entity = new TaxonGroupTypeImpl();
            entity.setName(name);
            return entity;
        }

        /**
         * Constructs a new instance of {@link TaxonGroupType}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @param updateDate Timestamp
         * @param taxonGroups Collection<TaxonGroup>
         * @return newInstance TaxonGroupType
         */
        public static TaxonGroupType newInstance(String name, Timestamp updateDate, Collection<TaxonGroup> taxonGroups)
        {
            final TaxonGroupType entity = new TaxonGroupTypeImpl();
            entity.setName(name);
            entity.setUpdateDate(updateDate);
            entity.setTaxonGroups(taxonGroups);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(TaxonGroupType o)
    {
        int cmp = 0;
        if (this.getCode() != null)
        {
            cmp = this.getCode().compareTo(o.getCode());
        }
        else
        {
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// TaxonGroupType.java merge-point
}